/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.activity.internal.jaxrs;

import javax.ws.rs.core.Response;
import org.eclipse.osee.activity.api.ActivityEntry;
import org.eclipse.osee.activity.api.ActivityEntryId;
import org.eclipse.osee.activity.api.ActivityLog;
import org.eclipse.osee.activity.api.ActivityLogEndpoint;
import org.eclipse.osee.framework.core.data.ActivityTypeId;
import org.eclipse.osee.framework.core.data.ActivityTypeToken;
import org.eclipse.osee.framework.jdk.core.util.Conditions;

public final class ActivityLogResource
implements ActivityLogEndpoint {
    private final ActivityLog activityLog;

    public ActivityLogResource(ActivityLog activityLog) {
        this.activityLog = activityLog;
    }

    public ActivityEntry getEntry(ActivityEntryId entryId) {
        Conditions.checkNotNull((Object)entryId, (String)"activity entry id");
        return this.activityLog.getEntry(entryId);
    }

    public ActivityEntryId createEntry(ActivityTypeId type, Long parentId, Integer status, String message) {
        Long entryId = this.activityLog.createEntry(this.activityLog.getActivityType(type), parentId, status, new Object[]{message});
        return new ActivityEntryId(entryId);
    }

    public Response updateEntry(Long entryId, Integer statusId) {
        this.activityLog.updateEntry(entryId, statusId);
        return Response.ok().build();
    }

    public ActivityTypeToken createIfAbsent(ActivityTypeToken activityType) {
        return this.activityLog.createIfAbsent(activityType);
    }
}

