/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.activity.internal;

import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.osee.framework.jdk.core.type.Id;

public final class ActivityMonitor {
    private final ConcurrentHashMap<Thread, Object[]> threadToRootEntry = new ConcurrentHashMap();
    private final ConcurrentHashMap<Long, Object[]> parentToRootEntry = new ConcurrentHashMap();
    private final Object[] defaultRootEntry;

    public ActivityMonitor(Object[] defaultRootEntry) {
        this.defaultRootEntry = defaultRootEntry;
        this.parentToRootEntry.put(Id.SENTINEL, defaultRootEntry);
    }

    public Object[] getDefaultRootEntry() {
        return this.defaultRootEntry;
    }

    public Object[] getThreadRootEntry() {
        Object[] threadRootEntry = this.threadToRootEntry.get(Thread.currentThread());
        if (threadRootEntry == null) {
            threadRootEntry = this.defaultRootEntry;
        }
        return threadRootEntry;
    }

    public Object[] getThreadRootEntry(Long parentId) {
        Object[] threadRootEntry = this.parentToRootEntry.get(parentId);
        if (threadRootEntry == null) {
            threadRootEntry = this.getThreadRootEntry();
        }
        return threadRootEntry;
    }

    public synchronized Iterable<Thread> getActiveThreads() {
        Set threads = this.threadToRootEntry.keySet();
        Iterator threadIter = threads.iterator();
        while (threadIter.hasNext()) {
            if (((Thread)threadIter.next()).isAlive()) continue;
            threadIter.remove();
        }
        return threads;
    }

    public void addActivityThread(Object[] activityEntry) {
        this.threadToRootEntry.put(Thread.currentThread(), activityEntry);
    }

    public void removeActivityThread() {
        this.threadToRootEntry.remove(Thread.currentThread());
    }
}

