/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jdbc.internal;

import java.lang.reflect.Constructor;
import org.eclipse.osee.framework.jdk.core.result.XConsoleLogger;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.jdbc.JdbcException;
import org.eclipse.osee.jdbc.JdbcLogger;
import org.eclipse.osee.jdbc.JdbcServer;
import org.eclipse.osee.jdbc.JdbcServerConfig;

public final class JdbcServerFactory {
    private JdbcServerFactory() {
    }

    private static Class<JdbcServer> getJdbcServerImplClass(String serverClassName) throws ClassNotFoundException {
        return Class.forName(serverClassName);
    }

    public static JdbcServer newJbdcServer(JdbcServerConfig config, boolean loggingEnabled, JdbcLogger logger) {
        if (loggingEnabled && logger == null) {
            logger = JdbcServerFactory.newConsoleLogger();
        }
        String serverClassName = config.getServerImplClassName();
        try {
            Class<JdbcServer> clazz = JdbcServerFactory.getJdbcServerImplClass(serverClassName);
            Constructor<JdbcServer> constructor = clazz.getConstructor(JdbcLogger.class, JdbcServerConfig.class);
            return constructor.newInstance(logger, config);
        }
        catch (ClassNotFoundException ex) {
            throw JdbcException.newJdbcException(ex, "Unable to find class [%s]", serverClassName);
        }
        catch (Exception ex) {
            throw JdbcException.newJdbcException(ex, "Error instantiating class [%s]", serverClassName);
        }
    }

    public static JdbcLogger newConsoleLogger() {
        return new JdbcLogger(){

            @Override
            public void info(String msg, Object ... data) {
                if (data.length > 0) {
                    System.out.printf(msg, data);
                    System.out.println();
                } else {
                    System.out.println(msg);
                }
            }

            @Override
            public void error(String msg, Object ... data) {
                if (data.length > 0) {
                    XConsoleLogger.err((String)(String.valueOf(msg) + "\n"), (Object[])data);
                } else {
                    XConsoleLogger.err((String)msg, (Object[])new Object[0]);
                }
            }

            @Override
            public void debug(String msg, Object ... data) {
                this.info(msg, data);
            }

            @Override
            public void error(Throwable ex, String msg, Object ... data) {
                this.error(msg, data);
                if (ex != null) {
                    this.error(Lib.exceptionToString((Throwable)ex), new Object[0]);
                }
            }
        };
    }
}

