/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.coverage.internal;

import java.util.Collection;
import org.eclipse.osee.coverage.CoverageProgramApi;
import org.eclipse.osee.coverage.CoverageProgramEndpoint;
import org.eclipse.osee.coverage.internal.CoverageProgramToken;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class CoverageProgramEndpointImpl
implements CoverageProgramEndpoint {
    private final CoverageProgramApi coverageProgramApi;
    private final BranchId branch;

    public CoverageProgramEndpointImpl(BranchId branch, CoverageProgramApi coverageProgramApi) {
        this.coverageProgramApi = coverageProgramApi;
        this.branch = branch;
    }

    @Override
    public Collection<CoverageProgramToken> getAllScriptSets(String filter, ArtifactId viewId, long pageNum, long pageSize, AttributeTypeToken orderByAttributeType, boolean activeOnly) {
        ArtifactId artifactId = viewId = viewId.isValid() ? viewId : ArtifactId.SENTINEL;
        if (Strings.isValid((String)filter)) {
            return this.coverageProgramApi.getAllByFilter(this.branch, viewId, filter, pageNum, pageSize, (AttributeTypeId)orderByAttributeType, activeOnly);
        }
        return this.coverageProgramApi.getAll(this.branch, viewId, pageNum, pageSize, (AttributeTypeId)orderByAttributeType, activeOnly);
    }

    @Override
    public CoverageProgramToken getCoverageProgram(ArtifactId coverageProgramId) {
        return this.coverageProgramApi.get(this.branch, coverageProgramId);
    }

    @Override
    public int getCount(String filter, ArtifactId viewId) {
        return this.coverageProgramApi.getCountWithFilter(this.branch, viewId, filter);
    }
}

