/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.coverage.internal;

import java.util.Collection;
import org.eclipse.osee.coverage.CoverageItemApi;
import org.eclipse.osee.coverage.CoverageItemEndpoint;
import org.eclipse.osee.coverage.internal.CoverageItemToken;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class CoverageItemEndpointImpl
implements CoverageItemEndpoint {
    private final CoverageItemApi coverageItemApi;
    private final BranchId branch;

    public CoverageItemEndpointImpl(BranchId branch, CoverageItemApi coverageItemApi) {
        this.coverageItemApi = coverageItemApi;
        this.branch = branch;
    }

    @Override
    public Collection<CoverageItemToken> getAllCoverageItems(String filter, ArtifactId viewId, long pageNum, long pageSize, AttributeTypeToken orderByAttributeType, boolean activeOnly) {
        ArtifactId artifactId = viewId = viewId.isValid() ? viewId : ArtifactId.SENTINEL;
        if (Strings.isValid((String)filter)) {
            return this.coverageItemApi.getAllByFilter(this.branch, viewId, filter, pageNum, pageSize, (AttributeTypeId)orderByAttributeType);
        }
        return this.coverageItemApi.getAll(this.branch, viewId, pageNum, pageSize, (AttributeTypeId)orderByAttributeType);
    }

    @Override
    public CoverageItemToken getCoverageItem(ArtifactId coverageItemId) {
        return this.coverageItemApi.get(this.branch, coverageItemId);
    }

    @Override
    public int getCount(String filter, ArtifactId viewId) {
        return this.coverageItemApi.getCountWithFilter(this.branch, viewId, filter);
    }
}

