/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util.xml;

import java.io.StringWriter;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.framework.jdk.core.text.change.ChangeSet;
import org.eclipse.osee.framework.jdk.core.type.CharSequenceWindow;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;

public class XmlEncoderDecoder {
    public static int DONT_DOUBLE_QUOTE = 1;
    public static int ESCAPE_NUMERIC = 2;
    public static int REMOVE_INVALID_CHARS = 4;
    public static int REMOVE_TAGS = 8;
    public static final Pattern textToXmlPattern = Pattern.compile("[&'<>\"]");
    public static final Pattern textToXmlEscapeNumericPattern = Pattern.compile("[&'<>\"\u0000-\u001a\u0080-\u9fff]");
    public static final Pattern textToXmlSkipPattern = Pattern.compile("&amp;|&apos;|&lt;|&gt;|&quot;|&#x[A-Fa-f0-9]+;|&#[0-9]+;");
    private static char[] xmlAmp = new char[]{'&', 'a', 'm', 'p', ';'};
    private static char[] xmlApos = new char[]{'&', 'a', 'p', 'o', 's', ';'};
    private static char[] xmlGt = new char[]{'&', 'g', 't', ';'};
    private static char[] xmlLt = new char[]{'&', 'l', 't', ';'};
    private static char[] xmlQuot = new char[]{'&', 'q', 'u', 'o', 't', ';'};
    private static Pattern xmlToTextPattern = Pattern.compile("&amp;|&apos;|&lt;|&gt;|&quot;");
    private static Pattern xmlToTextEscapeNumericPattern = Pattern.compile("&amp;|&apos;|&lt;|&gt;|&quot;|&#([0-9]+|x[0-9A-Fa-f]+);");
    private static Pattern xmlToTextRemoveTagsPattern = Pattern.compile("<[^>]+>|&amp;|&apos;|&lt;|&gt;|&quot;");
    private static Pattern xmlToTextEscapeNumericRemoveTagsPattern = Pattern.compile("<[^>]+>|&amp;|&apos;|&lt;|&gt;|&quot;|&#([0-9]+|x[0-9A-Fa-f]+);");

    private XmlEncoderDecoder() {
    }

    public static final boolean isValidCodePoint(int codePoint) {
        return codePoint == 9 || codePoint == 10 || codePoint == 13 || codePoint >= 32 && codePoint <= 55295 || codePoint >= 57344 && codePoint <= 65533 || codePoint >= 65536 && codePoint <= 0x10FFFF;
    }

    public static CharSequence textToXml(CharSequence input) {
        return XmlEncoderDecoder.textToXml(input, 0);
    }

    public static CharSequence textToXml(CharSequence input, int options) {
        boolean dontDoubleQuote = (options & DONT_DOUBLE_QUOTE) > 0;
        boolean escapeNumeric = (options & ESCAPE_NUMERIC) > 0;
        boolean removeInvalidChars = (options & REMOVE_INVALID_CHARS) > 0;
        ChangeSet changeSet = new ChangeSet(input);
        int sizePlus = 0;
        int i = 0;
        int e = input.length();
        while (i < e) {
            char c = input.charAt(i);
            if ((escapeNumeric || removeInvalidChars) && (c < ' ' || c >= '\u0080')) {
                int codePoint = Character.codePointAt(input, i);
                int end = i + Character.charCount(codePoint);
                if (XmlEncoderDecoder.isValidCodePoint(codePoint)) {
                    if (escapeNumeric) {
                        String hexString = Integer.toHexString(codePoint);
                        changeSet.replace(i, end, "&#x");
                        changeSet.insertBefore(end, hexString);
                        changeSet.insertBefore(end, ";");
                        sizePlus += 4 + hexString.length();
                    }
                } else if (removeInvalidChars) {
                    changeSet.delete(i, end);
                }
                i = end - 1;
            } else {
                switch (c) {
                    case '&': {
                        CharSequenceWindow tail;
                        Matcher skipMatcher;
                        if (dontDoubleQuote && (skipMatcher = textToXmlSkipPattern.matcher(tail = new CharSequenceWindow(input, i))).lookingAt()) break;
                        changeSet.replace(i, i + 1, xmlAmp);
                        sizePlus += 4;
                        break;
                    }
                    case '\'': {
                        changeSet.replace(i, i + 1, xmlApos);
                        sizePlus += 5;
                        break;
                    }
                    case '>': {
                        changeSet.replace(i, i + 1, xmlGt);
                        sizePlus += 3;
                        break;
                    }
                    case '<': {
                        changeSet.replace(i, i + 1, xmlLt);
                        sizePlus += 3;
                        break;
                    }
                    case '\"': {
                        changeSet.replace(i, i + 1, xmlQuot);
                        sizePlus += 5;
                    }
                }
            }
            ++i;
        }
        if (!changeSet.hasChanges()) {
            return input;
        }
        try {
            Throwable throwable = null;
            Object var8_11 = null;
            try (StringWriter stringWriter = new StringWriter(input.length() + sizePlus);){
                changeSet.applyChanges(stringWriter);
                StringBuffer result = stringWriter.getBuffer();
                return result;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            return input;
        }
    }

    public static CharSequence xmlToText(CharSequence input) {
        return XmlEncoderDecoder.xmlToText(input, 0);
    }

    public static CharSequence xmlToText(CharSequence input, int options) {
        int patternOption = ((options & ESCAPE_NUMERIC) > 0 ? 1 : 0) + ((options & REMOVE_TAGS) > 0 ? 2 : 0);
        ChangeSet changeSet = null;
        Matcher matcher = null;
        switch (patternOption) {
            case 0: {
                matcher = xmlToTextPattern.matcher(input);
                break;
            }
            case 1: {
                matcher = xmlToTextEscapeNumericPattern.matcher(input);
                break;
            }
            case 2: {
                matcher = xmlToTextRemoveTagsPattern.matcher(input);
                break;
            }
            case 3: {
                matcher = xmlToTextEscapeNumericRemoveTagsPattern.matcher(input);
            }
        }
        while (matcher.find()) {
            changeSet = Objects.isNull(changeSet) ? new ChangeSet(input) : changeSet;
            String group = matcher.group();
            if (group.charAt(0) == '<') {
                changeSet.delete(matcher.start(), matcher.end());
                continue;
            }
            switch (group.charAt(1)) {
                case 'a': {
                    changeSet.replace(matcher.start(), matcher.end(), group.charAt(2) == 'm' ? (char)'&' : '\'');
                    break;
                }
                case 'l': {
                    changeSet.replace(matcher.start(), matcher.end(), '<');
                    break;
                }
                case 'g': {
                    changeSet.replace(matcher.start(), matcher.end(), '>');
                    break;
                }
                case 'q': {
                    changeSet.replace(matcher.start(), matcher.end(), '\"');
                    break;
                }
                case '#': {
                    CharSequenceWindow numberCode = new CharSequenceWindow(input, matcher.start(1), matcher.end(1));
                    char firstChar = numberCode.charAt(0);
                    int codePoint = firstChar == 'x' ? Integer.parseUnsignedInt(numberCode, 1, numberCode.length(), 16) : Integer.parseUnsignedInt(numberCode, 0, numberCode.length(), 10);
                    char[] chars = Character.toChars(codePoint);
                    changeSet.replace(matcher.start(), matcher.end(), chars);
                }
            }
        }
        if (Objects.isNull(changeSet)) {
            return input;
        }
        try {
            Throwable throwable = null;
            Object var6_7 = null;
            try (StringWriter stringWriter = new StringWriter(input.length());){
                changeSet.applyChanges(stringWriter);
                StringBuffer result = stringWriter.getBuffer();
                return result;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            throw new OseeCoreException("Xml::xmlToText, failed to write changes to StringWriter.", new Object[0]);
        }
    }
}

