/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util.io.xml;

import java.io.IOException;
import java.util.Arrays;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public final class ExcelColumn {
    private static final int DEFAULT_COLUMN_WIDTH = 85;
    private final double columnWidth;
    private final String styleId;
    private final String name;

    private ExcelColumn(String name, double columnWidth, String styleId) {
        this.name = name;
        this.columnWidth = columnWidth;
        this.styleId = styleId;
    }

    private ExcelColumn(double columnWidth) {
        this(null, columnWidth, null);
    }

    private ExcelColumn(String name, double columnWidth) {
        this(name, columnWidth, null);
    }

    public static ExcelColumn newCol(double columnWidth) {
        return new ExcelColumn(columnWidth);
    }

    public static ExcelColumn newCol(String name, double columnWidth) {
        return new ExcelColumn(name, columnWidth);
    }

    public static ExcelColumn newCol(String name, double columnWidth, String styleId) {
        return new ExcelColumn(name, columnWidth, styleId);
    }

    public void writeColumnDefinition(Appendable out) throws IOException {
        out.append("   <Column ss:Width=\"");
        out.append(String.valueOf(this.columnWidth));
        if (Strings.isValid(this.styleId)) {
            out.append("\" ss:StyleID=\"");
            out.append(this.styleId);
        }
        out.append("\"/>\n");
    }

    public static ExcelColumn[] newEmptyColumns(int columnCount) {
        return ExcelColumn.newEqualWidthColumns(columnCount, 85.0);
    }

    public static ExcelColumn[] newEqualWidthColumns(int columnCount, double columnWidth) {
        double[] columnWidths = new double[columnCount];
        Arrays.fill(columnWidths, columnWidth);
        return ExcelColumn.newColumns(columnWidths);
    }

    public static ExcelColumn[] newColumns(double ... columnWidths) {
        ExcelColumn[] columns = new ExcelColumn[columnWidths.length];
        int i = 0;
        while (i < columnWidths.length) {
            columns[i] = new ExcelColumn(columnWidths[i]);
            ++i;
        }
        return columns;
    }

    public String getName() {
        return this.name;
    }
}

