/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util.io.excel;

import java.util.HashMap;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.eclipse.osee.framework.jdk.core.util.io.excel.ExcelWorkbookReader;
import org.eclipse.osee.framework.jdk.core.util.io.excel.ExcelWorkbookWriter;

public class ExcelWorkbookUtils {
    public static void copyActiveSheet(ExcelWorkbookReader copyFromReader, ExcelWorkbookWriter copyToWriter) {
        Sheet srcSheet = copyFromReader.getActiveSheet();
        Sheet newSheet = copyToWriter.getActiveSheet();
        int maxColumnNum = 0;
        HashMap<Integer, CellStyle> styleMap = new HashMap<Integer, CellStyle>();
        int i = srcSheet.getFirstRowNum();
        while (i <= srcSheet.getLastRowNum()) {
            Row srcRow = srcSheet.getRow(i);
            Row newRow = newSheet.createRow(i);
            if (srcRow != null) {
                ExcelWorkbookUtils.copyRow(copyToWriter.getWorkbook(), srcRow, newRow, styleMap);
                maxColumnNum = Math.max(maxColumnNum, srcRow.getLastCellNum());
            }
            ++i;
        }
        i = 0;
        while (i <= maxColumnNum) {
            newSheet.setColumnWidth(i, srcSheet.getColumnWidth(i));
            ++i;
        }
    }

    private static void copyRow(Workbook newWorkbook, Row srcRow, Row newRow, Map<Integer, CellStyle> styleMap) {
        newRow.setHeight(srcRow.getHeight());
        int i = srcRow.getFirstCellNum();
        while (i <= srcRow.getLastCellNum()) {
            Cell srcCell = srcRow.getCell(i);
            Cell newCell = newRow.createCell(i);
            if (srcCell != null) {
                ExcelWorkbookUtils.copyCell(newWorkbook, srcCell, newCell, styleMap);
            }
            ++i;
        }
    }

    private static void copyCell(Workbook newWorkbook, Cell srcCell, Cell newCell, Map<Integer, CellStyle> styleMap) {
        CellStyle newCellStyle = styleMap.get(srcCell.getCellStyle().hashCode());
        if (newCellStyle == null) {
            newCellStyle = newWorkbook.createCellStyle();
            newCellStyle.cloneStyleFrom(srcCell.getCellStyle());
            styleMap.put(srcCell.getCellStyle().hashCode(), newCellStyle);
        }
        newCell.setCellStyle(newCellStyle);
        switch (srcCell.getCellType()) {
            case BOOLEAN: {
                newCell.setCellValue(srcCell.getBooleanCellValue());
                break;
            }
            case ERROR: {
                newCell.setCellErrorValue(srcCell.getErrorCellValue());
                break;
            }
            case FORMULA: {
                newCell.setCellValue(srcCell.getCellFormula());
                break;
            }
            case NUMERIC: {
                newCell.setCellValue(srcCell.getNumericCellValue());
                break;
            }
            case STRING: {
                newCell.setCellValue(srcCell.getStringCellValue());
                break;
            }
        }
    }
}

