/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.function.Supplier;

public class SynchronizedInitializationSupplierUnsynchronizedAccess<T> {
    private volatile T value = null;
    private final VarHandle valueVarHandle;
    private final Supplier<T> initializationAction;
    private final Supplier<T> internalAccessAction;

    public SynchronizedInitializationSupplierUnsynchronizedAccess(Class<T> tClass, Supplier<T> initializationAction) {
        VarHandle varHandle;
        try {
            varHandle = MethodHandles.privateLookupIn(SynchronizedInitializationSupplierUnsynchronizedAccess.class, MethodHandles.lookup()).findVarHandle(SynchronizedInitializationSupplierUnsynchronizedAccess.class, "value", tClass);
        }
        catch (Exception exception) {
            varHandle = null;
        }
        this.valueVarHandle = varHandle;
        this.initializationAction = Objects.requireNonNull(initializationAction);
        this.internalAccessAction = Objects.nonNull(this.valueVarHandle) ? this::accessActionVarHandle : this::applyActionNoVarHandle;
    }

    public T apply() {
        return this.internalAccessAction.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T accessActionVarHandle() {
        if (Objects.nonNull(this.valueVarHandle.get(this)) || Objects.nonNull(this.valueVarHandle.getVolatile(this))) {
            return this.value;
        }
        SynchronizedInitializationSupplierUnsynchronizedAccess synchronizedInitializationSupplierUnsynchronizedAccess = this;
        synchronized (synchronizedInitializationSupplierUnsynchronizedAccess) {
            if (Objects.nonNull(this.valueVarHandle.getVolatile(this))) {
                return this.value;
            }
            this.value = this.initializationAction.get();
        }
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T applyActionNoVarHandle() {
        if (Objects.nonNull(this.value)) {
            return this.value;
        }
        SynchronizedInitializationSupplierUnsynchronizedAccess synchronizedInitializationSupplierUnsynchronizedAccess = this;
        synchronized (synchronizedInitializationSupplierUnsynchronizedAccess) {
            if (Objects.nonNull(this.value)) {
                return this.value;
            }
            this.value = this.initializationAction.get();
        }
        return this.value;
    }
}

