/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class IndentedString {
    private static IndentedString indentedString;
    private static String indentedUnitString;
    private static int initialIndentStringCount;
    private static int indentAmount;
    private final StringBuilder indentBuffer;
    private final List<String> indentStrings = new ArrayList<String>(initialIndentStringCount);
    private final AtomicInteger largestIndent;

    static {
        initialIndentStringCount = 32;
        indentAmount = 3;
        indentedUnitString = "   ";
        indentedString = new IndentedString();
        indentedString.createIndentString(initialIndentStringCount - 1);
    }

    private IndentedString() {
        this.indentStrings.add("");
        this.largestIndent = new AtomicInteger(0);
        int size = indentAmount * (initialIndentStringCount - 1);
        size = size > 1024 ? size : 1024;
        this.indentBuffer = new StringBuilder(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createIndentString(int indent) {
        int n = indent = indent >= 0 ? indent : 0;
        if (indent <= this.largestIndent.get()) {
            return this.indentStrings.get(indent);
        }
        IndentedString indentedString = IndentedString.indentedString;
        synchronized (indentedString) {
            int start = this.largestIndent.get() + 1;
            int end = indent;
            int newIndent = start;
            while (newIndent <= end) {
                this.indentStrings.add(newIndent, this.indentBuffer.append(indentedUnitString).toString());
                ++newIndent;
            }
            this.largestIndent.set(indent);
        }
        return this.indentStrings.get(indent);
    }

    public static String indentString(int indent) {
        return indentedString.createIndentString(indent);
    }

    public static int indentSize() {
        return indentAmount;
    }
}

