/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.osee.framework.jdk.core.util.ParameterArray;
import org.eclipse.osee.framework.jdk.core.util.RankMap;
import org.eclipse.osee.framework.jdk.core.util.RankMapDuplicateEntryException;
import org.eclipse.osee.framework.jdk.core.util.RankMapInsufficientKeysException;
import org.eclipse.osee.framework.jdk.core.util.RankMapNullValueException;
import org.eclipse.osee.framework.jdk.core.util.RankMapTooManyKeysException;

public class AbstractRankMap<V>
implements RankMap<V> {
    private AbstractRankMapEntrySet<V> entrySet;
    private final String identifier;
    private final Predicate<Object>[] keyValidators;
    private final Supplier<Map<Object, Object>> mapSupplier;
    private final Map<Object, Object> primaryMap;
    private final int rank;
    private int size;

    AbstractRankMap(String identifier, int rank, Supplier<Map<Object, Object>> mapSupplier, Predicate<Object>[] keyValidators) {
        if (rank < 1) {
            throw new IllegalArgumentException();
        }
        this.identifier = Objects.nonNull(identifier) ? identifier : new StringBuilder(512).append(this.getClass().getName()).append(":").append(super.hashCode()).toString();
        this.rank = rank;
        this.mapSupplier = Objects.requireNonNull(mapSupplier);
        this.keyValidators = keyValidators;
        this.size = 0;
        this.primaryMap = mapSupplier.get();
        this.entrySet = null;
    }

    private Object getSubMapOrEntry(Object[] keys, int keyCount) {
        int limit = keyCount < keys.length ? keyCount : keys.length;
        Object subMapOrValue = this.primaryMap;
        int i = 0;
        while (i < limit) {
            if (Objects.isNull(subMapOrValue = subMapOrValue.get(keys[i]))) break;
            ++i;
        }
        return subMapOrValue;
    }

    private Object[] getSubMapsOrEntries(Object[] keys, int keyCount) {
        Object[] mapsOrValues = new Object[keyCount + 1];
        int limit = keyCount < keys.length ? keyCount : keys.length;
        Object subMapOrValue = this.primaryMap;
        mapsOrValues[0] = subMapOrValue;
        int k = 0;
        int o = 1;
        while (k < limit) {
            mapsOrValues[o] = subMapOrValue = subMapOrValue.get(keys[k]);
            if (Objects.isNull(subMapOrValue)) break;
            ++k;
            ++o;
        }
        return mapsOrValues;
    }

    @Override
    public Optional<V> associate(V value, Object ... keys) {
        if (Objects.isNull(keys) || keys.length < this.rank) {
            throw new RankMapInsufficientKeysException(this, keys);
        }
        if (keys.length > this.rank) {
            throw new RankMapTooManyKeysException(this, keys);
        }
        if (Objects.isNull(value)) {
            throw new RankMapNullValueException(this, keys);
        }
        assert (Objects.isNull(this.keyValidators) || ParameterArray.validateNonNullSizeAndElements(keys, this.rank, this.rank, this.keyValidators)) : "AbstractRankMap::associate, key set failed validation.";
        Map<Object, Object> subMap = this.primaryMap;
        int i = 0;
        while (i < this.rank - 1) {
            Map<Object, Object> parentMap = subMap;
            Map<Object, Object> nextSubMap = (Map<Object, Object>)subMap.get(keys[i]);
            if (Objects.isNull(nextSubMap)) {
                subMap = this.mapSupplier.get();
                parentMap.put(keys[i], subMap);
            } else {
                subMap = nextSubMap;
            }
            ++i;
        }
        AbstractRankMapEntry priorEntry = (AbstractRankMapEntry)subMap.get(keys[this.rank - 1]);
        if (Objects.nonNull(priorEntry)) {
            Object priorValue = priorEntry.getValue();
            priorEntry.setValue(value);
            return Optional.of(priorValue);
        }
        subMap.put(keys[this.rank - 1], new AbstractRankMapEntry<V>(keys, value, this));
        ++this.size;
        return Optional.empty();
    }

    @Override
    public void associateThrowOnDuplicate(V value, Object ... keys) {
        if (Objects.isNull(keys) || keys.length < this.rank) {
            throw new RankMapInsufficientKeysException(this, keys);
        }
        if (keys.length > this.rank) {
            throw new RankMapTooManyKeysException(this, keys);
        }
        if (Objects.isNull(value)) {
            throw new RankMapNullValueException(this, keys);
        }
        assert (Objects.isNull(this.keyValidators) || ParameterArray.validateNonNullSizeAndElements(keys, this.rank, this.rank, this.keyValidators)) : "AbstractRankMap::associateThrowOnDuplicate, key set failed validation.";
        Map<Object, Object> subMap = this.primaryMap;
        int i = 0;
        while (i < this.rank - 1) {
            Map<Object, Object> parentMap = subMap;
            Map<Object, Object> nextSubMap = (Map<Object, Object>)subMap.get(keys[i]);
            if (Objects.isNull(nextSubMap)) {
                subMap = this.mapSupplier.get();
                parentMap.put(keys[i], subMap);
            } else {
                subMap = nextSubMap;
            }
            ++i;
        }
        if (subMap.containsKey(keys[this.rank - 1])) {
            throw new RankMapDuplicateEntryException(this, value, keys);
        }
        subMap.put(keys[this.rank - 1], new AbstractRankMapEntry<V>(keys, value, this));
        ++this.size;
    }

    @Override
    public boolean containsKeys(Object ... keys) {
        if (Objects.isNull(keys) || keys.length == 0) {
            throw new RankMapInsufficientKeysException(this, keys);
        }
        if (keys.length > this.rank) {
            throw new RankMapTooManyKeysException(this, keys);
        }
        assert (Objects.isNull(this.keyValidators) || ParameterArray.validateNonNullSizeAndElements(keys, 1, this.rank, this.keyValidators)) : "AbstractRankMap::containsKeys, key set failed validation.";
        return Objects.nonNull(this.getSubMapOrEntry(keys, keys.length));
    }

    @Override
    public boolean containsKeysNoExceptions(Object ... keys) {
        assert (Objects.isNull(this.keyValidators) || ParameterArray.validateElements(keys, this.keyValidators)) : "AbstractRankMap::containsKeysNoExceptions, key set failed validation.";
        if (Objects.isNull(keys) || keys.length == 0 || keys.length > this.rank) {
            return false;
        }
        return Objects.nonNull(this.getSubMapOrEntry(keys, keys.length));
    }

    @Override
    public RankMap.EntrySet<V> entrySet() {
        return Objects.nonNull(this.entrySet) ? this.entrySet : (this.entrySet = new AbstractRankMapEntrySet());
    }

    @Override
    public Optional<V> get(Object ... keys) {
        if (Objects.isNull(keys) || keys.length < this.rank) {
            throw new RankMapInsufficientKeysException(this, keys);
        }
        if (keys.length > this.rank) {
            throw new RankMapTooManyKeysException(this, keys);
        }
        assert (Objects.isNull(this.keyValidators) || ParameterArray.validateNonNullSizeAndElements(keys, this.rank, this.rank, this.keyValidators)) : "AbstractRankMap::get, key set failed validation.";
        AbstractRankMapEntry entry = (AbstractRankMapEntry)this.getSubMapOrEntry(keys, keys.length);
        return Objects.nonNull(entry) ? Optional.of(entry.getValue()) : Optional.empty();
    }

    @Override
    public Optional<RankMap.Entry<V>> getEntry(Object ... keys) {
        if (Objects.isNull(keys) || keys.length < this.rank) {
            throw new RankMapInsufficientKeysException(this, keys);
        }
        if (keys.length > this.rank) {
            throw new RankMapTooManyKeysException(this, keys);
        }
        assert (Objects.isNull(this.keyValidators) || ParameterArray.validateNonNullSizeAndElements(keys, this.rank, this.rank, this.keyValidators)) : "AbstractRankMap::getEntry, key set failed validation.";
        AbstractRankMapEntry entry = (AbstractRankMapEntry)this.getSubMapOrEntry(keys, keys.length);
        return Optional.ofNullable(entry);
    }

    @Override
    public Optional<RankMap.Entry<V>> getEntryNoExceptions(Object ... keys) {
        if (Objects.isNull(keys) || keys.length != this.rank) {
            return Optional.empty();
        }
        assert (Objects.isNull(this.keyValidators) || ParameterArray.validateNonNullSizeAndElements(keys, this.rank, this.rank, this.keyValidators)) : "AbstractRankMap::getEntry, key set failed validation.";
        AbstractRankMapEntry entry = (AbstractRankMapEntry)this.getSubMapOrEntry(keys, keys.length);
        return Optional.ofNullable(entry);
    }

    @Override
    public Optional<V> getNoExceptions(Object ... keys) {
        if (Objects.isNull(keys) || keys.length != this.rank) {
            return Optional.empty();
        }
        assert (Objects.isNull(this.keyValidators) || ParameterArray.validateElements(keys, this.keyValidators)) : "AbstractRankMap::getNoExceptions, key set failed validation.";
        AbstractRankMapEntry entry = (AbstractRankMapEntry)this.getSubMapOrEntry(keys, keys.length);
        return Objects.nonNull(entry) ? Optional.of(entry.getValue()) : Optional.empty();
    }

    @Override
    public String identifier() {
        return this.identifier;
    }

    @Override
    public Optional<V> remove(Object ... keys) {
        if (Objects.isNull(keys) || keys.length < this.rank) {
            throw new RankMapInsufficientKeysException(this, keys);
        }
        if (keys.length > this.rank) {
            throw new RankMapTooManyKeysException(this, keys);
        }
        assert (Objects.isNull(this.keyValidators) || ParameterArray.validateNonNullSizeAndElements(keys, this.rank, this.rank, this.keyValidators)) : "AbstractRankMap::remove, key set failed validation.";
        Object[] mapsOrEntries = this.getSubMapsOrEntries(keys, keys.length);
        if (Objects.isNull(mapsOrEntries[this.rank])) {
            return Optional.empty();
        }
        int i = this.rank - 1;
        while (i >= 0) {
            ((Map)mapsOrEntries[i]).remove(keys[i]);
            if (((Map)mapsOrEntries[i]).size() > 0) break;
            --i;
        }
        AbstractRankMapEntry removedEntry = (AbstractRankMapEntry)mapsOrEntries[this.rank];
        Object removedValue = removedEntry.getValue();
        removedEntry.setRemoved();
        --this.size;
        return Optional.of(removedValue);
    }

    @Override
    public Optional<V> removeNoException(Object ... keys) {
        assert (Objects.isNull(this.keyValidators) || ParameterArray.validateElements(keys, this.keyValidators)) : "AbstractRankMap::removeNoExceptions, key set failed validation.";
        if (Objects.isNull(keys) || keys.length != this.rank) {
            return Optional.empty();
        }
        Object[] mapsOrEntries = this.getSubMapsOrEntries(keys, keys.length);
        if (Objects.isNull(mapsOrEntries[this.rank])) {
            return Optional.empty();
        }
        int i = this.rank - 1;
        while (i >= 0) {
            ((Map)mapsOrEntries[i]).remove(keys[i]);
            if (((Map)mapsOrEntries[i]).size() > 0) break;
            --i;
        }
        AbstractRankMapEntry removedEntry = (AbstractRankMapEntry)mapsOrEntries[this.rank];
        Object removedValue = removedEntry.getValue();
        removedEntry.setRemoved();
        --this.size;
        return Optional.ofNullable(removedValue);
    }

    @Override
    public int rank() {
        return this.rank;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int size(Object ... keys) {
        int keyCount;
        int n = keyCount = Objects.nonNull(keys) ? keys.length : 0;
        if (keyCount > this.rank) {
            throw new RankMapTooManyKeysException(this, keys);
        }
        assert (Objects.isNull(this.keyValidators) || ParameterArray.validateElements(keys, this.keyValidators)) : "AbstractRankMap::size, key set failed validation.";
        Object subMapOrEntry = this.getSubMapOrEntry(keys, keyCount);
        if (keyCount == this.rank) {
            return Objects.nonNull(subMapOrEntry) ? 1 : 0;
        }
        if (Objects.isNull(subMapOrEntry)) {
            return 0;
        }
        Map subMap = (Map)subMapOrEntry;
        return subMap.size();
    }

    @Override
    public Stream<V> stream(Object ... keys) {
        return this.streamEntries(keys).map(RankMap.Entry::getValue);
    }

    @Override
    public Stream<RankMap.Entry<V>> streamEntries(Object ... keys) {
        return StreamSupport.stream(new EntrySpliterator(keys), false);
    }

    @Override
    public Stream<Object> streamKeysAtAndBelow(Object ... keys) {
        int keyCount;
        int n = keyCount = Objects.nonNull(keys) ? keys.length : 0;
        if (keyCount > this.rank - 1) {
            throw new RankMapTooManyKeysException(this, keys);
        }
        assert (Objects.isNull(this.keyValidators) || ParameterArray.validateSizeAndElements(keys, 0, this.rank - 1, this.keyValidators)) : "AbstractRankMap::streamKeysAtAndBelow, key set failed validation.";
        List[] levelListArray = new List[this.rank - keyCount];
        int l = 0;
        Map subMap = (Map)this.getSubMapOrEntry(keys, keys.length);
        if (Objects.isNull(subMap)) {
            return Stream.empty();
        }
        ArrayList<Map> subMapList = new ArrayList<Map>();
        subMapList.add(subMap);
        levelListArray[l++] = subMapList;
        int i = keyCount + 1;
        while (i < this.rank) {
            List levelList;
            levelListArray[l] = levelList = levelListArray[l - 1].stream().flatMap(map -> map.values().stream()).collect(Collectors.toList());
            ++i;
            ++l;
        }
        return Arrays.stream(levelListArray).flatMap(Collection::stream).map(Map::keySet).flatMap(Collection::stream);
    }

    @Override
    public Stream<Object> streamKeysAt(Object ... keys) {
        int keyCount;
        int n = keyCount = Objects.nonNull(keys) ? keys.length : 0;
        if (keyCount > this.rank - 1) {
            throw new RankMapTooManyKeysException(this, keys);
        }
        assert (Objects.isNull(this.keyValidators) || ParameterArray.validateSizeAndElements(keys, 0, this.rank - 1, this.keyValidators)) : "AbstractRankMap::remove, key set failed validation.";
        Map subMap = (Map)this.getSubMapOrEntry(keys, keys.length);
        return Objects.nonNull(subMap) ? subMap.keySet().stream() : Stream.empty();
    }

    @Override
    public Stream<Object[]> streamKeySets(Object ... keys) {
        return this.streamEntries(keys).map(RankMap.Entry::getKeyArray);
    }

    static class AbstractRankMapEntry<V>
    implements RankMap.Entry<V> {
        private final AbstractRankMap<V> abstractRankMap;
        private int hashCode;
        private final Object[] keys;
        private boolean removed;
        private V value;

        AbstractRankMapEntry(Object[] keys, V value, AbstractRankMap<V> abstractRankMap) {
            assert (Objects.nonNull(keys) && Objects.nonNull(abstractRankMap) && Objects.nonNull(value) && keys.length == abstractRankMap.rank()) : "AbstractRankMapEntry::new, invalid parameters.";
            this.keys = (Object[])keys.clone();
            this.value = value;
            this.removed = false;
            this.abstractRankMap = abstractRankMap;
            this.calculateHashCode();
        }

        boolean belongsTo(AbstractRankMap<V> abstractRankMap) {
            return !this.removed && this.abstractRankMap == abstractRankMap;
        }

        private void calculateHashCode() {
            int hashCode = this.value.hashCode();
            int i = 0;
            while (i < this.keys.length) {
                int memberHash = this.keys[i].hashCode() * 31;
                memberHash = memberHash << i | memberHash >> 32 - i;
                hashCode ^= memberHash;
                ++i;
            }
            this.hashCode = hashCode;
        }

        @Override
        public boolean equals(Object other) {
            if (!(other instanceof AbstractRankMapEntry)) {
                return false;
            }
            AbstractRankMapEntry otherEntry = (AbstractRankMapEntry)other;
            return this.abstractRankMap == otherEntry.abstractRankMap && this.hashCode == otherEntry.hashCode && !this.removed && !otherEntry.removed && this.value.equals(otherEntry.value) && Arrays.equals(this.keys, otherEntry.keys);
        }

        @Override
        public Object getKey(int index) {
            if (this.removed) {
                throw new IllegalStateException();
            }
            return this.keys[index];
        }

        @Override
        public Object[] getKeyArray() {
            if (this.removed) {
                throw new IllegalStateException();
            }
            return (Object[])this.keys.clone();
        }

        @Override
        public V getValue() {
            if (this.removed) {
                throw new IllegalStateException();
            }
            return this.value;
        }

        @Override
        public int hashCode() {
            return this.hashCode;
        }

        @Override
        public int rank() {
            if (this.removed) {
                throw new IllegalStateException();
            }
            return this.keys.length;
        }

        void setRemoved() {
            this.removed = true;
        }

        void setValue(V value) {
            this.value = value;
            this.calculateHashCode();
        }

        @Override
        public Stream<Object> streamKeys() {
            if (this.removed) {
                throw new IllegalStateException();
            }
            return Arrays.stream(this.keys);
        }
    }

    class AbstractRankMapEntrySet<W extends V>
    extends AbstractSet<RankMap.Entry<V>>
    implements RankMap.EntrySet<V> {
        AbstractRankMapEntrySet() {
        }

        @Override
        public boolean contains(Object object) {
            if (!(object instanceof AbstractRankMapEntry)) {
                return false;
            }
            AbstractRankMapEntry entry = (AbstractRankMapEntry)object;
            if (!entry.belongsTo(AbstractRankMap.this)) {
                return false;
            }
            return entry == AbstractRankMap.this.getEntry(entry.getKeyArray()).orElse(null);
        }

        @Override
        public boolean containsKeys(Object ... keys) {
            return AbstractRankMap.this.containsKeys(keys);
        }

        @Override
        public Iterator<RankMap.Entry<V>> iterator() {
            return new EntryIterator(new Object[0]);
        }

        @Override
        public int size() {
            return AbstractRankMap.this.size();
        }
    }

    class EntryIterator
    implements Iterator<RankMap.Entry<V>> {
        int atRankIndex;
        int entryIteratorRank;
        Iterator<Object>[] iterators;

        EntryIterator(Object ... keys) {
            int keyCount;
            int n = keyCount = Objects.nonNull(keys) ? keys.length : 0;
            if (keyCount > AbstractRankMap.this.rank) {
                throw new RankMapTooManyKeysException(AbstractRankMap.this, keys);
            }
            assert (Objects.isNull(AbstractRankMap.this.keyValidators) || ParameterArray.validateSizeAndElements(keys, 0, AbstractRankMap.this.rank, AbstractRankMap.this.keyValidators)) : "AbstractRankMap::EntryIterator, key set failed validation.";
            this.entryIteratorRank = AbstractRankMap.this.rank - keyCount;
            if (this.entryIteratorRank == 0) {
                Iterator baseIterator;
                Iterator[] iteratorArray = new Iterator[1];
                this.iterators = iteratorArray;
                this.iterators[0] = baseIterator = (Iterator)new SingleEntryIterator((RankMap.Entry)AbstractRankMap.this.getSubMapOrEntry(keys, keys.length));
                this.entryIteratorRank = 1;
                return;
            }
            this.atRankIndex = this.entryIteratorRank - 1;
            Iterator[] iteratorArray = new Iterator[this.entryIteratorRank];
            this.iterators = iteratorArray;
            Iterator baseIterator = ((Map)AbstractRankMap.this.getSubMapOrEntry(keys, keys.length)).values().iterator();
            this.iterators[0] = baseIterator;
            int r = 1;
            while (r < this.entryIteratorRank) {
                if (Objects.nonNull(this.iterators[r - 1]) && this.iterators[r - 1].hasNext()) {
                    Iterator nextIterator = ((Map)this.iterators[r - 1].next()).values().iterator();
                    this.iterators[r] = nextIterator;
                } else {
                    this.iterators[r] = null;
                }
                ++r;
            }
        }

        @Override
        public boolean hasNext() {
            if (Objects.isNull(this.iterators[this.entryIteratorRank - 1])) {
                return false;
            }
            if (this.iterators[this.entryIteratorRank - 1].hasNext()) {
                return true;
            }
            int i = this.entryIteratorRank - 2;
            while (i >= 0) {
                if (this.iterators[i].hasNext()) break;
                --i;
            }
            if (i < 0) {
                return false;
            }
            ++i;
            while (i < this.entryIteratorRank) {
                if (Objects.nonNull(this.iterators[i - 1]) && this.iterators[i - 1].hasNext()) {
                    Iterator nextIterator = ((Map)this.iterators[i - 1].next()).values().iterator();
                    this.iterators[i] = nextIterator;
                } else {
                    this.iterators[i] = null;
                }
                ++i;
            }
            if (Objects.isNull(this.iterators[this.entryIteratorRank - 1])) {
                return false;
            }
            return this.iterators[this.entryIteratorRank - 1].hasNext();
        }

        @Override
        public RankMap.Entry<V> next() {
            if (Objects.isNull(this.iterators[this.entryIteratorRank - 1])) {
                throw new NoSuchElementException();
            }
            RankMap.Entry entry = (RankMap.Entry)this.iterators[this.entryIteratorRank - 1].next();
            return entry;
        }
    }

    class EntrySpliterator
    implements Spliterator<RankMap.Entry<V>> {
        int index = 0;
        EntryIterator entryIterator;

        EntrySpliterator(Object ... keys) {
            this.entryIterator = new EntryIterator(keys);
        }

        @Override
        public boolean tryAdvance(Consumer<? super RankMap.Entry<V>> action) {
            if (this.entryIterator.hasNext()) {
                action.accept((RankMap.Entry)this.entryIterator.next());
                return true;
            }
            return false;
        }

        @Override
        public Spliterator<RankMap.Entry<V>> trySplit() {
            return null;
        }

        @Override
        public long estimateSize() {
            return AbstractRankMap.this.size - this.index;
        }

        @Override
        public int characteristics() {
            return 256;
        }
    }

    class SingleEntryIterator
    implements Iterator<RankMap.Entry<V>> {
        RankMap.Entry<V> entry;

        SingleEntryIterator(RankMap.Entry<V> entry) {
            this.entry = entry;
        }

        @Override
        public boolean hasNext() {
            return Objects.nonNull(this.entry);
        }

        @Override
        public RankMap.Entry<V> next() {
            if (Objects.isNull(this.entry)) {
                throw new NoSuchElementException();
            }
            RankMap.Entry rv = this.entry;
            this.entry = null;
            return rv;
        }
    }
}

