/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collection;
import java.util.List;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class AHTML {
    private static final String HTTP_CHARSET_ENCODING = "<meta http-equiv=\"Content-Type\" content=\"text/html;charset=utf-8\">";
    private static final String begin = "<table ";
    public static final String LABEL_FONT = "<font color=\"black\" face=\"Arial\" size=\"-1\">";

    public static String getHyperlink(String url, String name) {
        return String.format("<a href=\"%s\">%s</a>", url, name);
    }

    public static String getHyperlinkNewTab(String url, String name) {
        return String.format("<a href=\"%s\" target=_blank>%s</a>", url, name);
    }

    public static String textToHtml(String text) {
        if (text == null) {
            return "";
        }
        text = text.replaceAll("&", "&amp;");
        text = text.replaceAll(">", "&gt;");
        text = text.replaceAll("<", "&lt;");
        text = text.replaceAll("\"", "&quot;");
        text = text.replaceAll("\\n", "<br/>");
        text = text.replaceAll("\t", "&nbsp;&nbsp;&nbsp;&nbsp;");
        text = text.replaceAll("[\\x0B\\f\\r]+", "");
        return text;
    }

    public static String htmlToText(String html) {
        if (html == null) {
            return "";
        }
        html = html.replaceAll("&amp;", "&");
        html = html.replaceAll("&gt;", ">");
        html = html.replaceAll("&lt;", "<");
        html = html.replaceAll("&quot;", "\"");
        html = html.replaceAll("&nbsp;", " ");
        return html;
    }

    public static String removeComments(String value) {
        return Strings.isValid(value) ? value.replaceAll("<!--\\s*.*\\s*-->", "") : value;
    }

    public static Exception isUrlValid(String urlStr, InetSocketAddress addr) {
        try {
            URL url = new URL(urlStr);
            URLConnection connection = url.openConnection(new Proxy(Proxy.Type.HTTP, addr));
            connection.setReadTimeout(5000);
            connection.connect();
        }
        catch (Exception ex) {
            return ex;
        }
        return null;
    }

    /*
     * Loose catch block
     */
    public static String getUrlPageHtml(String urlStr) {
        String string;
        BufferedReader rd;
        block12: {
            StringBuffer buffer = new StringBuffer();
            rd = null;
            URL url = new URL(urlStr);
            URLConnection connection = url.openConnection();
            rd = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            String line = null;
            while ((line = rd.readLine()) != null) {
                buffer.append(line);
            }
            rd.close();
            string = buffer.toString();
            if (rd == null) break block12;
            try {
                rd.close();
            }
            catch (IOException iOException) {}
        }
        return string;
        catch (Exception ex) {
            String string2;
            block13: {
                try {
                    ex.printStackTrace();
                    string2 = AHTML.simplePage("Exception opening url " + ex.getLocalizedMessage());
                    if (rd == null) break block13;
                }
                catch (Throwable throwable) {
                    if (rd != null) {
                        try {
                            rd.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                try {
                    rd.close();
                }
                catch (IOException iOException) {}
            }
            return string2;
        }
    }

    /*
     * Loose catch block
     */
    public static String getUrlPageHtml(String urlStr, InetSocketAddress addr) {
        String string;
        BufferedReader rd;
        block12: {
            StringBuffer buffer = new StringBuffer();
            rd = null;
            URL url = new URL(urlStr);
            URLConnection connection = url.openConnection(new Proxy(Proxy.Type.HTTP, addr));
            rd = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            String line = null;
            while ((line = rd.readLine()) != null) {
                buffer.append(line);
            }
            rd.close();
            string = buffer.toString();
            if (rd == null) break block12;
            try {
                rd.close();
            }
            catch (IOException iOException) {}
        }
        return string;
        catch (Exception ex) {
            String string2;
            block13: {
                try {
                    ex.printStackTrace();
                    string2 = AHTML.simplePage("Exception opening url " + ex.getLocalizedMessage());
                    if (rd == null) break block13;
                }
                catch (Throwable throwable) {
                    if (rd != null) {
                        try {
                            rd.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                try {
                    rd.close();
                }
                catch (IOException iOException) {}
            }
            return string2;
        }
    }

    public static String titledPage(String title, String text) {
        return AHTML.simplePage("<head><title>" + title + "</title></head>" + text);
    }

    public static String pageEncoding(String html) {
        return HTTP_CHARSET_ENCODING + html;
    }

    public static String simplePage(String text) {
        return AHTML.pageEncoding("<html>" + text + "</html>");
    }

    public static String simplePage(String title, String body) {
        return AHTML.pageEncoding("<html><h3>" + title + "</h3>" + body + "</html>");
    }

    public static String simplePageNoPageEncoding(String text) {
        return "<html>" + text + "</html>";
    }

    public static String getLabelStr(String labelFont, String str) {
        return String.valueOf(labelFont) + "<b>" + AHTML.textToHtml(str) + "</b></font>";
    }

    public static String getLabelValueStr(String labelFont, String label, String value) {
        return String.valueOf(AHTML.getLabelStr(labelFont, label)) + value;
    }

    public static String getLabelValueStr(String label, String value) {
        return String.valueOf(AHTML.getLabelStr(LABEL_FONT, String.valueOf(label) + ":")) + "&nbsp;&nbsp;" + value;
    }

    public static String color(String color, String str) {
        if (color == null) {
            return str;
        }
        return "<font color=\"" + color + "\">" + str + "</font>";
    }

    public static String boldColor(String color, String str) {
        return "<font color=\"" + color + "\"><b>" + AHTML.textToHtml(str) + "</b></font>";
    }

    public static String bold(String str) {
        return "<b>" + AHTML.textToHtml(str) + "</b>";
    }

    public static String boldColorTags(String color, String str) {
        return "<font color=\"" + color + "\"><b>" + str + "</b></font>";
    }

    public static String imageBlock(String description, String filename) {
        String[] filenames = new String[]{filename};
        return AHTML.imageBlock(description, filenames);
    }

    public static String imageBlock(String description, String[] filenames) {
        StringBuilder str = new StringBuilder();
        str.append("<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr><td>");
        if (!description.equals("")) {
            str.append(description);
            str.append(AHTML.newline());
        }
        int i = 0;
        while (i < filenames.length) {
            str.append("<IMG SRC=\"" + filenames[i] + "\"><br>");
            ++i;
        }
        str.append("</td></tr></table>");
        return str.toString();
    }

    public static String urlBlock(String description, String[] urls) {
        StringBuilder str = new StringBuilder();
        str.append("<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">");
        if (!description.equals("")) {
            str.append(description);
            str.append(AHTML.newline());
        }
        int i = 0;
        while (i < urls.length) {
            str.append("<A HREF=\"" + urls[i] + "\">" + urls[i] + "</A><br>");
            ++i;
        }
        str.append("</td></tr></table>");
        return str.toString();
    }

    public static String heading(int heading, String str, String id) {
        return "<h" + heading + (Strings.isValid(id) ? " id=\"" + id + "\"" : "") + ">" + AHTML.textToHtml(str) + "</h" + heading + ">";
    }

    public static String heading(int heading, String str) {
        return AHTML.heading(heading, str, null);
    }

    public static String padSpace(int num, String str) {
        StringBuilder out = new StringBuilder();
        int i = 0;
        while (i < num) {
            out.append("&nbsp;");
            ++i;
        }
        out.append(str);
        return out.toString();
    }

    public static String addSpace(int num) {
        StringBuilder out = new StringBuilder();
        int i = 0;
        while (i < num) {
            out.append("&nbsp;");
            ++i;
        }
        return out.toString();
    }

    public static String para(String str) {
        return "<p>" + AHTML.textToHtml(str) + "</p>";
    }

    public static String italics(String str) {
        return "<i>" + AHTML.textToHtml(str) + "</i>";
    }

    public static String pre(String str) {
        return "<pre>" + str + "</pre>";
    }

    public static String blockQuote(String str) {
        return "<blockquote>" + str + "</blockquote>";
    }

    public static String newline() {
        return AHTML.newline(1);
    }

    public static String newline(int num) {
        StringBuilder str = new StringBuilder();
        int i = 0;
        while (i < num) {
            str.append("<br />");
            ++i;
        }
        return "" + str;
    }

    public static String name(int num) {
        return AHTML.nameTarget("" + num);
    }

    public static String nameTarget(String str) {
        if (str == null) {
            return "";
        }
        return "<A NAME=\"" + str + "\">";
    }

    public static String nameLink(int num, String text) {
        return AHTML.nameLink("" + num, text);
    }

    public static String nameLink(String name, String text) {
        return "<A HREF=\"#" + name + "\">" + text + "</A>";
    }

    public static String nameLink(String name) {
        return "<A HREF=\"#" + name + "\">" + name + "</A>";
    }

    public static String simpleTable(String str) {
        return AHTML.simpleTable(str, 100);
    }

    public static String simpleTable(String str, int width) {
        return "<table border=\"0\" cellpadding=\"3\" cellspacing=\"0\" width=\"" + width + "%\">" + "<tr><td>" + str + "</td></tr>" + "</table>";
    }

    public static String borderTable(String str, int width, String bgcolor, String caption) {
        return String.valueOf(AHTML.startBorderTable(width, bgcolor, caption)) + str + AHTML.endBorderTable();
    }

    public static String startBorderTable(int width, String bgcolor, String caption) {
        String capStr = "";
        if (!caption.equals("")) {
            capStr = "<caption ALIGN=top>" + caption + "</caption>";
        }
        return "<table border=\"1\" align=\"center\" bgcolor=\"" + bgcolor + "\" cellpadding=\"3\" cellspacing=\"0\" width=\"" + width + "%\">" + capStr + "<tr><td>";
    }

    public static String endBorderTable() {
        return "</td></tr></table>";
    }

    public static String multiColumnTable(String ... str) {
        return AHTML.multiColumnTable(85, str);
    }

    public static String multiColumnTable(int width, String ... str) {
        StringBuilder s = new StringBuilder();
        s.append("<table border=\"0\" cellpadding=\"3\" cellspacing=\"0\" width=\"" + width + "%\"><tr>");
        int i = 0;
        while (i < str.length) {
            s.append("<td>");
            s.append(str[i]);
            s.append("</td>");
            ++i;
        }
        s.append("</tr></table>");
        return s.toString();
    }

    public static String beginMultiColumnTable(int width) {
        return AHTML.beginMultiColumnTable(width, 0);
    }

    public static String beginMultiColumnTable(int width, int border) {
        return AHTML.beginMultiColumnTable(width, border, null);
    }

    public static String beginMultiColumnTable(int width, int border, Integer color) {
        return "<table border=\"" + border + "\" " + (color != null ? "color=\"" + color + "\"" : "") + "cellpadding=\"3\" cellspacing=\"0\" width=\"" + width + "%\">";
    }

    public static String endMultiColumnTable() {
        return "</table>";
    }

    public static String addRowMultiColumnTableWithBg(String backgroundColor, String ... str) {
        return AHTML.addRowMultiColumnTable(str, null, backgroundColor);
    }

    public static String addRowMultiColumnTable(String ... str) {
        return AHTML.addRowMultiColumnTable(str, null, null);
    }

    public static String addRowMultiColumnTable(String[] str, String[] colOptions) {
        return AHTML.addRowMultiColumnTable(str, colOptions, null);
    }

    public static String addRowMultiColumnTableCollection(Collection<String> str) {
        return AHTML.addRowMultiColumnTable(str.toArray(new String[str.size()]), null, null);
    }

    public static String addRowMultiColumnTable(String[] str, String[] colOptions, String backgroundColor) {
        StringBuilder s = new StringBuilder();
        if (backgroundColor != null) {
            s.append("<tr bgcolor=\"" + backgroundColor + "\">");
        } else {
            s.append("<tr>");
        }
        String show = "";
        int i = 0;
        while (i < str.length) {
            show = str[i];
            if (!Strings.isValid(show)) {
                show = AHTML.addSpace(1);
            }
            String colOptionStr = "";
            if (colOptions != null) {
                colOptionStr = colOptions[i];
            }
            s.append("<td" + (Strings.isValid(colOptionStr) ? colOptionStr : "") + ">" + show + "</td>");
            ++i;
        }
        s.append("</tr>");
        return s.toString();
    }

    public static String addRowSpanMultiColumnTable(String str, int span) {
        return "<tr><td colspan=" + span + ">" + str + "</td></tr>";
    }

    public static String addRowMultiColumnTable(Collection<CellItem> items) {
        StringBuilder s = new StringBuilder("<tr>");
        for (CellItem item : items) {
            if (!Strings.isValid(item.text)) {
                item.text = ".";
            }
            if (item.bgColor != null) {
                s.append("<td bgcolor=\"" + item.bgColor + "\">");
            } else {
                s.append("<td>");
            }
            s.append(AHTML.color(item.fgColor, item.text));
            s.append("</td>");
        }
        s.append("</tr>");
        return s.toString();
    }

    public static String addHeaderRowMultiColumnTable(List<String> strs) {
        return AHTML.addHeaderRowMultiColumnTable(strs.toArray(new String[strs.size()]));
    }

    public static String addHeaderRowMultiColumnTable(String[] str) {
        return AHTML.addHeaderRowMultiColumnTable(str, null);
    }

    public static String addHeaderRowMultiColumnTable(String[] str, Integer[] width) {
        StringBuilder s = new StringBuilder("<thead><tr>");
        String widthStr = "";
        int i = 0;
        while (i < str.length) {
            if (width != null) {
                widthStr = " width =\"" + width[i] + "\"";
            }
            s.append("<th");
            s.append(widthStr);
            s.append(">");
            s.append(str[i]);
            s.append("</th>");
            ++i;
        }
        s.append("</tr></thead>");
        return s.toString();
    }

    public static void addSimpleTableRow(Appendable appendable, String contents) throws IOException {
        appendable.append("<tr><td>");
        appendable.append(contents);
        appendable.append("</td></tr>");
    }

    public static void addSimpleHeaderRow(Appendable appendable, String contents) throws IOException {
        appendable.append("<tr><th>");
        appendable.append(contents);
        appendable.append("</th></tr>");
    }

    public static void beginSimpleTable(Appendable appendable) throws IOException {
        AHTML.beginSimpleTable(appendable, 1, 100);
    }

    public static void beginSimpleTable(Appendable appendable, int border, int width) throws IOException {
        appendable.append("<table border=\"");
        appendable.append(String.valueOf(border));
        appendable.append("\" cellpadding=\"0\" cellspacing=\"0\" width=\"");
        appendable.append(String.valueOf(width));
        appendable.append("%\">");
    }

    public static void endSimpleTable(Appendable appendable) throws IOException {
        appendable.append("</table>");
    }

    public static String createTable(List<String> datas, String[] headers, int numColumns, int cellPadding, int border) {
        StringBuilder table = new StringBuilder(begin);
        if (datas == null) {
            throw new IllegalArgumentException("The data can not be null");
        }
        if (datas.size() % numColumns != 0) {
            throw new IllegalArgumentException("The table could not be created becuase the data does not match the column size");
        }
        if (border > 0) {
            table.append("border=\"" + border + "\"");
        }
        if (cellPadding > 0) {
            table.append("cellpadding=\"" + cellPadding + "\"");
        }
        table.append(">");
        if (headers != null && headers.length == numColumns) {
            table.append("<tr>");
            String[] stringArray = headers;
            int n = headers.length;
            int n2 = 0;
            while (n2 < n) {
                String header = stringArray[n2];
                table.append("<th>" + header + "</th>");
                ++n2;
            }
            table.append("</tr>");
        }
        int colIndex = 0;
        for (String data : datas) {
            if (colIndex == 0) {
                table.append("<tr>");
            }
            table.append("<td>" + data + "</td>");
            if (++colIndex != numColumns) continue;
            table.append("</tr>");
            colIndex = 0;
        }
        return table.toString();
    }

    public static String simplePageWithImageUrl(String title, String imageUrl, String text) {
        return "<html><h3>" + title + "</h3><body>" + imageUrl + AHTML.textToHtml(text) + "</html>";
    }

    public static String simpleJsonPage(String json) {
        return AHTML.pre(json);
    }

    public static String simplePageWithTableSortFilter(String title, String html) {
        return AHTML.pageEncoding("<html lang=\"en\">" + AHTML.getTableSortFilterHeader() + "<body><h3>" + title + "</h3>" + html + "</body></html>");
    }

    public static String getTableSortFilterHeader() {
        StringBuilder sb = new StringBuilder();
        sb.append("<head>");
        sb.append("    <meta charset=\"UTF-8\">");
        sb.append("    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">");
        sb.append("    <!-- Include DataTables CSS -->");
        sb.append("    <link rel=\"stylesheet\" type=\"text/css\" href=\"https://cdn.datatables.net/1.11.5/css/jquery.dataTables.css\">");
        sb.append("    <!-- Include jQuery -->");
        sb.append("    <script type=\"text/javascript\" charset=\"utf8\" src=\"https://code.jquery.com/jquery-3.5.1.js\"></script>");
        sb.append("    <!-- Include DataTables JS -->");
        sb.append("    <script type=\"text/javascript\" charset=\"utf8\" src=\"https://cdn.datatables.net/1.11.5/js/jquery.dataTables.js\"></script>");
        sb.append("    <script> $(document).ready(function() { $('#sorttable').DataTable({paging: false}); }); </script>");
        sb.append("</head>");
        return sb.toString();
    }

    public static Object beginMultiColumnTableWithTableSortFilter(int width, int border, String color) {
        return "<table id=\"sorttable\" class=\"display\" border=\"" + border + "\" " + (color != null ? "color=\"" + color + "\"" : "") + "cellpadding=\"3\" cellspacing=\"0\" width=\"" + width + "%\">";
    }

    public static class CellItem {
        String text;
        private final String fgColor;
        private final String bgColor;

        public CellItem(String text) {
            this(text, null, null);
        }

        public CellItem(String text, String fgColor, String bgColor) {
            this.text = text;
            this.fgColor = fgColor;
            this.bgColor = bgColor;
        }
    }
}

