/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.type;

import java.io.Serializable;
import java.util.Objects;
import java.util.function.Consumer;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.osee.framework.jdk.core.util.Conditions;

public class Pair<F, S>
implements Serializable {
    private static @NonNull Pair<?, ?> EMPTY = Pair.createNullableImmutable(null, null);
    private static final long serialVersionUID = 1764353834209869140L;
    protected @Nullable F first;
    protected @Nullable S second;

    public static <F, S> @NonNull Pair<F, S> createNonNull(@NonNull F first, @NonNull S second) {
        return new Pair<F, S>(Objects.requireNonNull(first), Objects.requireNonNull(second));
    }

    public static <F, S> @NonNull Pair<F, S> createNonNullImmutable(@NonNull F first, @NonNull S second) {
        return Pair.createNullableImmutable(Objects.requireNonNull(first), Objects.requireNonNull(second));
    }

    public static <F, S> @NonNull Pair<F, S> createNullable(@Nullable F first, @Nullable S second) {
        return new Pair<F, S>(first, second);
    }

    public static <F, S> @NonNull Pair<F, S> createNullableImmutable(@Nullable F first, @Nullable S second) {
        return new Pair<F, S>((Object)first, (Object)second){
            private static final long serialVersionUID = 1764353834209869140L;

            @Override
            public Pair<F, S> set(F first, S second) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void setFirst(F first) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void setSecond(S second) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <F, S> @NonNull Pair<F, S> empty() {
        return EMPTY;
    }

    public Pair() {
        this.first = null;
        this.second = null;
    }

    public Pair(@Nullable F first, @Nullable S second) {
        this.first = first;
        this.second = second;
    }

    public boolean equals(Object obj) {
        boolean firstEqual;
        if (!(obj instanceof Pair)) {
            return false;
        }
        Pair other = (Pair)obj;
        if (this.first != null) {
            firstEqual = this.first.equals(other.first);
        } else {
            boolean bl = firstEqual = other.first == null;
        }
        if (!firstEqual) {
            return false;
        }
        boolean secondEqual = this.second != null ? this.second.equals(other.second) : other.second == null;
        return secondEqual;
    }

    public @Nullable F getFirst() {
        return this.first;
    }

    public @NonNull F getFirstNonNull() {
        return Conditions.requireNonNull(this.first);
    }

    public @Nullable F getFirstIfPresentOthers(@Nullable Consumer<@NonNull S> secondAction) {
        Conditions.acceptWhenNonNull(this.second, secondAction);
        return this.first;
    }

    public @NonNull F getFirstNonNullIfPresentOthers(@Nullable Consumer<@NonNull S> secondAction) {
        Conditions.acceptWhenNonNull(this.second, secondAction);
        return Conditions.requireNonNull(this.first);
    }

    public @Nullable S getSecond() {
        return this.second;
    }

    public @NonNull S getSecondNonNull() {
        return Conditions.requireNonNull(this.second);
    }

    public int hashCode() {
        return Objects.hash(this.first, this.second);
    }

    public void ifPresent(@Nullable Consumer<@NonNull F> firstAction, @Nullable Consumer<@NonNull S> secondAction) {
        Conditions.acceptWhenNonNull(this.first, firstAction);
        Conditions.acceptWhenNonNull(this.second, secondAction);
    }

    public @NonNull Pair<F, S> set(@Nullable F first, @Nullable S second) {
        this.first = first;
        this.second = second;
        return this;
    }

    public void setFirst(@Nullable F first) {
        this.first = first;
    }

    public void setSecond(@Nullable S second) {
        this.second = second;
    }

    public @NonNull String toString() {
        String firstAsString = String.valueOf(this.first);
        String secondAsString = String.valueOf(this.second);
        String result = String.format("[%s, %s]", firstAsString, secondAsString);
        return Conditions.requireNonNull(result);
    }

    public boolean typesKo(@NonNull Class<?> firstClass, @NonNull Class<?> secondClass) {
        return !this.typesOk(firstClass, secondClass);
    }

    public boolean typesOk(@NonNull Class<?> firstClass, @NonNull Class<?> secondClass) {
        Class classOfFirst = Conditions.applyWhenNonNull(this.first, f -> f.getClass());
        Class classOfSecond = Conditions.applyWhenNonNull(this.second, s -> s.getClass());
        return !(classOfFirst != null && !firstClass.isAssignableFrom(classOfFirst) || classOfSecond != null && !secondClass.isAssignableFrom(classOfSecond));
    }
}

