/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.authentication.ldap;

import org.eclipse.osee.framework.jdk.core.util.Strings;

public enum LdapSearchScope {
    OBJECT_SCOPE(0),
    ONE_LEVEL_SCOPE(1),
    SUBTREE_SCOPE(2);

    private int searchDepth;

    private LdapSearchScope(int searchDepth) {
        this.searchDepth = searchDepth;
    }

    public int asSearchDepth() {
        return this.searchDepth;
    }

    public static LdapSearchScope parse(String value) {
        LdapSearchScope toReturn = SUBTREE_SCOPE;
        if (Strings.isValid((String)value)) {
            String toFind = value.toUpperCase().trim();
            LdapSearchScope[] ldapSearchScopeArray = LdapSearchScope.values();
            int n = ldapSearchScopeArray.length;
            int n2 = 0;
            while (n2 < n) {
                LdapSearchScope type = ldapSearchScopeArray[n2];
                if (type.name().equals(toFind)) {
                    toReturn = type;
                    break;
                }
                ++n2;
            }
        }
        return toReturn;
    }
}

