/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.authentication.ldap;

import org.eclipse.osee.authentication.ldap.LdapAuthenticationType;
import org.eclipse.osee.authentication.ldap.LdapCredentialsSource;
import org.eclipse.osee.authentication.ldap.LdapReferralHandlingType;
import org.eclipse.osee.authentication.ldap.LdapSearchScope;

public final class LdapConstants {
    public static final String NAMESPACE = "ldap";
    public static final LdapCredentialsSource DEFAULT_LDAP_CREDENTIALS_SOURCE = LdapCredentialsSource.SYSTEM_CREDENTIALS;
    public static final LdapAuthenticationType DEFAULT_AUTHENTICATION_TYPE = LdapAuthenticationType.SIMPLE;
    public static final LdapReferralHandlingType DEFAULT_LDAP_REFERRAL_HANDLING = LdapReferralHandlingType.IGNORE;
    public static final long DEFAULT_LDAP_READ_TIMEOUT_IN_MILLIS = -1L;
    public static final boolean DEFAULT_SSL_CERTIFICATE_VERIFICATION = true;
    public static final boolean DEFAULT_USERNAME_TO_LOWERCASE = false;
    public static final String DEFAULT_USERNAME = null;
    public static final String DEFAULT_PASSWORD = null;
    public static final String PATTERN_DEFAULT = null;
    public static final LdapSearchScope DEFAULT_SEARCH_SCOPE = LdapSearchScope.SUBTREE_SCOPE;
    public static final String DEFAULT_GROUP_NAMESPACE = "ldap";
    public static final String LDAP_SERVER_ADDRESS = LdapConstants.qualify("server.address");
    public static final String LDAP_CREDENTIALS_SOURCE = LdapConstants.qualify("credential.source");
    public static final String LDAP_USER_NAME = LdapConstants.qualify("username");
    public static final String LDAP_PASSWORD = LdapConstants.qualify("password");
    public static final String LDAP_AUTHENTICATION_TYPE = LdapConstants.qualify("authentication.type");
    public static final String LDAP_SSL_VERIFY = LdapConstants.qualify("ssl.verify.enabled");
    public static final String LDAP_REFERRAL_HANDLING = LdapConstants.qualify("referral.handling");
    public static final String LDAP_READ_TIMEOUT = LdapConstants.qualify("read.timeout");
    public static final String LDAP_USERNAME_TO_LOWERCASE = LdapConstants.qualify("username.to.lowercase.enabled");
    public static final String USERNAME_VARIABLE_NAME = LdapConstants.qualify("account.username.bind.variable");
    public static final String ACCOUNT_BASE = LdapConstants.qualify("account.search.base");
    public static final String ACCOUNT_DISPLAY_NAME = LdapConstants.qualify("account.display.name");
    public static final String ACCOUNT_EMAIL_ADDRESS = LdapConstants.qualify("account.email.address");
    public static final String ACCOUNT_PATTERN = LdapConstants.qualify("account.search.pattern");
    public static final String ACCOUNT_SCOPE = LdapConstants.qualify("account.search.scope");
    public static final String ACCOUNT_USERNAME_PATTERN = LdapConstants.qualify("account.username.pattern");
    public static final String GROUP_BASE = LdapConstants.qualify("group.search.base");
    public static final String GROUP_PATTERN = LdapConstants.qualify("group.search.pattern");
    public static final String GROUP_SCOPE = LdapConstants.qualify("group.search.scope");
    public static final String GROUP_NAME_PATTERN = LdapConstants.qualify("group.name.pattern");
    public static final String GROUP_BY_GROUP_MEMBER_PATTERN = LdapConstants.qualify("group.by.group.member.search.pattern");
    public static final String GROUP_MEMBER_OF = LdapConstants.qualify("group.member.of.groups");
    public static final String GROUP_NAMESPACE = LdapConstants.qualify("group.namespace");

    private LdapConstants() {
    }

    private static String qualify(String value) {
        return String.format("%s.%s", "ldap", value);
    }
}

