/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.authentication.ldap;

import java.util.Map;
import org.eclipse.osee.authentication.ldap.LdapAuthenticationType;
import org.eclipse.osee.authentication.ldap.LdapConfiguration;
import org.eclipse.osee.authentication.ldap.LdapConstants;
import org.eclipse.osee.authentication.ldap.LdapCredentialsSource;
import org.eclipse.osee.authentication.ldap.LdapReferralHandlingType;
import org.eclipse.osee.authentication.ldap.LdapSearchScope;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class LdapConfigurationBuilder {
    private final LdapConfigurationImpl config = new LdapConfigurationImpl();

    private LdapConfigurationBuilder() {
    }

    public static LdapConfigurationBuilder newBuilder() {
        return new LdapConfigurationBuilder();
    }

    public LdapConfigurationBuilder properties(Map<String, Object> props) {
        this.config.loadProperties(props);
        return this;
    }

    public LdapConfiguration build() {
        return this.config.clone();
    }

    public LdapConfigurationBuilder userNameVariableName(String userNameVariableName) {
        this.config.setUserNameVariableName(userNameVariableName);
        return this;
    }

    public LdapConfigurationBuilder accountBase(String accountBase) {
        this.config.setAccountBase(accountBase);
        return this;
    }

    public LdapConfigurationBuilder accountEmailAddress(String accountEmail) {
        this.config.setAccountEmailAddress(accountEmail);
        return this;
    }

    public LdapConfigurationBuilder accountDisplayName(String accountDisplayName) {
        this.config.setAccountDisplayName(accountDisplayName);
        return this;
    }

    public LdapConfigurationBuilder accountPattern(String accountPattern) {
        this.config.setAccountPattern(accountPattern);
        return this;
    }

    public LdapConfigurationBuilder accountScope(LdapSearchScope accountScope) {
        this.config.setAccountScope(accountScope);
        return this;
    }

    public LdapConfigurationBuilder accountUserName(String accountUserName) {
        this.config.setAccountUserName(accountUserName);
        return this;
    }

    public LdapConfigurationBuilder authenticationType(LdapAuthenticationType authType) {
        this.config.setAuthenticationType(authType);
        return this;
    }

    public LdapConfigurationBuilder groupBase(String groupBase) {
        this.config.setGroupBase(groupBase);
        return this;
    }

    public LdapConfigurationBuilder groupPattern(String groupPattern) {
        this.config.setGroupPattern(groupPattern);
        return this;
    }

    public LdapConfigurationBuilder groupScope(LdapSearchScope scope) {
        this.config.setGroupScope(scope);
        return this;
    }

    public LdapConfigurationBuilder password(String password) {
        this.config.setPassword(password);
        return this;
    }

    public LdapConfigurationBuilder readTimeoutInMillis(long readTimeout) {
        this.config.setReadTimeoutInMillis(readTimeout);
        return this;
    }

    public LdapConfigurationBuilder referralHandlingType(LdapReferralHandlingType referralHandlingType) {
        this.config.setReferralHandlingType(referralHandlingType);
        return this;
    }

    public LdapConfigurationBuilder serverAddress(String serverAddress) {
        this.config.setServerAddress(serverAddress);
        return this;
    }

    public LdapConfigurationBuilder sslVerify(boolean sslVerify) {
        this.config.setSslVerifyEnabled(sslVerify);
        return this;
    }

    public LdapConfigurationBuilder userName(String userName) {
        this.config.setUserName(userName);
        return this;
    }

    public LdapConfigurationBuilder userNameToLowerCase(boolean usernameToLowercase) {
        this.config.setUserNameToLowerCase(usernameToLowercase);
        return this;
    }

    public LdapConfigurationBuilder groupName(String groupNamePattern) {
        this.config.setGroupName(groupNamePattern);
        return this;
    }

    public LdapConfigurationBuilder groupByGroupMemberPattern(String groupMemberPattern) {
        this.config.setGroupByGroupMemberPattern(groupMemberPattern);
        return this;
    }

    public LdapConfigurationBuilder credentialSource(LdapCredentialsSource source) {
        this.config.setCredentialsSource(source);
        return this;
    }

    public LdapConfigurationBuilder groupMembersOf(String memberOfGroups) {
        this.config.setGroupMembersOf(memberOfGroups);
        return this;
    }

    public LdapConfigurationBuilder groupNamespace(String groupNamespace) {
        this.config.setGroupNamespace(groupNamespace);
        return this;
    }

    private static final class LdapConfigurationImpl
    implements LdapConfiguration,
    Cloneable {
        private String serverAddress;
        private String userName;
        private String password;
        private LdapCredentialsSource credentialsSource;
        private LdapReferralHandlingType referralHandlingType;
        private long readTimeout;
        private boolean usernameToLowercase;
        private LdapAuthenticationType authType;
        private boolean sslVerify;
        private String userNameVariableName;
        private String accountBase;
        private LdapSearchScope accountScope;
        private String accountSearchPattern;
        private String accountUserName;
        private String accountDisplayName;
        private String accountEmail;
        private String groupBase;
        private LdapSearchScope groupScope;
        private String groupSearchPattern;
        private String groupNamePattern;
        private String groupByGroupMemberPattern;
        private String membersOfGroups;
        private String groupNamespace;

        private LdapConfigurationImpl() {
        }

        @Override
        public LdapCredentialsSource getCredentialsSource() {
            return this.credentialsSource;
        }

        public void setCredentialsSource(LdapCredentialsSource credentialsSource) {
            this.credentialsSource = credentialsSource;
        }

        @Override
        public String getAccountBase() {
            return this.accountBase;
        }

        @Override
        public String getAccountEmailAddress() {
            return this.accountEmail;
        }

        @Override
        public String getAccountDisplayName() {
            return this.accountDisplayName;
        }

        @Override
        public String getAccountPattern() {
            return this.accountSearchPattern;
        }

        @Override
        public LdapSearchScope getAccountSearchScope() {
            return this.accountScope;
        }

        @Override
        public String getUserNameVariableName() {
            return this.userNameVariableName;
        }

        @Override
        public String getGroupMembersOf() {
            return this.membersOfGroups;
        }

        @Override
        public LdapAuthenticationType getAuthenticationType() {
            return this.authType;
        }

        @Override
        public String getGroupBase() {
            return this.groupBase;
        }

        @Override
        public String getGroupPattern() {
            return this.groupSearchPattern;
        }

        @Override
        public LdapSearchScope getGroupSearchScope() {
            return this.groupScope;
        }

        @Override
        public String getPassword() {
            return this.password;
        }

        @Override
        public long getReadTimeoutInMillis() {
            return this.readTimeout;
        }

        @Override
        public LdapReferralHandlingType getReferralHandlingType() {
            return this.referralHandlingType;
        }

        @Override
        public String getServerAddress() {
            return this.serverAddress;
        }

        @Override
        public String getUsername() {
            return this.userName;
        }

        @Override
        public boolean isSslVerifyEnabled() {
            return this.sslVerify;
        }

        @Override
        public boolean isUserNameToLowerCaseEnabled() {
            return this.usernameToLowercase;
        }

        public void setAccountBase(String accountBase) {
            this.accountBase = accountBase;
        }

        public void setAccountEmailAddress(String accountEmail) {
            this.accountEmail = accountEmail;
        }

        public void setAccountDisplayName(String accountDisplayName) {
            this.accountDisplayName = accountDisplayName;
        }

        public void setAccountPattern(String accountPattern) {
            this.accountSearchPattern = accountPattern;
        }

        public void setAccountScope(LdapSearchScope accountScope) {
            this.accountScope = accountScope;
        }

        public void setUserNameVariableName(String userNameVariableName) {
            this.userNameVariableName = userNameVariableName;
        }

        public void setGroupMembersOf(String membersOfGroups) {
            this.membersOfGroups = membersOfGroups;
        }

        @Override
        public String getAccountUserName() {
            return this.accountUserName;
        }

        public void setAccountUserName(String accountUserName) {
            this.accountUserName = accountUserName;
        }

        public void setAuthenticationType(LdapAuthenticationType authType) {
            this.authType = authType;
        }

        public void setGroupBase(String groupBase) {
            this.groupBase = groupBase;
        }

        public void setGroupPattern(String groupPattern) {
            this.groupSearchPattern = groupPattern;
        }

        public void setGroupScope(LdapSearchScope scope) {
            this.groupScope = scope;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public void setReadTimeoutInMillis(long readTimeout) {
            this.readTimeout = readTimeout;
        }

        public void setReferralHandlingType(LdapReferralHandlingType referralHandlingType) {
            this.referralHandlingType = referralHandlingType;
        }

        public void setServerAddress(String serverAddress) {
            this.serverAddress = serverAddress;
        }

        public void setSslVerifyEnabled(boolean sslVerify) {
            this.sslVerify = sslVerify;
        }

        public void setUserName(String userName) {
            this.userName = userName;
        }

        public void setUserNameToLowerCase(boolean usernameToLowercase) {
            this.usernameToLowercase = usernameToLowercase;
        }

        @Override
        public String getGroupName() {
            return this.groupNamePattern;
        }

        public void setGroupName(String groupNamePattern) {
            this.groupNamePattern = groupNamePattern;
        }

        @Override
        public String getGroupByGroupMemberPattern() {
            return this.groupByGroupMemberPattern;
        }

        public void setGroupByGroupMemberPattern(String groupByGroupMemberPattern) {
            this.groupByGroupMemberPattern = groupByGroupMemberPattern;
        }

        @Override
        public String getGroupNamespace() {
            return this.groupNamespace;
        }

        public void setGroupNamespace(String groupNamespace) {
            this.groupNamespace = groupNamespace;
        }

        public synchronized LdapConfiguration clone() {
            LdapConfigurationImpl cloned = new LdapConfigurationImpl();
            cloned.serverAddress = this.serverAddress;
            cloned.userName = this.userName;
            cloned.password = this.password;
            cloned.authType = this.authType;
            cloned.credentialsSource = this.credentialsSource;
            cloned.referralHandlingType = this.referralHandlingType;
            cloned.readTimeout = this.readTimeout;
            cloned.usernameToLowercase = this.usernameToLowercase;
            cloned.sslVerify = this.sslVerify;
            cloned.accountScope = this.accountScope;
            cloned.accountBase = this.accountBase;
            cloned.accountSearchPattern = this.accountSearchPattern;
            cloned.accountUserName = this.accountUserName;
            cloned.accountDisplayName = this.accountDisplayName;
            cloned.accountEmail = this.accountEmail;
            cloned.userNameVariableName = this.userNameVariableName;
            cloned.membersOfGroups = this.membersOfGroups;
            cloned.groupScope = this.groupScope;
            cloned.groupBase = this.groupBase;
            cloned.groupSearchPattern = this.groupSearchPattern;
            cloned.groupNamePattern = this.groupNamePattern;
            cloned.groupByGroupMemberPattern = this.groupByGroupMemberPattern;
            cloned.groupNamespace = this.groupNamespace;
            return cloned;
        }

        public void loadProperties(Map<String, Object> props) {
            if (props != null && !props.isEmpty()) {
                this.setServerAddress(this.get(props, LdapConstants.LDAP_SERVER_ADDRESS, LdapAuthenticationType.NONE));
                this.setAuthenticationType(this.getAuthType(props, LdapConstants.LDAP_AUTHENTICATION_TYPE, LdapConstants.DEFAULT_AUTHENTICATION_TYPE));
                this.setCredentialsSource(this.getSrc(props, LdapConstants.LDAP_CREDENTIALS_SOURCE, LdapConstants.DEFAULT_LDAP_CREDENTIALS_SOURCE));
                this.setUserName(this.get(props, LdapConstants.LDAP_USER_NAME, LdapConstants.DEFAULT_USERNAME));
                this.setPassword(this.get(props, LdapConstants.LDAP_PASSWORD, LdapConstants.DEFAULT_PASSWORD));
                this.setReadTimeoutInMillis(this.getLong(props, LdapConstants.LDAP_READ_TIMEOUT, -1L));
                this.setReferralHandlingType(this.getRefType(props, LdapConstants.LDAP_REFERRAL_HANDLING, LdapConstants.DEFAULT_LDAP_REFERRAL_HANDLING));
                this.setSslVerifyEnabled(this.getBoolean(props, LdapConstants.LDAP_SSL_VERIFY, true));
                this.setUserNameToLowerCase(this.getBoolean(props, LdapConstants.LDAP_USERNAME_TO_LOWERCASE, false));
                this.setUserNameVariableName(this.get(props, LdapConstants.USERNAME_VARIABLE_NAME, LdapConstants.PATTERN_DEFAULT));
                this.setAccountBase(this.get(props, LdapConstants.ACCOUNT_BASE, LdapConstants.PATTERN_DEFAULT));
                this.setAccountDisplayName(this.get(props, LdapConstants.ACCOUNT_DISPLAY_NAME, LdapConstants.PATTERN_DEFAULT));
                this.setAccountEmailAddress(this.get(props, LdapConstants.ACCOUNT_EMAIL_ADDRESS, LdapConstants.PATTERN_DEFAULT));
                this.setAccountPattern(this.get(props, LdapConstants.ACCOUNT_PATTERN, LdapConstants.PATTERN_DEFAULT));
                this.setAccountScope(this.getScope(props, LdapConstants.ACCOUNT_SCOPE, LdapConstants.DEFAULT_SEARCH_SCOPE));
                this.setAccountUserName(this.get(props, LdapConstants.ACCOUNT_USERNAME_PATTERN, LdapConstants.PATTERN_DEFAULT));
                this.setGroupBase(this.get(props, LdapConstants.GROUP_BASE, LdapConstants.PATTERN_DEFAULT));
                this.setGroupPattern(this.get(props, LdapConstants.GROUP_PATTERN, LdapConstants.PATTERN_DEFAULT));
                this.setGroupScope(this.getScope(props, LdapConstants.GROUP_SCOPE, LdapConstants.DEFAULT_SEARCH_SCOPE));
                this.setGroupName(this.get(props, LdapConstants.GROUP_NAME_PATTERN, LdapConstants.PATTERN_DEFAULT));
                this.setGroupByGroupMemberPattern(this.get(props, LdapConstants.GROUP_BY_GROUP_MEMBER_PATTERN, LdapConstants.PATTERN_DEFAULT));
                this.setGroupMembersOf(this.get(props, LdapConstants.GROUP_MEMBER_OF, LdapConstants.PATTERN_DEFAULT));
                this.setGroupNamespace(this.get(props, LdapConstants.GROUP_NAMESPACE, "ldap"));
            }
        }

        private Long getLong(Map<String, Object> props, String key, Long defaultValue) {
            String toReturn = this.get(props, key, String.valueOf(defaultValue));
            return Strings.isNumeric((String)toReturn) ? Long.parseLong(toReturn) : -1L;
        }

        private LdapSearchScope getScope(Map<String, Object> props, String key, LdapSearchScope defaultValue) {
            String toReturn = this.get(props, key, defaultValue);
            return LdapSearchScope.parse(toReturn);
        }

        private LdapReferralHandlingType getRefType(Map<String, Object> props, String key, LdapReferralHandlingType defaultValue) {
            String toReturn = this.get(props, key, defaultValue);
            return LdapReferralHandlingType.parse(toReturn);
        }

        private LdapCredentialsSource getSrc(Map<String, Object> props, String key, LdapCredentialsSource defaultValue) {
            String toReturn = this.get(props, key, defaultValue);
            return LdapCredentialsSource.parse(toReturn);
        }

        private LdapAuthenticationType getAuthType(Map<String, Object> props, String key, LdapAuthenticationType defaultValue) {
            String toReturn = this.get(props, key, defaultValue);
            return LdapAuthenticationType.parse(toReturn);
        }

        private boolean getBoolean(Map<String, Object> props, String key, boolean defaultValue) {
            String toReturn = this.get(props, key, String.valueOf(defaultValue));
            return Boolean.parseBoolean(toReturn);
        }

        private String get(Map<String, Object> props, String key, Enum<?> defaultValue) {
            return this.get(props, key, defaultValue != null ? defaultValue.name() : null);
        }

        private String get(Map<String, Object> props, String key, String defaultValue) {
            String toReturn = defaultValue;
            Object object = props.get(key);
            if (object != null) {
                toReturn = String.valueOf(object);
            }
            return toReturn;
        }
    }
}

