/*********************************************************************
 * Copyright (c) 2013 Boeing
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     Boeing - initial API and implementation
 **********************************************************************/

package org.eclipse.osee.account.rest.model;

import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.HashMap;
import java.util.Map;

/**
 * @author Roberto E. Escobar
 */
@XmlRootElement
public class AccountPreferencesData {

   private Long id;
   private Map<String, String> preferences;

   public Long getId() {
      return id;
   }

   public void setId(Long id) {
      this.id = id;
   }

   public Map<String, String> getMap() {
      if (preferences == null) {
         preferences = new HashMap<>();
      }
      return preferences;
   }

   public void setMap(Map<String, String> preferences) {
      this.preferences = preferences;
   }

}
