package com.vladsch.flexmark.formatter;

import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.parser.ParserEmulationProfile;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.format.CharWidthProvider;
import com.vladsch.flexmark.util.format.options.*;
import org.jetbrains.annotations.Nullable;

import java.util.regex.Pattern;

public class FormatterOptions {
    final public boolean itemContentIndent;

    final public ParserEmulationProfile emulationProfile;
    final public boolean setextHeadingEqualizeMarker;
    final public int formatFlags;
    final public int maxBlankLines;
    final public int maxTrailingBlankLines;
    final public int rightMargin;
    final public int minSetextMarkerLength;
    final public DiscretionaryText spaceAfterAtxMarker;
    final public EqualizeTrailingMarker atxHeadingTrailingMarker;
    final public HeadingStyle headingStyle;
    final public boolean blockQuoteBlankLines;
    final public BlockQuoteMarker blockQuoteMarkers;
    final public String thematicBreak;
    final public String translationIdFormat;
    final public String translationHtmlBlockPrefix;
    final public String translationHtmlInlinePrefix;
    final public String translationExcludePattern;
    final public String translationHtmlBlockTagPattern;
    final public String translationHtmlInlineTagPattern;
    final public String translationAutolinkPrefix;
    final public boolean indentedCodeMinimizeIndent;
    final public boolean fencedCodeMinimizeIndent;
    final public boolean fencedCodeMatchClosingMarker;
    final public boolean fencedCodeSpaceBeforeInfo;
    final public int fencedCodeMarkerLength;
    final public CodeFenceMarker fencedCodeMarkerType;
    final public boolean listAddBlankLineBefore;
    final public boolean listRenumberItems;
    final public boolean listRemoveEmptyItems;
    final public boolean listsItemContentAfterSuffix;
    final public ListBulletMarker listBulletMarker;
    final public ListNumberedMarker listNumberedMarker;
    final public ListSpacing listSpacing;
    final public ElementPlacement referencePlacement;
    final public ElementPlacementSort referenceSort;
    final public boolean keepImageLinksAtStart;
    final public boolean keepExplicitLinksAtStart;
    final public boolean keepHardLineBreaks;
    final public boolean keepSoftLineBreaks;
    final public boolean appendTransferredReferences;
    final public boolean optimizedInlineRendering;
    final public boolean applySpecialLeadInHandlers;
    final public boolean escapeSpecialCharsOnWrap;
    final public boolean escapeNumberedLeadInOnWrap;
    final public boolean unescapeSpecialCharsOnWrap;
    final public CharWidthProvider charWidthProvider;
    final public ElementAlignment listAlignNumeric;
    final public boolean listResetFirstItemNumber;
    final public String formatterOnTag;
    final public String formatterOffTag;
    final public boolean formatterTagsEnabled;
    final public boolean formatterTagsAcceptRegexp;
    final public boolean blankLinesInAst;
    final public @Nullable Pattern linkMarkerCommentPattern;

    public FormatterOptions(DataHolder options) {
        emulationProfile = Formatter.FORMATTER_EMULATION_PROFILE.get(options);
        itemContentIndent = emulationProfile.family != ParserEmulationProfile.FIXED_INDENT;

        setextHeadingEqualizeMarker = Formatter.SETEXT_HEADING_EQUALIZE_MARKER.get(options);
        formatFlags = Formatter.FORMAT_FLAGS.get(options);
        maxBlankLines = Formatter.MAX_BLANK_LINES.get(options);
        maxTrailingBlankLines = Formatter.MAX_TRAILING_BLANK_LINES.get(options);
        rightMargin = Formatter.RIGHT_MARGIN.get(options);
        minSetextMarkerLength = Parser.HEADING_SETEXT_MARKER_LENGTH.get(options);
        spaceAfterAtxMarker = Formatter.SPACE_AFTER_ATX_MARKER.get(options);
        atxHeadingTrailingMarker = Formatter.ATX_HEADING_TRAILING_MARKER.get(options);
        headingStyle = Formatter.HEADING_STYLE.get(options);
        thematicBreak = Formatter.THEMATIC_BREAK.get(options);
        translationIdFormat = Formatter.TRANSLATION_ID_FORMAT.get(options);
        translationHtmlBlockPrefix = Formatter.TRANSLATION_HTML_BLOCK_PREFIX.get(options);
        translationHtmlInlinePrefix = Formatter.TRANSLATION_HTML_INLINE_PREFIX.get(options);
        translationAutolinkPrefix = Formatter.TRANSLATION_AUTOLINK_PREFIX.get(options);
        translationExcludePattern = Formatter.TRANSLATION_EXCLUDE_PATTERN.get(options);
        translationHtmlBlockTagPattern = Formatter.TRANSLATION_HTML_BLOCK_TAG_PATTERN.get(options);
        translationHtmlInlineTagPattern = Formatter.TRANSLATION_HTML_INLINE_TAG_PATTERN.get(options);
        blockQuoteBlankLines = Formatter.BLOCK_QUOTE_BLANK_LINES.get(options);
        blockQuoteMarkers = Formatter.BLOCK_QUOTE_MARKERS.get(options);
        indentedCodeMinimizeIndent = Formatter.INDENTED_CODE_MINIMIZE_INDENT.get(options);
        fencedCodeMinimizeIndent = Formatter.FENCED_CODE_MINIMIZE_INDENT.get(options);
        fencedCodeMatchClosingMarker = Formatter.FENCED_CODE_MATCH_CLOSING_MARKER.get(options);
        fencedCodeSpaceBeforeInfo = Formatter.FENCED_CODE_SPACE_BEFORE_INFO.get(options);
        fencedCodeMarkerLength = Formatter.FENCED_CODE_MARKER_LENGTH.get(options);
        fencedCodeMarkerType = Formatter.FENCED_CODE_MARKER_TYPE.get(options);
        listAddBlankLineBefore = Formatter.LIST_ADD_BLANK_LINE_BEFORE.get(options);
        listAlignNumeric = Formatter.LIST_ALIGN_NUMERIC.get(options);
        listResetFirstItemNumber = Formatter.LIST_RESET_FIRST_ITEM_NUMBER.get(options);
        listRenumberItems = Formatter.LIST_RENUMBER_ITEMS.get(options);
        listRemoveEmptyItems = Formatter.LIST_REMOVE_EMPTY_ITEMS.get(options);
        listBulletMarker = Formatter.LIST_BULLET_MARKER.get(options);
        listNumberedMarker = Formatter.LIST_NUMBERED_MARKER.get(options);
        listSpacing = Formatter.LIST_SPACING.get(options);
        listsItemContentAfterSuffix = Formatter.LISTS_ITEM_CONTENT_AFTER_SUFFIX.get(options);
        referencePlacement = Formatter.REFERENCE_PLACEMENT.get(options);
        referenceSort = Formatter.REFERENCE_SORT.get(options);
        keepImageLinksAtStart = Formatter.KEEP_IMAGE_LINKS_AT_START.get(options);
        keepExplicitLinksAtStart = Formatter.KEEP_EXPLICIT_LINKS_AT_START.get(options);
        charWidthProvider = Formatter.FORMAT_CHAR_WIDTH_PROVIDER.get(options);
        keepHardLineBreaks = Formatter.KEEP_HARD_LINE_BREAKS.get(options);
        keepSoftLineBreaks = Formatter.KEEP_SOFT_LINE_BREAKS.get(options);
        formatterOnTag = Formatter.FORMATTER_ON_TAG.get(options);
        formatterOffTag = Formatter.FORMATTER_OFF_TAG.get(options);
        formatterTagsEnabled = Formatter.FORMATTER_TAGS_ENABLED.get(options);
        formatterTagsAcceptRegexp = Formatter.FORMATTER_TAGS_ACCEPT_REGEXP.get(options);
        linkMarkerCommentPattern = Formatter.LINK_MARKER_COMMENT_PATTERN.get(options);
        appendTransferredReferences = Formatter.APPEND_TRANSFERRED_REFERENCES.get(options);
        optimizedInlineRendering = Formatter.OPTIMIZED_INLINE_RENDERING.get(options);
        applySpecialLeadInHandlers = Formatter.APPLY_SPECIAL_LEAD_IN_HANDLERS.get(options);
        escapeSpecialCharsOnWrap = Formatter.ESCAPE_SPECIAL_CHARS.get(options);
        escapeNumberedLeadInOnWrap = Formatter.ESCAPE_NUMBERED_LEAD_IN.get(options);
        unescapeSpecialCharsOnWrap = Formatter.UNESCAPE_SPECIAL_CHARS.get(options);
        blankLinesInAst = Parser.BLANK_LINES_IN_AST.get(options);
    }
}
