/*********************************************************************
 * Copyright (c) 2023 Boeing
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     Boeing - initial API and implementation
 **********************************************************************/
package org.eclipse.osee.orcs.rest.model.transaction;

/**
 * @author David W. Miller
 * @author autogenerated by jsonschema2pojo
 */
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({"typeId", "sideB", "sideA", "typeName", "rationale"})
public class Relation {

   @JsonProperty("typeId")
   private String typeId;
   @JsonProperty("sideB")
   private String sideB;
   @JsonProperty("sideA")
   private List<String> sideA;
   @JsonProperty("typeName")
   private String typeName;
   @JsonProperty("rationale")
   private String rationale;
   @JsonIgnore
   private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

   @JsonProperty("typeId")
   public String getTypeId() {
      return typeId;
   }

   @JsonProperty("typeId")
   public void setTypeId(String typeId) {
      this.typeId = typeId;
   }

   @JsonProperty("sideB")
   public String getSideB() {
      return sideB;
   }

   @JsonProperty("sideB")
   public void setSideB(String sideB) {
      this.sideB = sideB;
   }

   @JsonProperty("sideA")
   public List<String> getSideA() {
      return sideA;
   }

   @JsonProperty("sideA")
   public void setSideA(List<String> sideA) {
      this.sideA = sideA;
   }

   @JsonProperty("typeName")
   public String getTypeName() {
      return typeName;
   }

   @JsonProperty("typeName")
   public void setTypeName(String typeName) {
      this.typeName = typeName;
   }

   @JsonProperty("rationale")
   public String getRationale() {
      return rationale;
   }

   @JsonProperty("rationale")
   public void setRationale(String rationale) {
      this.rationale = rationale;
   }

   @JsonAnyGetter
   public Map<String, Object> getAdditionalProperties() {
      return this.additionalProperties;
   }

   @JsonAnySetter
   public void setAdditionalProperty(String name, Object value) {
      this.additionalProperties.put(name, value);
   }

}
