/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.api.workflow;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.agile.IAgileBacklog;
import org.eclipse.osee.ats.api.agile.IAgileItem;
import org.eclipse.osee.ats.api.agile.IAgileSprint;
import org.eclipse.osee.ats.api.review.IAtsAbstractReview;
import org.eclipse.osee.ats.api.team.ChangeTypes;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.team.Priorities;
import org.eclipse.osee.ats.api.user.AtsCoreUsers;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.workdef.IStateToken;
import org.eclipse.osee.ats.api.workdef.WidgetResult;
import org.eclipse.osee.ats.api.workdef.model.StateDefinition;
import org.eclipse.osee.ats.api.workflow.IAtsAction;
import org.eclipse.osee.ats.api.workflow.IAtsGoal;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.ITeamWorkflowProvidersLazy;
import org.eclipse.osee.ats.api.workflow.hooks.IAtsTransitionHook;
import org.eclipse.osee.ats.api.workflow.hooks.IAtsWorkItemHook;
import org.eclipse.osee.ats.api.workflow.journal.JournalData;
import org.eclipse.osee.ats.api.workflow.log.IAtsLogItem;
import org.eclipse.osee.ats.api.workflow.log.LogType;
import org.eclipse.osee.ats.api.workflow.note.IAtsStateNoteService;
import org.eclipse.osee.ats.api.workflow.transition.TransitionData;
import org.eclipse.osee.ats.api.workflow.transition.TransitionResults;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public interface IAtsWorkItemService {
    public String getChangeTypeStr(IAtsWorkItem var1);

    public IStateToken getCurrentState(IAtsWorkItem var1);

    public Collection<IAtsAbstractReview> getReviews(IAtsTeamWorkflow var1);

    public Collection<IAtsAbstractReview> getReviews(IAtsTeamWorkflow var1, IStateToken var2);

    public IAtsTeamWorkflow getFirstTeam(Object var1);

    public void clearImplementersCache(IAtsWorkItem var1);

    public Collection<WidgetResult> validateWidgetTransition(IAtsWorkItem var1, StateDefinition var2);

    public Collection<IAtsTransitionHook> getTransitionHooks();

    public String getTargetedVersionStr(IAtsTeamWorkflow var1);

    public String getArtifactTypeShortName(IAtsTeamWorkflow var1);

    public Collection<IAtsTeamWorkflow> getTeams(Object var1);

    public String getCombinedPcrId(IAtsWorkItem var1);

    public IAtsStateNoteService getStateNoteService();

    public ITeamWorkflowProvidersLazy getTeamWorkflowProviders();

    public IAtsWorkItem getWorkItemByAnyId(String var1);

    public IAtsWorkItem getWorkItem(ArtifactToken var1);

    public IAtsTask getTask(ArtifactToken var1);

    public IAtsAbstractReview getReview(ArtifactToken var1);

    public IAtsGoal getGoal(ArtifactToken var1);

    public IAtsAction getAction(ArtifactToken var1);

    public IAtsWorkItem getWorkItemByAtsId(String var1);

    public IAgileSprint getAgileSprint(ArtifactToken var1);

    public IAgileBacklog getAgileBacklog(ArtifactToken var1);

    public IAgileItem getAgileItem(ArtifactToken var1);

    public Collection<IAtsWorkItem> getWorkItems(Collection<? extends ArtifactToken> var1);

    public IAtsTeamWorkflow getTeamWfNoCache(ArtifactToken var1);

    public IAtsTeamWorkflow getTeamWf(ArtifactToken var1);

    public String getCancelUrl(IAtsWorkItem var1, AtsApi var2);

    public String getHtmlUrl(IAtsWorkItem var1, AtsApi var2);

    public boolean isCancelHyperlinkConfigured();

    public IAtsWorkItem getWorkItem(Long var1);

    public Collection<IAtsTeamWorkflow> getSiblings(IAtsTeamWorkflow var1, IAtsTeamDefinition var2);

    public Collection<IAtsTeamWorkflow> getSiblings(IAtsTeamWorkflow var1);

    public void addTransitionHook(IAtsTransitionHook var1);

    public void addWorkItemHook(IAtsWorkItemHook var1);

    public void removeListener(IAtsTransitionHook var1);

    public Collection<IAtsWorkItemHook> getWorkItemHooks();

    public StateDefinition getStateByName(IAtsWorkItem var1, String var2);

    public TransitionResults transition(TransitionData var1);

    public TransitionResults transitionValidate(TransitionData var1);

    public void validateUserGroupTransition(IAtsWorkItem var1, StateDefinition var2, TransitionResults var3);

    public List<StateDefinition> getAllToStates(IAtsWorkItem var1);

    public StateDefinition getDefaultToState(IAtsWorkItem var1);

    public JournalData getJournalData(IAtsWorkItem var1, JournalData var2);

    public JournalData getJournalData(String var1);

    public JournalData getJournalSubscribed(IAtsWorkItem var1, JournalData var2);

    public boolean isBlocked(IAtsWorkItem var1);

    public boolean isOnHold(IAtsWorkItem var1);

    public String getCopyActionDetails(IAtsWorkItem var1);

    public List<ChangeTypes> getChangeTypeOptions(IAtsObject var1);

    public Pair<Boolean, Collection<ChangeTypes>> hasSameChangeTypes(Collection<IAtsTeamWorkflow> var1);

    public Pair<Boolean, Collection<Priorities>> hasSamePriorities(Collection<IAtsTeamWorkflow> var1);

    public List<Priorities> getPrioritiesOptions(IAtsObject var1);

    public String getCurrentStateName(IAtsWorkItem var1);

    public boolean isFavorite(IAtsWorkItem var1, AtsUser var2);

    public boolean isSubcribed(IAtsWorkItem var1, AtsUser var2);

    public List<AtsUser> getAssignees(IAtsWorkItem var1);

    default public boolean isUnAssignedSolely(IAtsWorkItem workItem) {
        return this.getAssignees(workItem).size() == 1 && this.isUnAssigned(workItem);
    }

    default public String getAssigneesStr(IAtsWorkItem workItem) {
        return Collections.toString((String)"; ", this.getAssignees(workItem));
    }

    default public String getAssigneesStr(IAtsWorkItem workItem, int length) {
        return Strings.truncate((String)Collections.toString((String)"; ", this.getAssignees(workItem)), (int)length);
    }

    default public boolean isUnAssigned(IAtsWorkItem workItem) {
        return this.getAssignees(workItem).contains(AtsCoreUsers.UNASSIGNED_USER);
    }

    default public boolean stateExists(IAtsWorkItem workItem, IStateToken state) {
        return this.stateExists(workItem, state.getName());
    }

    default public boolean stateExists(IAtsWorkItem workItem, String state) {
        return this.getStateStartedData(workItem, state) != null;
    }

    default public long getTimeInState(IAtsWorkItem workItem, IStateToken state) {
        if (state == null) {
            return 0L;
        }
        IAtsLogItem logItem = this.getStateStartedData(workItem, state);
        if (logItem == null) {
            return 0L;
        }
        return new Date().getTime() - logItem.getDate().getTime();
    }

    default public IAtsLogItem getStateStartedData(IAtsWorkItem workItem, IStateToken state) {
        return this.getStateStartedData(workItem, state.getName());
    }

    default public IAtsLogItem getStateStartedData(IAtsWorkItem workItem, String stateName) {
        return workItem.getLog().getStateEvent(LogType.StateEntered, stateName);
    }

    default public IAtsLogItem getStateCompletedData(IAtsWorkItem workItem, IStateToken state) {
        return this.getStateCompletedData(workItem, state.getName());
    }

    default public IAtsLogItem getStateCompletedData(IAtsWorkItem workItem, String stateName) {
        return workItem.getLog().getStateEvent(LogType.StateComplete, stateName);
    }

    default public IAtsLogItem getStateCancelledData(IAtsWorkItem workItem, IStateToken state) {
        return this.getStateCancelledData(workItem, state.getName());
    }

    default public IAtsLogItem getStateCancelledData(IAtsWorkItem workItem, String stateName) {
        return workItem.getLog().getStateEvent(LogType.StateCancelled, stateName);
    }

    default public double getTimeInState(IAtsWorkItem workItem) {
        return this.getTimeInState(workItem, workItem.getCurrentState());
    }

    default public Date getLastTransitionDate(IAtsWorkItem workItem) {
        IAtsLogItem logItem = this.getStateStartedData(workItem, workItem.getCurrentState());
        if (logItem != null) {
            return logItem.getDate();
        }
        return null;
    }

    default public String getWorkflowTitle(IAtsWorkItem workItem, String tabName) {
        String artifactTypeName = workItem.getArtifactTypeName();
        if (workItem.isChangeRequest()) {
            artifactTypeName = "CR";
        } else if (workItem.isTeamWorkflow()) {
            artifactTypeName = "TW";
        } else if (workItem.isBacklog()) {
            artifactTypeName = "BKLG";
        } else if (workItem.isTask()) {
            artifactTypeName = "TSK";
        } else if (workItem.isPeerReview()) {
            artifactTypeName = "PEER";
        } else if (workItem.isPeerReview()) {
            artifactTypeName = "DECISION";
        } else if (workItem.isSprint()) {
            artifactTypeName = "SPRINT";
        }
        String titleString = this.getTooltipTitle(workItem, tabName, artifactTypeName);
        String displayableTitle = Strings.escapeAmpersands((String)titleString);
        return displayableTitle;
    }

    default public String getTooltipTitle(IAtsWorkItem workItem, String tabName, String shortType) {
        String formTitle = Strings.isValid((String)tabName) ? String.valueOf(tabName) + " - " : "";
        formTitle = workItem.getParentTeamWorkflow() != null ? String.valueOf(formTitle) + String.format("%s - %s", shortType, workItem.getParentTeamWorkflow().getTeamDefinition()) : String.valueOf(formTitle) + String.format("%s", shortType);
        return formTitle;
    }

    public boolean isAllowSiblingCreation(IAtsWorkItem var1);
}

