/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.api.task.create;

import org.eclipse.osee.ats.api.data.AtsTaskDefToken;
import org.eclipse.osee.ats.api.task.create.ChangeReportOptions;
import org.eclipse.osee.ats.api.task.create.CreateChangeReportTasksDefinitionBuilder;
import org.eclipse.osee.ats.api.task.create.CreateTasksDefinition;
import org.eclipse.osee.ats.api.task.create.StaticTaskDefinition;
import org.eclipse.osee.ats.api.workdef.AtsWorkDefinitionToken;
import org.eclipse.osee.ats.api.workdef.AtsWorkDefinitionTokens;
import org.eclipse.osee.ats.api.workdef.RuleEventType;
import org.eclipse.osee.ats.api.workdef.StateToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.type.NamedIdBase;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class CreateTasksDefinitionBuilder
extends NamedIdBase {
    protected CreateTasksDefinition createTasksDef;

    public CreateTasksDefinitionBuilder(Long id, String name) {
        super(id, name);
        this.createTasksDef = new CreateTasksDefinition(id, name);
    }

    public CreateTasksDefinition getCreateTasksDef() {
        return this.createTasksDef;
    }

    public CreateTasksDefinitionBuilder(AtsTaskDefToken taskSetToken) {
        this(taskSetToken.getId(), taskSetToken.getName());
    }

    public CreateTasksDefinitionBuilder andTransitionTo(StateToken toState) {
        this.createTasksDef.setRuleEvent(RuleEventType.TransitionTo);
        this.createTasksDef.setToState(toState.getName());
        return this;
    }

    public CreateTasksDefinitionBuilder andEventType(RuleEventType ruleEventType) {
        Conditions.assertFalse((ruleEventType == RuleEventType.TransitionTo ? 1 : 0) != 0, (String)"Invalid event type TransitionTo; use andTransitionTo()", (Object[])new Object[0]);
        this.createTasksDef.setRuleEvent(ruleEventType);
        return this;
    }

    public CreateTasksDefinitionBuilder andStaticTask(String title, String desc, StateToken relatedToState, Long ... assigneeAccountId) {
        return this.andStaticTask(title, desc, relatedToState, AtsWorkDefinitionTokens.WorkDef_Team_Default, assigneeAccountId);
    }

    public CreateTasksDefinitionBuilder andStaticTask(String name, String desc, StateToken relatedToState, AtsWorkDefinitionToken workDef, Long ... assigneeAccountId) {
        Conditions.assertNotNullOrEmpty((String)name, (String)"title can not be empty", (Object[])new Object[0]);
        StaticTaskDefinition taskDef = new StaticTaskDefinition();
        taskDef.setName(name);
        if (Strings.isValid((String)desc)) {
            taskDef.setDescription(desc);
        }
        if (relatedToState != null && Strings.isValid((String)relatedToState.getName())) {
            taskDef.setRelatedToState(relatedToState.getName());
        }
        Long[] longArray = assigneeAccountId;
        int n = assigneeAccountId.length;
        int n2 = 0;
        while (n2 < n) {
            Long assigneAccountId = longArray[n2];
            taskDef.getAssigneeAccountIds().add(assigneAccountId);
            ++n2;
        }
        taskDef.setWorkDefTok(workDef);
        this.createTasksDef.getStaticTaskDefs().add(taskDef);
        return this;
    }

    public CreateTasksDefinitionBuilder andStaticTask(String name, String desc) {
        return this.andStaticTask(name, desc, null, AtsWorkDefinitionTokens.WorkDef_Task_Default, new Long[0]);
    }

    public CreateTasksDefinitionBuilder andStaticTask(String name) {
        return this.andStaticTask(name, null, null, AtsWorkDefinitionTokens.WorkDef_Task_Default, new Long[0]);
    }

    public CreateTasksDefinitionBuilder andStaticTask(String title, AtsWorkDefinitionToken taskWorkDef) {
        return this.andStaticTask(title, null, null, taskWorkDef, new Long[0]);
    }

    public CreateChangeReportTasksDefinitionBuilder andChgRptBuilder() {
        if (this instanceof CreateChangeReportTasksDefinitionBuilder) {
            return (CreateChangeReportTasksDefinitionBuilder)this;
        }
        throw new OseeArgumentException("andChgReportBuilder only valid for CreateChangeReportTasksDefinitionBuilder", new Object[0]);
    }

    public ChangeReportOptions getChgRptOptions() {
        return this.createTasksDef.getChgRptOptions();
    }

    public void setChgRptOptions(ChangeReportOptions chgRptOptions) {
        this.createTasksDef.setChgRptOptions(chgRptOptions);
    }

    public CreateTasksDefinitionBuilder andCopyAttributes(AttributeTypeToken ... copyAttrTypes) {
        AttributeTypeToken[] attributeTypeTokenArray = copyAttrTypes;
        int n = copyAttrTypes.length;
        int n2 = 0;
        while (n2 < n) {
            AttributeTypeToken copyAttrType = attributeTypeTokenArray[n2];
            this.createTasksDef.getChgRptOptions().getCopyAttrTypes().add(copyAttrType);
            ++n2;
        }
        return this;
    }
}

