/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.NamedIdBase;
import org.eclipse.osee.orcs.rest.model.CommandsRelatedToContext;

public class UserContext
extends NamedIdBase {
    private Map<String, String> attributes;
    private List<CommandsRelatedToContext> commands;

    public UserContext() {
    }

    public UserContext(ArtifactReadable context) {
        super(context.getId(), context.getName());
        this.setAttributes(this.createAttributeMap(context));
        this.setCommands(context.getRelated(CoreRelationTypes.ContextToCommand_Artifact, ArtifactTypeToken.SENTINEL).stream().filter(cmd -> cmd.isValid()).map(command -> new CommandsRelatedToContext((ArtifactReadable)command, context)).collect(Collectors.toList()));
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setCommands(List<CommandsRelatedToContext> commands) {
        this.commands = commands;
    }

    public List<CommandsRelatedToContext> getCommands() {
        return this.commands;
    }

    private Map<String, String> createAttributeMap(ArtifactReadable context) {
        HashMap<String, String> collectedAttributes = new HashMap<String, String>();
        if (!context.getExistingAttributeTypes().isEmpty()) {
            Collection types = context.getExistingAttributeTypes();
            for (AttributeTypeToken type : types) {
                if (!type.notEqual((Id)CoreAttributeTypes.Name)) continue;
                collectedAttributes.put(type.getName().toLowerCase(), context.getAttributeValuesAsString(type));
            }
        }
        return collectedAttributes;
    }
}

