/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.model;

import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.eclipse.osee.framework.core.applicability.ApplicabilityUseResultToken;
import org.eclipse.osee.framework.core.applicability.BatFile;
import org.eclipse.osee.framework.core.applicability.FeatureDefinition;
import org.eclipse.osee.framework.core.applicability.ProductTypeDefinition;
import org.eclipse.osee.framework.core.data.ApplicabilityData;
import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.ApplicabilityTokenWithConstraints;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BlockApplicabilityStageRequest;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.ConfigurationGroupDefinition;
import org.eclipse.osee.framework.core.data.CreateViewDefinition;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.Pair;

@Path(value="applic")
public interface ApplicabilityEndpoint {
    @GET
    @Path(value="ide")
    @Produces(value={"application/json"})
    public Collection<ApplicabilityToken> getApplicabilityTokens();

    @GET
    @Produces(value={"application/json"})
    public Collection<ApplicabilityToken> getApplicabilityTokens(@QueryParam(value="orderByName") @DefaultValue(value="false") boolean var1, @QueryParam(value="filter") @DefaultValue(value="") String var2, @QueryParam(value="pageNum") @DefaultValue(value="0") Long var3, @QueryParam(value="count") @DefaultValue(value="0") Long var4);

    @GET
    @Path(value="count")
    @Produces(value={"application/json"})
    public Long getApplicabilityTokenCount(@QueryParam(value="filter") @DefaultValue(value="") String var1);

    @POST
    @Path(value="compound")
    @Consumes(value={"text/plain"})
    @Produces(value={"application/json"})
    public XResultData createCompoundApplicabilityForBranch(String var1);

    @DELETE
    @Path(value="compound/{id}")
    @Produces(value={"application/json"})
    public XResultData deleteCompoundApplicabilityFromBranch(@PathParam(value="id") ApplicabilityId var1);

    @GET
    @Path(value="artifact/{artId}")
    @Produces(value={"application/json"})
    public ApplicabilityToken getApplicabilityToken(@PathParam(value="artId") ArtifactId var1);

    @GET
    @Path(value="artifact/reference/{artId}")
    @Produces(value={"application/json"})
    public List<ApplicabilityId> getApplicabilitiesReferenced(@PathParam(value="artId") ArtifactId var1);

    @GET
    @Path(value="artifact/reference/token/{artId}")
    @Produces(value={"application/json"})
    public List<ApplicabilityToken> getApplicabilityReferenceTokens(@PathParam(value="artId") ArtifactId var1);

    @GET
    @Path(value="cfggroup")
    @Produces(value={"application/json"})
    public List<ArtifactToken> getCfgGroup();

    @POST
    @Path(value="cfggroup")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public XResultData createCfgGroup(ConfigurationGroupDefinition var1);

    @PUT
    @Path(value="cfggroup")
    @Produces(value={"application/json"})
    public XResultData updateCfgGroup(ConfigurationGroupDefinition var1);

    @POST
    @Path(value="cfggroup/sync")
    @Produces(value={"application/json"})
    public XResultData syncCfgGroup();

    @DELETE
    @Path(value="cfggroup/{id}")
    @Produces(value={"application/json"})
    public XResultData deleteCfgGroup(@PathParam(value="id") String var1);

    @POST
    @Path(value="cfggroup/sync/{id}")
    @Produces(value={"application/json"})
    public XResultData syncCfgGroup(@PathParam(value="id") String var1);

    @GET
    @Path(value="cfggroup/def/{id}")
    @Produces(value={"application/json"})
    public ConfigurationGroupDefinition getConfigurationGroup(@PathParam(value="id") String var1);

    @PUT
    @Path(value="cfggroup/{groupId}/relate/{viewId}")
    @Produces(value={"application/json"})
    public XResultData relateCfgGroupToView(@PathParam(value="groupId") String var1, @PathParam(value="viewId") String var2);

    @PUT
    @Path(value="cfggroup/{groupId}/unrelate/{viewId}")
    @Produces(value={"application/json"})
    public XResultData unrelateCfgGroupToView(@PathParam(value="groupId") String var1, @PathParam(value="viewId") String var2);

    @GET
    @Path(value="features")
    @Produces(value={"application/json"})
    public List<FeatureDefinition> getFeatureDefinitionData(@QueryParam(value="productType") @DefaultValue(value="") String var1);

    @GET
    @Path(value="features/ide")
    @Produces(value={"application/json"})
    public List<FeatureDefinition> getFeatureDefinitionData();

    @PUT
    @Path(value="feature")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public XResultData updateFeature(FeatureDefinition var1);

    @POST
    @Path(value="feature")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public XResultData createFeature(FeatureDefinition var1);

    @GET
    @Path(value="feature/{featureNameOrId}")
    @Produces(value={"application/json"})
    public FeatureDefinition getFeature(@PathParam(value="featureNameOrId") String var1);

    @DELETE
    @Path(value="feature/{id}")
    @Produces(value={"application/json"})
    public XResultData deleteFeature(@PathParam(value="id") ArtifactId var1);

    @GET
    @Path(value="views")
    @Produces(value={"application/json"})
    public List<ArtifactToken> getViews(@QueryParam(value="orderByAttributeType") AttributeTypeToken var1);

    @GET
    @Path(value="views/ide")
    @Produces(value={"application/json"})
    public List<ArtifactToken> getViews();

    @PUT
    @Path(value="view")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public XResultData updateView(CreateViewDefinition var1);

    @POST
    @Path(value="view")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public XResultData createView(CreateViewDefinition var1);

    @PUT
    @Path(value="product-types")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public XResultData updateProductType(ProductTypeDefinition var1);

    @POST
    @Path(value="product-types")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public XResultData createProductType(ProductTypeDefinition var1);

    @GET
    @Path(value="view/{id}/ide")
    @Produces(value={"application/json"})
    public List<ApplicabilityToken> getViewApplicabilityTokens(@PathParam(value="id") ArtifactId var1);

    @GET
    @Path(value="view/{id}")
    @Produces(value={"application/json"})
    public List<ApplicabilityToken> getViewApplicabilityTokens(@PathParam(value="id") ArtifactId var1, @QueryParam(value="productType") @DefaultValue(value="") String var2);

    @DELETE
    @Path(value="view/{id}")
    @Produces(value={"application/json"})
    public XResultData deleteView(@PathParam(value="id") String var1);

    @PUT
    @Path(value="view/{id}/applic")
    @Consumes(value={"text/plain"})
    @Produces(value={"application/json"})
    public XResultData createApplicabilityForView(@PathParam(value="id") ArtifactId var1, String var2);

    @PUT
    @Path(value="view/copyFeatureApplicValues")
    @Produces(value={"application/json"})
    public XResultData copyFeatureApplicValues(@QueryParam(value="viewId") ArtifactId var1, @QueryParam(value="fromBranchId") BranchId var2, @QueryParam(value="fromViewId") ArtifactId var3, @QueryParam(value="overwrite") boolean var4);

    @DELETE
    @Path(value="view/{id}/applic")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public XResultData removeApplicabilityFromView(@PathParam(value="id") ArtifactId var1, String var2);

    @GET
    @Path(value="view/def/{id}")
    @Produces(value={"application/json"})
    public CreateViewDefinition getView(@PathParam(value="id") String var1);

    @GET
    @Path(value="product-types/{id}")
    @Produces(value={"application/json"})
    public ProductTypeDefinition getProductType(@PathParam(value="id") String var1);

    @DELETE
    @Path(value="product-types/{id}")
    @Produces(value={"application/json"})
    public XResultData deleteProductType(@PathParam(value="id") ArtifactId var1);

    @GET
    @Path(value="product-types")
    @Produces(value={"application/json"})
    public Collection<ProductTypeDefinition> getProductTypes(@QueryParam(value="pageNum") long var1, @QueryParam(value="count") long var3, @QueryParam(value="orderByAttributeType") AttributeTypeToken var5);

    @GET
    @Path(value="change")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public List<BranchId> getAffectedBranches(@QueryParam(value="injectionDateMs") Long var1, @QueryParam(value="removalDateMs") @DefaultValue(value="-1") Long var2, List<ApplicabilityId> var3);

    @PUT
    @Path(value="artifacts")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public List<Pair<ArtifactId, ApplicabilityToken>> getApplicabilityTokens(List<? extends ArtifactId> var1);

    @GET
    @Path(value="change")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public List<BranchId> getAffectedBranches(@QueryParam(value="injectiontx") TransactionId var1, @QueryParam(value="removaltx") @DefaultValue(value="-1") TransactionId var2, List<ApplicabilityId> var3);

    @GET
    @Path(value="table")
    @Produces(value={"text/html"})
    public String getViewTable(@QueryParam(value="filter") String var1, @DefaultValue(value="-1") @QueryParam(value="view") ArtifactId var2);

    @GET
    @Path(value="matrix")
    @Produces(value={"text/html"})
    public String getConfigMatrix(@QueryParam(value="matrixtype") String var1, @QueryParam(value="filter") String var2, @DefaultValue(value="-1") @QueryParam(value="view") ArtifactId var3);

    @PUT
    @Path(value="{applicId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public TransactionToken setApplicability(@PathParam(value="applicId") ApplicabilityId var1, List<? extends ArtifactId> var2);

    @PUT
    @Path(value="set/{applicTag}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public TransactionToken setApplicabilityByString(@PathParam(value="applicTag") String var1, List<? extends ArtifactId> var2);

    @PUT
    @Path(value="artifact/reference")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public TransactionToken setApplicabilityReference(List<ApplicabilityData> var1);

    @PUT
    @Path(value="update-from-parent")
    public void addMissingApplicabilityFromParentBranch();

    @GET
    @Path(value="access")
    @Produces(value={"application/json"})
    public XResultData isAccess();

    @POST
    @Path(value="blockVisibility")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public XResultData applyBlockVisibility(BlockApplicabilityStageRequest var1);

    @POST
    @Path(value="blockVisibility/refresh")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public XResultData refreshStagedFiles(BlockApplicabilityStageRequest var1);

    @PUT
    @Path(value="blockVisibility/startWatcher")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public XResultData startBlockVisibilityWatcher(BlockApplicabilityStageRequest var1);

    @PUT
    @Path(value="blockVisibility/stopWatcher")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public XResultData stopBlockVisibilityWatcher();

    @PUT
    @Path(value="validate")
    @Produces(value={"application/json"})
    public XResultData validate(@QueryParam(value="update") String var1);

    @GET
    @Path(value="applicabilityToken/{id}")
    @Produces(value={"application/json"})
    public ApplicabilityToken getApplicabilityTokenFromId(@PathParam(value="id") String var1);

    @GET
    @Path(value="/artifacts/applic")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public List<ApplicabilityUseResultToken> getApplicabilityUsage(@QueryParam(value="applic") String var1, @QueryParam(value="artTypes") List<ArtifactTypeToken> var2, @QueryParam(value="attrTypes") List<AttributeTypeToken> var3);

    @POST
    @Path(value="uploadBlockApplicability")
    @Produces(value={"application/octet-stream"})
    public String uploadBlockApplicability(InputStream var1);

    @POST
    @Path(value="blockVisibility/{blockApplicId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public XResultData applyBlockVisibilityOnServer(@PathParam(value="blockApplicId") String var1, BlockApplicabilityStageRequest var2);

    @GET
    @Path(value="downloadBlockApplicability/{blockApplicId}")
    @Produces(value={"application/octet-stream"})
    public Response downloadBlockApplicability(@PathParam(value="blockApplicId") String var1);

    @DELETE
    @Path(value="deleteBlockApplicability/{blockApplicId}")
    @Produces(value={"application/octet-stream"})
    public XResultData deleteBlockApplicability(@PathParam(value="blockApplicId") String var1);

    @POST
    @Path(value="uploadRunBlockApplicability")
    @Produces(value={"application/octet-stream"})
    public Response uploadRunBlockApplicability(@QueryParam(value="view") Long var1, InputStream var2);

    @POST
    @Path(value="constraint")
    @Produces(value={"application/json"})
    public XResultData addApplicabilityConstraint(@QueryParam(value="applicability1") ApplicabilityId var1, @QueryParam(value="applicability2") ApplicabilityId var2);

    @DELETE
    @Path(value="constraint")
    @Produces(value={"application/json"})
    public XResultData removeApplicabilityConstraint(@QueryParam(value="applicability1") ApplicabilityId var1, @QueryParam(value="applicability2") ApplicabilityId var2);

    @GET
    @Path(value="constraints")
    @Produces(value={"application/json"})
    public List<ApplicabilityTokenWithConstraints> getApplicabilityWithConstraints();

    @GET
    @Path(value="constraintConflicts")
    @Produces(value={"application/json"})
    public List<String> getApplicabilityConstraintConflicts(@QueryParam(value="childApplicability") ApplicabilityId var1, @QueryParam(value="parentApplicability") ApplicabilityId var2);

    @GET
    @Path(value="bazel")
    @Produces(value={"application/octet-stream"})
    public Response getBazelZip(@QueryParam(value="productType") @DefaultValue(value="") String var1);

    @GET
    @Path(value="bazel/features")
    @Produces(value={"application/octet-stream"})
    public String getBazelFeatures();

    @GET
    @Path(value="bazel/platforms/configurations")
    @Produces(value={"application/octet-stream"})
    public String getBazelPlatformConfigurations();

    @GET
    @Path(value="bazel/platforms/configuration-groups")
    @Produces(value={"application/octet-stream"})
    public String getBazelPlatformConfigurationGroups();

    @GET
    @Path(value="bazel/configurations")
    @Produces(value={"application/octet-stream"})
    public String getBazelConfigurations();

    @GET
    @Path(value="repository")
    @Produces(value={"application/octet-stream"})
    public Response getRepositoryZip(@QueryParam(value="productType") @DefaultValue(value="") String var1);

    @GET
    @Path(value="block")
    @Produces(value={"application/json"})
    public Collection<BatFile> getBlockApplicabilityToolConfiguration(@QueryParam(value="productType") @DefaultValue(value="") String var1);
}

