/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.api.publisher.templatemanager;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.osee.define.rest.api.publisher.templatemanager.PublishingTemplateKeyType;
import org.eclipse.osee.framework.jdk.core.util.Message;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.jdk.core.util.ToMessage;

public class PublishingTemplateScalarKey
implements Comparable<PublishingTemplateScalarKey>,
ToMessage {
    private static Set<String> keyTypes = Arrays.stream(PublishingTemplateKeyType.values()).map(Enum::name).collect(Collectors.toSet());
    private String key;
    private String keyType;

    public PublishingTemplateScalarKey() {
        this.key = null;
        this.keyType = null;
    }

    @JsonIgnore
    public PublishingTemplateScalarKey(String key, PublishingTemplateKeyType keyType) {
        this.key = Objects.requireNonNull(key, "PublishingTemplateScalarKey::new, the parameter \"key\" cannot be null.");
        this.keyType = Objects.requireNonNull(keyType, "PublishingTemplateScalarKey::new, the parameter \"keyType\" cannot be null.").name();
    }

    public PublishingTemplateScalarKey(String key, String keyType) {
        this.key = Objects.requireNonNull(key, "PublishingTemplateScalarKey::new, the parameter \"key\" cannot be null.");
        this.keyType = Objects.requireNonNull(keyType, "PublishingTemplateScalarKey::new, the parameter \"keyType\" cannot be null.");
    }

    @Override
    @JsonIgnore
    public int compareTo(PublishingTemplateScalarKey other) {
        return this.key.compareTo(other.key);
    }

    @JsonIgnore
    public boolean equals(Object other) {
        return other instanceof PublishingTemplateScalarKey && this.keyType.equals(((PublishingTemplateScalarKey)other).keyType) && this.key.equals(((PublishingTemplateScalarKey)other).key);
    }

    @JsonIgnore
    public int hashCode() {
        return this.key.hashCode();
    }

    public String getKey() {
        if (Objects.isNull(this.key)) {
            throw new IllegalStateException("PublishingTemplateScalarKey::getkey, parameter \"key\" has not been set.");
        }
        return this.key;
    }

    @JsonIgnore
    public PublishingTemplateKeyType getKeyTypeAs() {
        if (Objects.isNull(this.keyType) || !keyTypes.contains(this.keyType)) {
            throw new IllegalStateException("PublishingTemplateScalarKey::getKeyTypeAs, member \"keyType\" has not been set.");
        }
        return PublishingTemplateKeyType.valueOf(this.keyType);
    }

    public String getKeyType() {
        if (Objects.isNull(this.keyType)) {
            throw new IllegalStateException("PublishingTemplateScalarKey::getKeyType, parameter \"keyType\" has not been set.");
        }
        return this.keyType;
    }

    @JsonIgnore
    public boolean isValid() {
        return Strings.isValidAndNonBlank((String)this.key) && Objects.nonNull(this.keyType) && keyTypes.contains(this.keyType);
    }

    public void setKey(String key) {
        if (Objects.nonNull(this.key)) {
            throw new IllegalStateException("PublishingTemplateScalarKey::setkey, member \"key\" has already been set.");
        }
        this.key = Objects.requireNonNull(key, "PublishingTemplateScalarKey::setkey, member \"key\" has already been set.");
    }

    public void setKeyType(String keyType) {
        if (Objects.nonNull(this.keyType)) {
            throw new IllegalStateException("PublishingTemplatekey::setKeyType, member \"keyType\" has already been set.");
        }
        this.keyType = Objects.requireNonNull(keyType, "PublishingTemplatekey::setKeyType, parameter \"keyType\" cannot be null.");
    }

    @JsonIgnore
    public Message toMessage(int indent, Message message) {
        Message outMessage = message != null ? message : new Message();
        outMessage.title((CharSequence)"PublishingTemplateScalarKey").indentInc().segment((CharSequence)"Key Type", (Object)this.keyType).segment((CharSequence)"Key", (Object)this.key).indentDec();
        return outMessage;
    }

    @JsonIgnore
    public String toString() {
        return this.toMessage(0, null).toString();
    }
}

