/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util.io;

import java.io.File;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import org.eclipse.osee.framework.jdk.core.util.io.FileWatcherTimerTask;
import org.eclipse.osee.framework.jdk.core.util.io.IFileWatcherListener;

public final class FileWatcher {
    private final Timer timer = new Timer();
    private final Map<File, Long> filesToWatch = new ConcurrentHashMap<File, Long>(128);
    private final Set<IFileWatcherListener> listeners = new CopyOnWriteArraySet<IFileWatcherListener>();
    private final long interval;

    public FileWatcher(long time, TimeUnit unit) {
        this.interval = unit.toMillis(time);
    }

    public void start() {
        this.timer.schedule((TimerTask)new FileWatcherTimerTask(this.filesToWatch, this.listeners), this.interval, this.interval);
    }

    public void stop() {
        this.timer.cancel();
        this.listeners.clear();
        this.filesToWatch.clear();
    }

    public void addFile(File file) {
        this.filesToWatch.put(file, file.lastModified());
    }

    public Long removeFile(File file) {
        return this.filesToWatch.remove(file);
    }

    public void addListener(IFileWatcherListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IFileWatcherListener listener) {
        this.listeners.remove(listener);
    }
}

