/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util.benchmark;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class Benchmark {
    private static boolean IS_BENCHMARKING_ENABLED = false;
    private final long threshold;
    private long totalSamples;
    private long startTime;
    private long totalTime;
    private long exceedCount;
    private long longestSample;
    private long shortestSample;
    private long totalExceedAmount;
    private static final Vector<Benchmark> list = new Vector(16);
    private final HashMap<String, Integer> exceeders = new HashMap(100);
    private final String name;

    public Benchmark(String name) {
        this(name, Long.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Benchmark(String name, long threshold) {
        this.name = name;
        Vector<Benchmark> vector = list;
        synchronized (vector) {
            list.add(this);
        }
        this.threshold = threshold;
        this.totalSamples = 0L;
        this.totalTime = 0L;
        this.exceedCount = 0L;
        this.longestSample = 0L;
        this.shortestSample = Long.MAX_VALUE;
        this.startTime = Long.MIN_VALUE;
        this.totalExceedAmount = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetAll() {
        Vector<Benchmark> vector = list;
        synchronized (vector) {
            for (Benchmark bm : list) {
                bm.totalSamples = 0L;
                bm.totalTime = 0L;
                bm.exceedCount = 0L;
                bm.longestSample = 0L;
                bm.shortestSample = Long.MAX_VALUE;
                bm.startTime = Long.MIN_VALUE;
                bm.totalExceedAmount = 0L;
                bm.exceeders.clear();
            }
        }
    }

    public void startSample() {
        if (!Benchmark.isBenchmarkingEnabled()) {
            return;
        }
        this.startSample(System.nanoTime());
    }

    public void startSample(long time) {
        if (!Benchmark.isBenchmarkingEnabled()) {
            return;
        }
        this.startTime = time;
    }

    public void samplePoint() {
        if (!Benchmark.isBenchmarkingEnabled()) {
            return;
        }
        this.samplePoint(System.nanoTime());
    }

    public void samplePoint(long time) {
        if (!Benchmark.isBenchmarkingEnabled()) {
            return;
        }
        if (this.startTime == Long.MIN_VALUE) {
            this.startTime = time;
        } else {
            long duration = (time - this.startTime) / 1000L;
            this.totalTime += duration;
            if (duration > this.threshold) {
                ++this.exceedCount;
                this.totalExceedAmount += this.threshold - duration;
            }
            if (duration > this.longestSample) {
                this.longestSample = duration;
            }
            if (duration < this.shortestSample) {
                this.shortestSample = duration;
            }
            ++this.totalSamples;
            this.startTime = time;
        }
    }

    public boolean endSample() {
        if (!Benchmark.isBenchmarkingEnabled()) {
            return false;
        }
        return this.endSample(System.nanoTime());
    }

    public boolean endSample(long time) {
        boolean exceeded = false;
        if (!Benchmark.isBenchmarkingEnabled()) {
            return exceeded;
        }
        long duration = (time - this.startTime) / 1000L;
        this.totalTime += duration;
        if (duration > this.threshold) {
            ++this.exceedCount;
            this.totalExceedAmount += this.threshold - duration;
            exceeded = true;
        }
        if (duration > this.longestSample) {
            this.longestSample = duration;
        }
        if (duration < this.shortestSample) {
            this.shortestSample = duration;
        }
        ++this.totalSamples;
        return exceeded;
    }

    public long getExceedCount() {
        return this.exceedCount;
    }

    public long getLongestSample() {
        return this.longestSample;
    }

    public long getThreshold() {
        return this.threshold;
    }

    public long getTotalSamples() {
        return this.totalSamples;
    }

    public long getAverage() {
        if (this.totalSamples > 0L) {
            return this.totalTime / this.totalSamples;
        }
        return Long.MAX_VALUE;
    }

    public long getShortestSample() {
        return this.shortestSample;
    }

    public String getName() {
        return this.name;
    }

    public long getAverageExceedAmount() {
        if (this.exceedCount == 0L) {
            return 0L;
        }
        return Math.abs(this.totalExceedAmount / this.exceedCount);
    }

    public static void main(String[] args) {
        Benchmark bm = new Benchmark("unit test", 10000L);
        if (Benchmark.isBenchmarkingEnabled()) {
            System.out.println("benchmarking is enabled");
        } else {
            System.out.println("benchmarking is disabled");
        }
        int i = 0;
        while (i < 1000) {
            bm.startSample();
            try {
                Thread.sleep(i % 2 == 0 ? 5 : 10);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
            bm.endSample();
            ++i;
        }
        Object[] formatArgs = new Object[]{bm.getTotalSamples(), Float.valueOf((float)bm.getLongestSample() / 1000.0f), Float.valueOf((float)bm.getShortestSample() / 1000.0f), Float.valueOf((float)bm.getAverage() / 1000.0f), bm.getExceedCount()};
        MessageFormat outmessage = new MessageFormat("total samples: {0,number,integer}, max time: {1,number,integer}ms, min: {2,number,integer}ms, average: {3,number,integer}ms, exceed count: {4,number,integer}");
        System.out.println(outmessage.format(formatArgs));
    }

    public String toString() {
        return String.format("%s\t total samples: %d,\t average: %fms,\t max time: %f, min: %fms, exceed count: %d", this.name, this.getTotalSamples(), Float.valueOf(this.getLongestSample() / 1000L), Float.valueOf(this.getShortestSample() / 1000L), Float.valueOf(this.getAverage() / 1000L), this.getExceedCount());
    }

    public void addExceeder(String exceeder) {
        Integer c = this.exceeders.get(exceeder);
        if (c == null) {
            this.exceeders.put(exceeder, 1);
        } else {
            this.exceeders.put(exceeder, c + 1);
        }
    }

    public Collection<Map.Entry<String, Integer>> getExceeders() {
        return this.exceeders.entrySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Benchmark> getAllBenchamrks() {
        Vector<Benchmark> vector = list;
        synchronized (vector) {
            return new ArrayList<Benchmark>(list);
        }
    }

    public static void setBenchmarkingEnabled(boolean isEnabled) {
        IS_BENCHMARKING_ENABLED = isEnabled;
    }

    public static boolean isBenchmarkingEnabled() {
        return IS_BENCHMARKING_ENABLED;
    }
}

