/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util;

import java.util.Objects;
import java.util.function.Predicate;

public class ParameterArray {
    private ParameterArray() {
    }

    public static boolean validateElements(Object[] objects, Predicate<Object>[] elementValidators) {
        if (Objects.isNull(objects) || objects.length == 0) {
            return true;
        }
        int i = 0;
        while (i < objects.length && i < elementValidators.length) {
            if (!elementValidators[i].test(objects[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean validateNonNullAndSize(Object[] objects, int minSize, int maxSize) {
        assert (minSize >= 0 && maxSize >= minSize);
        if (Objects.isNull(objects) || objects.length < minSize || objects.length > maxSize) {
            return false;
        }
        int i = 0;
        while (i < objects.length) {
            if (Objects.isNull(objects[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean validateNonNullAndSize(Object[] objects, int minSize) {
        assert (minSize >= 0);
        if (Objects.isNull(objects) || objects.length < minSize) {
            return false;
        }
        int i = 0;
        while (i < objects.length) {
            if (Objects.isNull(objects[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean validateNonNullSizeAndElements(Object[] objects, int minSize, int maxSize, Predicate<Object> elementValidator) {
        assert (minSize >= 0 && maxSize >= minSize && Objects.nonNull(elementValidator));
        if (Objects.isNull(objects) || objects.length < minSize || objects.length > maxSize) {
            return false;
        }
        int i = 0;
        while (i < objects.length) {
            if (!elementValidator.test(objects[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean validateNonNullSizeAndElements(Object[] objects, int minSize, int maxSize, Predicate<Object>[] elementValidators) {
        assert (minSize >= 0 && maxSize >= minSize && ParameterArray.validateNonNullAndSize(elementValidators, maxSize));
        if (Objects.isNull(objects) || objects.length < minSize || objects.length > maxSize) {
            return false;
        }
        int i = 0;
        while (i < objects.length) {
            if (!elementValidators[i].test(objects[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean validateNullOrEmpty(Object[] objects) {
        return Objects.isNull(objects) || objects.length == 0;
    }

    public static boolean validateSize(Object[] objects, int minSize, int maxSize) {
        assert (minSize >= 0 && maxSize >= minSize);
        if (minSize == 0 && (Objects.isNull(objects) || objects.length == 0)) {
            return true;
        }
        return !Objects.isNull(objects) && objects.length >= minSize && objects.length <= maxSize;
    }

    public static boolean validateSizeAndElements(Object[] objects, int minSize, int maxSize, Predicate<Object>[] elementValidator) {
        assert (minSize >= 0 && maxSize >= minSize && ParameterArray.validateNonNullAndSize(elementValidator, maxSize));
        if (minSize == 0 && (Objects.isNull(objects) || objects.length == 0)) {
            return true;
        }
        if (Objects.isNull(objects) || objects.length < minSize || objects.length > maxSize) {
            return false;
        }
        int i = 0;
        while (i < objects.length) {
            if (!elementValidator[i].test(objects[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean validateSizeAndType(Object[] objects, int minSize, int maxSize, Class<?> type) {
        assert (minSize >= 0 && maxSize >= minSize && Objects.nonNull(type));
        if (minSize == 0 && (Objects.isNull(objects) || objects.length == 0)) {
            return true;
        }
        if (Objects.isNull(objects) || objects.length < minSize || objects.length > maxSize) {
            return false;
        }
        int i = 0;
        while (i < objects.length) {
            if (Objects.isNull(objects[i]) || !type.isInstance(objects[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

