/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class OseeProperties {
    private static final String OSEE_LOG_DEFAULT = "osee.log.default";
    private static final String OSEE_JINI_SERVICE_GROUPS = "osee.jini.lookup.groups";
    private static final String OSEE_JINI_FORCED_REGGIE_SEARCH = "osee.jini.forced.reggie.search";
    private static final String OSEE_PORT_SCAN_START_PORT = "osee.port.scanner.start.port";
    public static final String OSEE_DB_CONNECTION_ID = "osee.db.connection.id";
    private static final String OSEE_CONNECTION_INFO_URI = "osee.connection.info.uri";
    private static final String OSEE_EMBEDDED_DB_SERVER = "osee.db.embedded.server";
    private static final String OSEE_EMBEDDED_DB_WEB_SERVER_PORT = "osee.db.embedded.web.server.port";
    private static final String OSEE_DEFAULT_BROKER_URI = "osee.default.broker.uri";
    private static final String OSEE_PROXY_BYPASS_ENABLED = "osee.proxy.bypass.enabled";
    private static final String OSEE_DB_CONNECTION_POOL_SIZE = "osee.db.connection.pool.size";
    private static final String OSEE_DB_CONNECTION_POOL_CONFIG_URI = "osee.db.connection.pool.config.uri";
    public static final String OSEE_SHOW_TOKEN_FOR_CHANGE_NAME = "osee.show.token.for.change.name";
    public static final String OSEE_DB = "osee.db";
    public static final String OSEE_HEALTH_SERVERS_KEY = "osee.health.servers";
    public static final String OSEE_IS_IN_DB_INIT = "osee.is.in.db.init";
    private static final String JWT_LOGIN_KEY = "jwt.login.key";
    public static final String BASIC_AUTH_SCHEME = "Basic ";
    public static final String OSEE_HEALTH_STATUS_LINKS = "OseeHealthLinks";

    protected OseeProperties() {
    }

    protected static String getProperty(String name) {
        return OseeProperties.getProperty(name, "");
    }

    protected static String getProperty(String name, String defaultValue) {
        return System.getProperty(name, defaultValue);
    }

    public static boolean isInDbInit() {
        return Boolean.valueOf(OseeProperties.getProperty(OSEE_IS_IN_DB_INIT));
    }

    public static void setInDbInit(boolean value) {
        System.setProperty(OSEE_IS_IN_DB_INIT, Boolean.toString(value));
    }

    public static String getOseeDefaultBrokerUri() {
        return System.getProperty(OSEE_DEFAULT_BROKER_URI);
    }

    public static int getOseeDbEmbeddedWebServerPort() {
        int port = -1;
        String portStr = System.getProperty(OSEE_EMBEDDED_DB_WEB_SERVER_PORT, "");
        if (Strings.isValid(portStr)) {
            port = Integer.parseInt(portStr);
        }
        return port;
    }

    public static Pair<String, Integer> getOseeDbEmbeddedServerAddress() {
        Pair<String, Integer> addressAndPort = null;
        String serverAddress = System.getProperty(OSEE_EMBEDDED_DB_SERVER, "");
        if (Strings.isValid(serverAddress)) {
            String[] hostPort = serverAddress.split(":");
            addressAndPort = new Pair<String, Integer>(hostPort[0], Integer.parseInt(hostPort[1]));
        }
        return addressAndPort;
    }

    public static int getOseePortScannerStartPort() {
        int toReturn = 18000;
        String startPort = System.getProperty(OSEE_PORT_SCAN_START_PORT, "18000");
        try {
            toReturn = Integer.parseInt(startPort);
        }
        catch (Exception exception) {
            toReturn = 18000;
        }
        return toReturn;
    }

    public static Level getOseeLogDefault() {
        Level toReturn = Level.WARNING;
        String level = System.getProperty(OSEE_LOG_DEFAULT, "WARNING");
        try {
            toReturn = Level.parse(level);
        }
        catch (Exception exception) {
            toReturn = Level.WARNING;
        }
        return toReturn;
    }

    public static String getOseeDbConnectionId() {
        return System.getProperty(OSEE_DB_CONNECTION_ID);
    }

    public static String getOseeConnectionInfoUri() {
        return System.getProperty(OSEE_CONNECTION_INFO_URI, "");
    }

    public static int getOseeDbConnectionCount() {
        int toReturn;
        String connections = System.getProperty(OSEE_DB_CONNECTION_POOL_SIZE, "10");
        try {
            toReturn = Integer.parseInt(connections);
        }
        catch (Exception exception) {
            toReturn = 10;
        }
        return toReturn;
    }

    public static String getOseeDbConnectionPoolConfigUri() {
        return System.getProperty(OSEE_DB_CONNECTION_POOL_CONFIG_URI, "");
    }

    public static String getOseeJiniServiceGroups() {
        return System.getProperty(OSEE_JINI_SERVICE_GROUPS);
    }

    public static void setOseeJiniServiceGroups(String toStore) {
        System.setProperty(OSEE_JINI_SERVICE_GROUPS, toStore);
    }

    public static boolean isOseeJiniForcedReggieSearchEnabled() {
        return Boolean.valueOf(System.getProperty(OSEE_JINI_FORCED_REGGIE_SEARCH));
    }

    public static boolean isInTest() {
        return Boolean.valueOf(System.getProperty("osee.isInTest"));
    }

    public static void setIsInTest(boolean isInTest) {
        System.setProperty("osee.isInTest", String.valueOf(isInTest));
    }

    private void toStringHelper(List<String> list, Class<?> clazz) {
        Field[] fields;
        Field[] fieldArray = fields = clazz.getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            block13: {
                Field field = fieldArray[n2];
                int mod = field.getModifiers();
                if (Modifier.isStatic(mod) && Modifier.isFinal(mod)) {
                    boolean wasModified = false;
                    try {
                        try {
                            Object object;
                            if (!field.isAccessible()) {
                                field.setAccessible(true);
                                wasModified = true;
                            }
                            if ((object = field.get(this)) instanceof String) {
                                String value = (String)object;
                                list.add(String.format("%s: %s", value, System.getProperty(value)));
                            }
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            if (wasModified) {
                                field.setAccessible(false);
                            }
                            break block13;
                        }
                    }
                    catch (Throwable throwable) {
                        if (wasModified) {
                            field.setAccessible(false);
                        }
                        throw throwable;
                    }
                    if (wasModified) {
                        field.setAccessible(false);
                    }
                }
            }
            ++n2;
        }
        Class<?> superClazz = clazz.getSuperclass();
        if (superClazz != null) {
            this.toStringHelper(list, superClazz);
        }
    }

    public static boolean getOseeProxyBypassEnabled() {
        return Boolean.valueOf(System.getProperty(OSEE_PROXY_BYPASS_ENABLED, "false"));
    }

    public String toString() {
        ArrayList<String> list = new ArrayList<String>();
        this.toStringHelper(list, this.getClass());
        java.util.Collections.sort(list);
        return Collections.toString("\n", list);
    }

    public static boolean isOseeDb(String db) {
        return db.equals(System.getProperty(OSEE_DB));
    }

    public static boolean isOseeDbDefined() {
        return Strings.isValid(System.getProperty(OSEE_DB));
    }

    public static String getOseeDbName() {
        return System.getProperty(OSEE_DB);
    }

    public static String getJwtLoginKey() {
        return System.getProperty(JWT_LOGIN_KEY);
    }
}

