/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util;

import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public final class GUID {
    private static final Pattern pattern = Pattern.compile("[0-9A-Za-z\\+_=]{20,22}");
    private static final ThreadLocal<byte[]> threadLocalBytes = new ThreadLocal<byte[]>(){

        @Override
        protected synchronized byte[] initialValue() {
            return new byte[15];
        }
    };
    private final String guid;

    private GUID(String guid) {
        this.guid = guid;
    }

    public static GUID createGUID() {
        String theGuid = GUID.create();
        return new GUID(theGuid);
    }

    public static boolean isValid(GUID guid) {
        return GUID.isValid(guid.guid);
    }

    public static String create() {
        long time = System.nanoTime();
        long rand = (long)(Math.random() * 9.223372036854776E18);
        byte[] rawValue = GUID.chopMostSignificantByte(time, rand);
        byte[] encodedValue = Base64.encodeBase64((byte[])rawValue);
        String encodedString = new String(encodedValue);
        return encodedString.replaceAll("/", "_");
    }

    public static boolean isValid(CharSequence guid) {
        return Strings.isValid(guid) && pattern.matcher(guid).matches();
    }

    public static String checkOrCreate(String guid) {
        if (GUID.isValid(guid)) {
            return guid;
        }
        return GUID.create();
    }

    private static byte[] chopMostSignificantByte(long high, long low) {
        byte[] writeBuffer = threadLocalBytes.get();
        writeBuffer[0] = (byte)(high >>> 48);
        writeBuffer[1] = (byte)(high >>> 40);
        writeBuffer[2] = (byte)(high >>> 32);
        writeBuffer[3] = (byte)(high >>> 24);
        writeBuffer[4] = (byte)(high >>> 16);
        writeBuffer[5] = (byte)(high >>> 8);
        writeBuffer[6] = (byte)(high >>> 0);
        writeBuffer[7] = (byte)(low >>> 56);
        writeBuffer[8] = (byte)(low >>> 48);
        writeBuffer[9] = (byte)(low >>> 40);
        writeBuffer[10] = (byte)(low >>> 32);
        writeBuffer[11] = (byte)(low >>> 24);
        writeBuffer[12] = (byte)(low >>> 16);
        writeBuffer[13] = (byte)(low >>> 8);
        writeBuffer[14] = (byte)(low >>> 0);
        return writeBuffer;
    }
}

