/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.util.Message;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public final class Conditions {
    public static Predicate<Object[]> arrayContainsNull = Conditions::arrayContainsNull;
    public static Predicate<Collection<?>> collectionContainsNull = Conditions::collectionContainsNull;
    public static Predicate<Map<?, ?>> mapContainsNullKey = Conditions::mapContainsNullKey;
    public static Predicate<Map<?, ?>> mapContainsNullValue = Conditions::mapContainsNullValue;

    public static <V> void acceptWhenNonNull(@Nullable V value, @Nullable Consumer<@NonNull V> consumer) {
        if (value != null && consumer != null) {
            consumer.accept(value);
        }
    }

    public static boolean allNull(Object ... objects) {
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object != null) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean anyNull(Object ... objects) {
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object == null) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static <T, V> @Nullable T applyWhenNonNull(@Nullable V value, @Nullable Function<@NonNull V, @Nullable T> function) {
        @Nullable T result = value != null && function != null ? (T)function.apply(value) : null;
        return result;
    }

    public static <T> boolean arrayContainsNull(T[] array) {
        if (Objects.isNull(array)) {
            return true;
        }
        T[] TArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            T element = TArray[n2];
            if (Objects.isNull(element)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static <T> Predicate<T[]> arrayElementPredicate(Predicate<T> elementPredicate) {
        return t -> Conditions.testArrayMembers(t, elementPredicate);
    }

    public static void assertEquals(int value1, int value2) {
        Conditions.assertEquals(value1, value2, "");
    }

    public static void assertEquals(int value1, int value2, String message) {
        Conditions.checkExpressionFailOnTrue(value1 != value2, String.valueOf(message) + " - Expected %d; Actual %d", value1, value2);
    }

    public static void assertEquals(String expected, String actual) {
        Conditions.assertTrue(expected.equals(actual), "Expected %1; Actual %2", expected, actual);
    }

    public static void assertFalse(boolean value, String message, Object ... data) {
        Conditions.assertTrue(!value, message, data);
    }

    public static <T> String assertMessage(ValueType valueType, T value, String valueDescription, String predicateText) {
        StackWalker.StackFrame stackFrame = (StackWalker.StackFrame)StackWalker.getInstance().walk(s -> s.skip(1L).findFirst()).get();
        String className = stackFrame.getClassName();
        String methodName = stackFrame.getMethodName();
        return valueType.koPredicateMessage(null, value, className, methodName, valueDescription, predicateText).toString();
    }

    public static <T> String assertMessageNonNull(String valueDescription) {
        StackWalker.StackFrame stackFrame = (StackWalker.StackFrame)StackWalker.getInstance().walk(s -> s.skip(1L).findFirst()).get();
        String className = stackFrame.getClassName();
        String methodName = stackFrame.getMethodName();
        return ValueType.PARAMETER.koPredicateMessage(null, null, className, methodName, valueDescription, "not null").toString();
    }

    public static void assertNotEquals(int value1, int value2, String message) {
        Conditions.checkExpressionFailOnTrue(value1 == value2, String.valueOf(message) + " - Expected %d; Actual %d", value1, value2);
    }

    public static void assertNotNull(Object obj, String message, Object ... data) {
        if (obj == null) {
            throw new OseeArgumentException(message, data);
        }
    }

    public static void assertNotNullOrEmpty(Collection<? extends Object> values, String message, Object ... data) {
        if (values == null || values.isEmpty()) {
            throw new OseeArgumentException(message, data);
        }
    }

    public static void assertNotNullOrEmpty(String value, String message, Object ... data) {
        if (!Strings.isValid(value)) {
            throw new OseeArgumentException(message, data);
        }
    }

    public static void assertNotSentinel(Id id) {
        if (Id.SENTINEL.equals(id)) {
            throw new AssertionError((Object)"Id cannot be negative");
        }
    }

    public static void assertNotSentinel(Id id, String message) {
        if (Id.SENTINEL.equals(id)) {
            throw new AssertionError((Object)message);
        }
    }

    public static void assertSentinel(Id id) {
        if (Id.SENTINEL.equals(id)) {
            return;
        }
        throw new AssertionError((Object)"Object is not sentinel when it should be");
    }

    public static void assertTrue(boolean value, String message, Object ... data) {
        if (!value) {
            throw new OseeArgumentException(message, data);
        }
    }

    public static void assertValid(Long teamId, String message, Object ... data) {
        if (teamId == null || teamId <= 0L) {
            throw new OseeArgumentException(message, data);
        }
    }

    public static String buildIllegalArgumentExceptionMessage(String className, String methodName, Message message) {
        return new Message().blank().title(className).append("::").append(methodName).append(", illegal arguments provided.").indentInc().copy(message).blank().toString();
    }

    public static void checkDoesNotContainNulls(Object object, String message, Object ... data) {
        Conditions.checkNotNull(object, message);
        List<Object> toCheck = null;
        if (object instanceof Collection) {
            toCheck = (List<Object>)object;
        } else if (object instanceof Object[]) {
            toCheck = Arrays.asList((Object[])object);
        }
        if (toCheck != null) {
            for (Object e : toCheck) {
                if (e != null) continue;
                throw new OseeArgumentException(message, data);
            }
        } else {
            throw new OseeArgumentException("object is not an array or a collection", new Object[0]);
        }
    }

    public static void checkExpressionFailOnTrue(boolean result, String message, Object ... data) {
        if (result) {
            throw new OseeArgumentException(message, data);
        }
    }

    public static void checkNotNull(Object object, String objectName) {
        if (object == null) {
            throw new OseeArgumentException("%s cannot be null", objectName);
        }
    }

    public static void checkNotNull(Object object, String objectName, String details, Object ... data) {
        if (object == null) {
            String message = String.format(details, data);
            throw new OseeArgumentException("%s cannot be null - %s", objectName, message);
        }
    }

    public static void checkNotNullOrContainNull(Collection<? extends Object> collection, String objectName) {
        Conditions.checkNotNull(collection, objectName);
        for (Object object : collection) {
            Conditions.checkNotNull(object, objectName);
        }
    }

    public static void checkNotNullOrEmpty(Collection<? extends Object> collection, String objectName) {
        Conditions.checkNotNull(collection, objectName);
        if (collection.isEmpty()) {
            throw new OseeArgumentException("%s cannot be empty", objectName);
        }
    }

    public static void checkNotNullOrEmpty(Object[] array, String objectName) {
        Conditions.checkNotNull(array, objectName);
        if (array.length <= 0) {
            throw new OseeArgumentException("%s cannot be empty", objectName);
        }
    }

    public static void checkNotNullOrEmpty(String object, String objectName) {
        Conditions.checkNotNull(object, objectName);
        if (object.length() == 0) {
            throw new OseeArgumentException("%s cannot be empty", objectName);
        }
    }

    public static void checkNotNullOrEmpty(String object, String objectName, String details, Object ... data) {
        Conditions.checkNotNull(object, objectName, details, data);
        if (object.length() == 0) {
            String message = String.format(details, data);
            throw new OseeArgumentException("%s cannot be empty - %s", objectName, message);
        }
    }

    public static void checkNotNullOrEmptyOrContainNull(Collection<? extends Object> collection, String objectName) {
        Conditions.checkNotNullOrEmpty(collection, objectName);
        for (Object object : collection) {
            Conditions.checkNotNull(object, objectName);
        }
    }

    public static void checkValid(Id id, String string, Object ... data) {
        Conditions.assertTrue(id.isValid(), string, new Object[0]);
    }

    public static <T> boolean collectionContainsNull(T collection) {
        if (!(collection instanceof Collection)) {
            return true;
        }
        for (Object entry : (Collection)collection) {
            if (!Objects.isNull(entry)) continue;
            return true;
        }
        return false;
    }

    public static <T> Predicate<Collection<T>> collectionElementPredicate(Predicate<T> elementPredicate) {
        return t -> Conditions.testCollectionMembers(t, elementPredicate);
    }

    public static <T, V> @Nullable T getWhenNonNull(@Nullable Supplier<@Nullable T> supplier) {
        @Nullable T result = supplier != null ? (T)supplier.get() : null;
        return result;
    }

    public static <T> @NonNull T getNotNull(T obj, String message, Object ... data) {
        if (obj == null) {
            throw new OseeArgumentException(message, data);
        }
        return obj;
    }

    public static boolean hasValues(Collection<?> toCheck) {
        return toCheck != null && !toCheck.isEmpty();
    }

    public static boolean hasValues(Object[] toCheck) {
        return toCheck != null && toCheck.length > 0;
    }

    public static boolean in(Object equalTo, Object ... objects) {
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (equalTo.equals(object)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static <T> RuntimeException invalidCase(T value, String valueDescription, Function<String, RuntimeException> exceptionFactory) {
        StackWalker.StackFrame stackFrame = (StackWalker.StackFrame)StackWalker.getInstance().walk(s -> s.skip(1L).findFirst()).get();
        String className = stackFrame.getClassName();
        String methodName = stackFrame.getMethodName();
        String message = Conditions.startTitle(null, className, methodName).append("Unexpected switch case with parameter \"").append(valueDescription).append("\".").indentInc().segment(valueDescription, value).indentDec().toString();
        return exceptionFactory.apply(message);
    }

    public static boolean mapContainsNullKey(Map<?, ?> map) {
        return collectionContainsNull.test(map.keySet());
    }

    public static boolean mapContainsNullValue(Map<?, ?> map) {
        return collectionContainsNull.test(map.values());
    }

    public static boolean notNull(Object ... objects) {
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object == null) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @SafeVarargs
    public static <T> Predicate<T> or(final Predicate<? super T> ... predicates) {
        return new Predicate<T>(){

            @Override
            public boolean test(T t) {
                if (!$assertionsDisabled && (predicates == null || predicates.length <= 0 || Conditions.arrayContainsNull(predicates))) {
                    throw new AssertionError((Object)"Conditions::or, predicates array cannot be null, empty, or contain nulls.");
                }
                Predicate[] predicateArray = predicates;
                int n = predicates.length;
                int n2 = 0;
                while (n2 < n) {
                    Predicate predicate = predicateArray[n2];
                    if (predicate.test(t)) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
        };
    }

    public static <T> Predicate<T> predicate(Predicate<T> predicate) {
        return predicate::test;
    }

    public static <T> @Nullable Message require(@Nullable Message message, @Nullable T value, @NonNull ValueType valueType, @NonNull String valueDescription, @NonNull String predicateText, @NonNull Predicate<T> isKo) {
        if (isKo.test(value)) {
            StackWalker.StackFrame stackFrame = (StackWalker.StackFrame)StackWalker.getInstance().walk(s -> s.skip(1L).findFirst()).get();
            String className = stackFrame.getClassName();
            String methodName = stackFrame.getMethodName();
            message = valueType.koPredicateMessage(message, value, className, methodName, valueDescription, predicateText);
        }
        return message;
    }

    public static <T> @Nullable Message require(@Nullable Message message, @Nullable T value, @NonNull ValueType valueType, @NonNull String valueDescription, @NonNull String predicateTextFirst, @NonNull Predicate<T> isKoFirst, @NonNull String predicateTextSecond, @NonNull Predicate<T> isKoSecond) {
        if (isKoFirst.test(value)) {
            StackWalker.StackFrame stackFrame = (StackWalker.StackFrame)StackWalker.getInstance().walk(s -> s.skip(1L).findFirst()).get();
            String className = stackFrame.getClassName();
            String methodName = stackFrame.getMethodName();
            message = valueType.koPredicateMessage(message, value, className, methodName, valueDescription, predicateTextFirst);
            return message;
        }
        if (isKoSecond.test(value)) {
            StackWalker.StackFrame stackFrame = (StackWalker.StackFrame)StackWalker.getInstance().walk(s -> s.skip(1L).findFirst()).get();
            String className = stackFrame.getClassName();
            String methodName = stackFrame.getMethodName();
            message = valueType.koPredicateMessage(message, value, className, methodName, valueDescription, predicateTextSecond);
        }
        return message;
    }

    public static <T> @Nullable T require(@Nullable T value, @NonNull ValueType valueType, @NonNull String valueDescription, @NonNull String predicateText, @NonNull Predicate<T> isKo, @NonNull Function<String, RuntimeException> exceptionFactory) {
        if (isKo.test(value)) {
            StackWalker.StackFrame stackFrame = (StackWalker.StackFrame)StackWalker.getInstance().walk(s -> s.skip(1L).findFirst()).get();
            String className = stackFrame.getClassName();
            String methodName = stackFrame.getMethodName();
            throw exceptionFactory.apply(valueType.koPredicateMessage(null, value, className, methodName, valueDescription, predicateText).toString());
        }
        return value;
    }

    public static <T> @Nullable T require(@Nullable T value, @NonNull ValueType valueType, @NonNull String valueDescription, @NonNull String predicateTextFirst, @NonNull Predicate<T> isKoFirst, @NonNull Function<String, RuntimeException> exceptionFactoryFirst, @NonNull String predicateTextSecond, @NonNull Predicate<T> isKoSecond, @NonNull Function<String, RuntimeException> exceptionFactorySecond) {
        if (isKoFirst.test(value)) {
            StackWalker.StackFrame stackFrame = (StackWalker.StackFrame)StackWalker.getInstance().walk(s -> s.skip(1L).findFirst()).get();
            String className = stackFrame.getClassName();
            String methodName = stackFrame.getMethodName();
            throw exceptionFactoryFirst.apply(valueType.koPredicateMessage(null, value, className, methodName, valueDescription, predicateTextFirst).toString());
        }
        if (isKoSecond.test(value)) {
            StackWalker.StackFrame stackFrame = (StackWalker.StackFrame)StackWalker.getInstance().walk(s -> s.skip(1L).findFirst()).get();
            String className = stackFrame.getClassName();
            String methodName = stackFrame.getMethodName();
            throw exceptionFactorySecond.apply(valueType.koPredicateMessage(null, value, className, methodName, valueDescription, predicateTextSecond).toString());
        }
        return value;
    }

    public static <T> @Nullable T require(@Nullable T value, @NonNull ValueType valueType, @NonNull String valueDescription, @NonNull String predicateTextFirst, @NonNull Predicate<T> isKoFirst, @NonNull String predicateTextSecond, @NonNull Predicate<T> isKoSecond, @NonNull Function<String, RuntimeException> exceptionFactory) {
        if (isKoFirst.test(value)) {
            StackWalker.StackFrame stackFrame = (StackWalker.StackFrame)StackWalker.getInstance().walk(s -> s.skip(1L).findFirst()).get();
            String className = stackFrame.getClassName();
            String methodName = stackFrame.getMethodName();
            throw exceptionFactory.apply(valueType.koPredicateMessage(null, value, className, methodName, valueDescription, predicateTextFirst).toString());
        }
        if (isKoSecond.test(value)) {
            StackWalker.StackFrame stackFrame = (StackWalker.StackFrame)StackWalker.getInstance().walk(s -> s.skip(1L).findFirst()).get();
            String className = stackFrame.getClassName();
            String methodName = stackFrame.getMethodName();
            throw exceptionFactory.apply(valueType.koPredicateMessage(null, value, className, methodName, valueDescription, predicateTextSecond).toString());
        }
        return value;
    }

    public static <T> @Nullable Message requireNonNull(@Nullable Message message, @Nullable T value, @NonNull String valueDescription) {
        if (Objects.isNull(value)) {
            StackWalker.StackFrame stackFrame = (StackWalker.StackFrame)StackWalker.getInstance().walk(s -> s.skip(1L).findFirst()).get();
            String className = stackFrame.getClassName();
            String methodName = stackFrame.getMethodName();
            ValueType.PARAMETER.koPredicateMessage(message, value, className, methodName, valueDescription, "cannot be null");
        }
        return message;
    }

    public static <T> @Nullable Message requireNonNull(@Nullable Message message, @Nullable T value, @NonNull ValueType valueType, @NonNull String valueDescription) {
        if (Objects.isNull(value)) {
            StackWalker.StackFrame stackFrame = (StackWalker.StackFrame)StackWalker.getInstance().walk(s -> s.skip(1L).findFirst()).get();
            String className = stackFrame.getClassName();
            String methodName = stackFrame.getMethodName();
            valueType.koPredicateMessage(message, value, className, methodName, valueDescription, "cannot be null");
        }
        return message;
    }

    public static <T> @NonNull T requireNonNull(@Nullable T value) {
        if (value == null) {
            throw new NullPointerException();
        }
        return value;
    }

    public static <T> @NonNull T requireNonNull(@Nullable T value, @NonNull String valueDescription) {
        if (value == null) {
            StackWalker.StackFrame stackFrame = (StackWalker.StackFrame)StackWalker.getInstance().walk(s -> s.skip(1L).findFirst()).get();
            String className = stackFrame.getClassName();
            String methodName = stackFrame.getMethodName();
            throw new NullPointerException(ValueType.PARAMETER.koPredicateMessage(null, value, className, methodName, valueDescription, "cannot be null").toString());
        }
        return value;
    }

    public static <T> @NonNull T requireNonNull(@Nullable T value, @NonNull ValueType valueType, @NonNull String valueDescription) {
        if (value == null) {
            StackWalker.StackFrame stackFrame = (StackWalker.StackFrame)StackWalker.getInstance().walk(s -> s.skip(1L).findFirst()).get();
            String className = stackFrame.getClassName();
            String methodName = stackFrame.getMethodName();
            throw new NullPointerException(valueType.koPredicateMessage(null, value, className, methodName, valueDescription, "cannot be null").toString());
        }
        return value;
    }

    public static <T> @Nullable T requireMemberSet(@Nullable T value, @NonNull String valueDescription) {
        if (value == null) {
            StackWalker.StackFrame stackFrame = (StackWalker.StackFrame)StackWalker.getInstance().walk(s -> s.skip(1L).findFirst()).get();
            String className = stackFrame.getClassName();
            String methodName = stackFrame.getMethodName();
            throw new IllegalStateException(ValueType.MEMBER.koPredicateMessage(null, value, className, methodName, valueDescription, "has not been set").toString());
        }
        return value;
    }

    public static <T> void requireNull(T value, String valueDescription) {
        if (value != null) {
            StackWalker.StackFrame stackFrame = (StackWalker.StackFrame)StackWalker.getInstance().walk(s -> s.skip(1L).findFirst()).get();
            String className = stackFrame.getClassName();
            String methodName = stackFrame.getMethodName();
            throw new IllegalStateException(ValueType.MEMBER.koPredicateMessage(null, value, className, methodName, valueDescription, "cannot be set").toString());
        }
    }

    public static <T> T requireNull(T value, ValueType valueType, String valueDescription) {
        if (Objects.nonNull(value)) {
            StackWalker.StackFrame stackFrame = (StackWalker.StackFrame)StackWalker.getInstance().walk(s -> s.skip(1L).findFirst()).get();
            String className = stackFrame.getClassName();
            String methodName = stackFrame.getMethodName();
            throw new IllegalStateException(valueType.koPredicateMessage(null, value, className, methodName, valueDescription, "cannot be set").toString());
        }
        return value;
    }

    static Message startTitle(Message message, String className, String methodName) {
        Message outMessage = Objects.nonNull(message) ? message : new Message();
        outMessage.title(className).append("::").append(methodName).append(", ");
        return outMessage;
    }

    private static <T> boolean testArrayMembers(T[] array, Predicate<T> elementPredicate) {
        T[] TArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            T entry = TArray[n2];
            if (elementPredicate.test(entry)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static <T> boolean testCollectionMembers(Collection<T> collection, Predicate<T> elementPredicate) {
        for (T entry : collection) {
            if (!elementPredicate.test(entry)) continue;
            return true;
        }
        return false;
    }

    private Conditions() {
    }

    public static void checkValid(Id id) {
        if (id == null || id.isInvalid()) {
            throw new OseeArgumentException("Id [%s] is Invalid", id);
        }
    }

    public static enum ValueType {
        MEMBER{

            @Override
            <T> Message koPredicateMessage(Message message, T value, String className, String methodName, String valueDescription, String predicateText) {
                Message outMessage = Conditions.startTitle(message, className, methodName);
                outMessage.append("Member \"").append(valueDescription).append("\" failed ").append(predicateText).append(" test.").indentInc().segmentIfNotNull(valueDescription, value).indentDec();
                return outMessage;
            }
        }
        ,
        PARAMETER{

            @Override
            <T> Message koPredicateMessage(Message message, T value, String className, String methodName, String valueDescription, String predicateText) {
                Message outMessage = Conditions.startTitle(message, className, methodName);
                outMessage.append("Parameter \"").append(valueDescription).append("\" failed ").append(predicateText).append(" test.").indentInc().segmentIfNotNull(valueDescription, value).indentDec();
                return outMessage;
            }
        }
        ,
        RESULT{

            @Override
            <T> Message koPredicateMessage(Message message, T value, String className, String methodName, String valueDescription, String predicateText) {
                Message outMessage = Conditions.startTitle(message, className, methodName);
                outMessage.append("The result of \"").append(valueDescription).append("\" failed ").append(predicateText).append(" test.").indentInc().segmentIfNotNull(valueDescription, value).indentDec();
                return outMessage;
            }
        };


        abstract <T> Message koPredicateMessage(Message var1, T var2, String var3, String var4, String var5, String var6);
    }
}

