/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.type;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.osee.framework.jdk.core.type.ItemDoesNotExist;
import org.eclipse.osee.framework.jdk.core.type.MultipleItemsExist;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;

public class ResultSetList<T>
implements ResultSet<T> {
    private final List<T> data;

    public ResultSetList(List<T> data) {
        this.data = data;
    }

    @Override
    public T getOneOrDefault(T defaultVal) {
        return this.data.isEmpty() ? defaultVal : this.data.iterator().next();
    }

    @Override
    public T getAtMostOneOrDefault(T defaultVal) {
        if (this.data.size() > 1) {
            throw this.createManyExistException(this.data.size());
        }
        return this.getOneOrDefault(defaultVal);
    }

    @Override
    public T getOneOrNull() {
        return this.data.isEmpty() ? null : (T)this.data.iterator().next();
    }

    @Override
    public T getAtMostOneOrNull() {
        if (this.data.size() > 1) {
            throw this.createManyExistException(this.data.size());
        }
        return this.getOneOrNull();
    }

    @Override
    public T getExactlyOne() {
        T result = this.getAtMostOneOrNull();
        if (result == null) {
            throw this.createDoesNotExistException();
        }
        return result;
    }

    @Override
    public List<T> getList() {
        return this.data;
    }

    @Override
    public Iterator<T> iterator() {
        return this.data.iterator();
    }

    protected OseeCoreException createManyExistException(int count) {
        return new MultipleItemsExist("Multiple items found - total [%s]", count);
    }

    protected OseeCoreException createDoesNotExistException() {
        return new ItemDoesNotExist("No item found", new Object[0]);
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public ResultSet<T> sort(Comparator<T> comparator) {
        Collections.sort(this.data, comparator);
        return this;
    }
}

