/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.type;

import java.util.Objects;
import java.util.function.Consumer;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.jdk.core.type.Triplet;
import org.eclipse.osee.framework.jdk.core.util.Conditions;

public class Quad<F, S, T, Q>
extends Triplet<F, S, T> {
    private static final long serialVersionUID = -3319956950656820062L;
    private @Nullable Q fourth;

    public static <F, S, T, Q> @NonNull Quad<F, S, T, Q> createNonNull(@NonNull F first, @NonNull S second, @NonNull T third, @NonNull Q fourth) {
        return new Quad<F, S, T, Q>(Objects.requireNonNull(first), Objects.requireNonNull(second), Objects.requireNonNull(third), Objects.requireNonNull(fourth));
    }

    public static <F, S, T, Q> @NonNull Quad<F, S, T, Q> createNonNullImmutable(@NonNull F first, @NonNull S second, @NonNull T third, @NonNull Q fourth) {
        return Quad.createNullable(Objects.requireNonNull(first), Objects.requireNonNull(second), Objects.requireNonNull(third), Objects.requireNonNull(fourth));
    }

    public static <F, S, T, Q> @NonNull Quad<F, S, T, Q> createNullable(@Nullable F first, @Nullable S second, @Nullable T third, @Nullable Q fourth) {
        return new Quad<F, S, T, Q>(first, second, third, fourth);
    }

    public static <F, S, T, Q> @NonNull Quad<F, S, T, Q> createNullableImmutable(@Nullable F first, @Nullable S second, @Nullable T third, @Nullable Q fourth) {
        return new Quad<F, S, T, Q>((Object)first, (Object)second, (Object)third, (Object)fourth){
            private static final long serialVersionUID = 1L;

            @Override
            public Pair<F, S> set(F first, S second) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Triplet<F, S, T> set(F first, S second, T third) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Quad<F, S, T, Q> set(F first, S second, T third, Q fourth) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void setFirst(F first) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void setFourth(Q fourth) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void setSecond(S second) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void setThird(T third) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Quad() {
        this.fourth = null;
    }

    public Quad(@Nullable F first, @Nullable S second, @Nullable T third, @Nullable Q fourth) {
        super(first, second, third);
        this.fourth = fourth;
    }

    @Override
    public boolean equals(Object obj) {
        boolean superEqual = super.equals(obj);
        if (!superEqual) {
            return false;
        }
        if (!(obj instanceof Quad)) {
            return false;
        }
        Quad other = (Quad)obj;
        boolean fourthEqual = this.fourth != null ? this.fourth.equals(other.fourth) : other.fourth == null;
        return fourthEqual;
    }

    public @Nullable F getFirstIfPresentOthers(@Nullable Consumer<@NonNull S> secondAction, @Nullable Consumer<@NonNull T> thirdAction, @Nullable Consumer<@NonNull Q> fourthAction) {
        Conditions.acceptWhenNonNull(this.second, secondAction);
        Conditions.acceptWhenNonNull(this.third, thirdAction);
        Conditions.acceptWhenNonNull(this.fourth, fourthAction);
        return (F)this.first;
    }

    public @NonNull F getFirstNonNullIfPresentOthers(@Nullable Consumer<@NonNull S> secondAction, @Nullable Consumer<@NonNull T> thirdAction, @Nullable Consumer<@NonNull Q> fourthAction) {
        Conditions.acceptWhenNonNull(this.second, secondAction);
        Conditions.acceptWhenNonNull(this.third, thirdAction);
        Conditions.acceptWhenNonNull(this.fourth, fourthAction);
        return (F)Conditions.requireNonNull(this.first);
    }

    public @Nullable Q getFourth() {
        return this.fourth;
    }

    public @NonNull Q getFourthNonNull() {
        return Conditions.requireNonNull(this.fourth);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.first, this.second, this.third, this.fourth);
    }

    public void ifPresent(@Nullable Consumer<@NonNull F> firstAction, @Nullable Consumer<@NonNull S> secondAction, @Nullable Consumer<@NonNull T> thirdAction, @Nullable Consumer<@NonNull Q> fourthAction) {
        Conditions.acceptWhenNonNull(this.first, firstAction);
        Conditions.acceptWhenNonNull(this.second, secondAction);
        Conditions.acceptWhenNonNull(this.third, thirdAction);
        Conditions.acceptWhenNonNull(this.fourth, fourthAction);
    }

    public @NonNull Quad<F, S, T, Q> set(@Nullable F first, @Nullable S second, @Nullable T third, @Nullable Q fourth) {
        super.set(first, second, third);
        this.setFourth(fourth);
        return this;
    }

    public void setFourth(@Nullable Q fourth) {
        this.fourth = fourth;
    }

    @Override
    public String toString() {
        String firstAsString = String.valueOf(this.first);
        String secondAsString = String.valueOf(this.second);
        String thirdAsString = String.valueOf(this.third);
        String fourthAsString = String.valueOf(this.fourth);
        String result = String.format("[%s, %s, %s, %s]", firstAsString, secondAsString, thirdAsString, fourthAsString);
        return Conditions.requireNonNull(result);
    }

    public boolean typesKo(@NonNull Class<?> firstClass, @NonNull Class<?> secondClass, @NonNull Class<?> thirdClass, @NonNull Class<?> fourthClass) {
        return !this.typesOk(firstClass, secondClass, thirdClass, fourthClass);
    }

    public boolean typesOk(@NonNull Class<?> firstClass, @NonNull Class<?> secondClass, @NonNull Class<?> thirdClass, @NonNull Class<?> fourthClass) {
        Class classOfFourth = Conditions.applyWhenNonNull(this.fourth, q -> q.getClass());
        return this.typesOk(firstClass, secondClass, thirdClass) && (classOfFourth != null || secondClass.isAssignableFrom(classOfFourth));
    }
}

