/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.text.tool;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.framework.jdk.core.util.Lib;

public class FindNonLocalFunctionCalls {
    public static final Pattern functionCallPattern = Pattern.compile("\\W(\\w+)\\s*\\([^;{]*?\\)\\s*;");
    public static final Pattern functionDefPattern = Pattern.compile("\\W(\\w+)\\s*\\([^;{]*?\\)\\s*\\{");
    private final LinkedHashSet<String> set;
    private final File[] files;

    public FindNonLocalFunctionCalls(File[] files) {
        this.files = files;
        this.set = new LinkedHashSet();
    }

    public static void main(String[] args) {
        File[] files = new File[args.length];
        int i = 0;
        while (i < args.length) {
            files[i] = new File(args[i]);
            ++i;
        }
        FindNonLocalFunctionCalls app = new FindNonLocalFunctionCalls(files);
        app.searchFiles();
        app.print();
    }

    public void searchFiles() {
        int i = 0;
        while (i < this.files.length) {
            try {
                this.look(Lib.stripBlockComments(Lib.fileToCharBuffer(this.files[i])));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            ++i;
        }
    }

    private void look(CharSequence seq) {
        ArrayList<String> localFunctions = new ArrayList<String>();
        Matcher functionDefM = functionDefPattern.matcher(seq);
        while (functionDefM.find()) {
            localFunctions.add(functionDefM.group(1));
        }
        Matcher functionCallM = functionCallPattern.matcher(seq);
        while (functionCallM.find()) {
            if (localFunctions.contains(functionCallM.group(1))) continue;
            this.set.add(functionCallM.group(1));
        }
    }

    public Set<String> getResultSet() {
        return this.set;
    }

    public void print() {
        ArrayList<String> list = new ArrayList<String>(this.set);
        Collections.sort(list);
        Iterator<String> iter = list.iterator();
        while (iter.hasNext()) {
            System.out.println(iter.next());
        }
    }
}

