/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.text.rules;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.framework.jdk.core.text.Rule;
import org.eclipse.osee.framework.jdk.core.text.change.ChangeSet;

public final class DoorsToOseeRule
extends Rule {
    private final Pattern bodyRegex = Pattern.compile("<w:body>(.*?)</w:body>", 32);
    private final Pattern paragraphRegex = Pattern.compile("<w:p[ >].*?</w:p>", 32);
    private final Pattern objectNumberParagraphRegex = Pattern.compile("<w:t>.*?((?>\\d+\\.)+\\d+-\\d+(?>\\.\\d+-\\d+)*).*</w:t>", 40);
    private final Pattern regularObjectNumberParagraphRegex = Pattern.compile("<w:t>.*?Object Number\\s*.*:\\s+(.*?)</w:t>", 40);
    private final Pattern objectShortTextParagraphRegex = Pattern.compile("<w:p[ >].*?Object Short Text.*?<w:t>\\s+:\\s+(.*?)</w:t>.*?</w:p>", 32);
    private final Pattern headingParagraphRegex = Pattern.compile("<w:p[ >].*?<w:pStyle w:val=\"Heading\\d\"/>.*?<w:t>(\\d+\\s+.*?)</w:t>.*?</w:p>", 32);
    private StringBuilder modifiedText;

    public DoorsToOseeRule() {
        super("_converted.xml");
    }

    @Override
    public ChangeSet computeChanges(CharSequence entireFile) {
        this.modifiedText = new StringBuilder(entireFile.length() * 2);
        Matcher bodySectionMatcher = this.bodyRegex.matcher(entireFile);
        if (bodySectionMatcher.find()) {
            this.write(entireFile.subSequence(0, bodySectionMatcher.start()));
            this.write("\n<w:body>");
            this.processText(bodySectionMatcher.group(1));
            this.write("\n</w:body>");
            this.write("\n</w:wordDocument>");
        }
        return this.decideOnResult(this.modifiedText, entireFile);
    }

    private void processText(CharSequence text) {
        Matcher paragraphMatcher = this.paragraphRegex.matcher(text);
        DoorsItemEnum currentDoorsItem = DoorsItemEnum.OBJECT_NUMBER;
        boolean startedSectionProcessing = true;
        int startIndexOfLastParagraph = -1;
        int endIndexOfLastParagraph = -1;
        while (paragraphMatcher.find()) {
            if (startedSectionProcessing) {
                startedSectionProcessing = false;
                this.write(text.subSequence(0, paragraphMatcher.start()));
            } else if (startIndexOfLastParagraph != -1 && endIndexOfLastParagraph != -1) {
                this.write(text.subSequence(endIndexOfLastParagraph, paragraphMatcher.start()));
            }
            DoorsItemEnum prevDoorsItem = currentDoorsItem;
            currentDoorsItem = this.processParagraph(paragraphMatcher.group(), currentDoorsItem);
            startIndexOfLastParagraph = paragraphMatcher.start();
            endIndexOfLastParagraph = paragraphMatcher.end();
            if (prevDoorsItem != currentDoorsItem) continue;
            this.write("\n" + paragraphMatcher.group());
        }
        this.write(text.subSequence(endIndexOfLastParagraph, text.length()));
    }

    private DoorsItemEnum processParagraph(String paragraph, DoorsItemEnum nextDoorsItem) {
        switch (nextDoorsItem) {
            case OBJECT_NUMBER: {
                Matcher objectNumberMatcher = this.objectNumberParagraphRegex.matcher(paragraph);
                if (objectNumberMatcher.find()) {
                    String updatedObjectNumber = objectNumberMatcher.group(1).replace("-", ".");
                    System.out.print("\t" + objectNumberMatcher.group(1) + " --> " + updatedObjectNumber);
                    this.write("\n\t<w:p wsp:rsidR=\"007916EC\" wsp:rsidRDefault=\"007916EC\" wsp:rsidP=\"007916EC\">");
                    this.write("<w:pPr>");
                    this.write("<w:spacing w:before=\"48\" w:line=\"273\" w:line-rule=\"at-least\"/>");
                    this.write("</w:pPr>");
                    this.write("\n\t<w:r>");
                    this.write("<w:rPr>");
                    this.write("<w:b/>");
                    this.write("<w:b-cs/>");
                    this.write("</w:rPr>");
                    this.write(String.format("\n<w:t>%s  </w:t>", updatedObjectNumber));
                    this.write("\n\t</w:r>");
                    nextDoorsItem = DoorsItemEnum.OBJECT_SHORT_TEXT_DASHED;
                    break;
                }
                Matcher regularParagraphMatcher = this.regularObjectNumberParagraphRegex.matcher(paragraph);
                if (!regularParagraphMatcher.find()) break;
                nextDoorsItem = DoorsItemEnum.OBJECT_SHORT_TEXT_NON_DASHED;
                System.out.print("- \t\t" + regularParagraphMatcher.group(1));
                break;
            }
            case OBJECT_SHORT_TEXT_DASHED: {
                Matcher objectShortTextMatcher = this.objectShortTextParagraphRegex.matcher(paragraph);
                if (!objectShortTextMatcher.find()) break;
                System.out.print(" " + objectShortTextMatcher.group(1) + "\n");
                this.write("\n\t<w:r>");
                this.write("\n\t<w:rPr>");
                this.write("\n\t<w:b/>");
                this.write("\n\t<w:b-cs/>");
                this.write("\n\t<w:u w:val=\"single\"/>");
                this.write("\n\t</w:rPr>");
                this.write(String.format("\n\t<w:t>%s</w:t>", objectShortTextMatcher.group(1)));
                this.write("\n\t</w:r>");
                this.write("\n\t</w:p>");
                nextDoorsItem = DoorsItemEnum.OBJECT_BODY;
                break;
            }
            case OBJECT_SHORT_TEXT_NON_DASHED: {
                Matcher objectShortTextMatcher = this.objectShortTextParagraphRegex.matcher(paragraph);
                if (!objectShortTextMatcher.find()) break;
                System.out.print(" " + objectShortTextMatcher.group(1) + "\n");
                nextDoorsItem = DoorsItemEnum.OBJECT_BODY;
                break;
            }
            case OBJECT_BODY: {
                Matcher headingParagraphMatcher = this.headingParagraphRegex.matcher(paragraph);
                if (headingParagraphMatcher.find()) {
                    System.out.print("\t" + headingParagraphMatcher.group(1));
                    this.write(paragraph.subSequence(0, headingParagraphMatcher.start(1)));
                    String wt = headingParagraphMatcher.group(1);
                    StringBuilder resultingWt = new StringBuilder(wt.length() * 2 / 3);
                    int indexOfFirstSpace = wt.indexOf(" ");
                    resultingWt.append(wt.subSequence(0, indexOfFirstSpace));
                    resultingWt.append(".0");
                    resultingWt.append(wt.subSequence(indexOfFirstSpace, wt.length()));
                    System.out.print(" --> " + resultingWt + "\n");
                    this.write(resultingWt);
                    this.write(paragraph.subSequence(headingParagraphMatcher.end(1), paragraph.length()));
                } else {
                    this.write(paragraph);
                }
                nextDoorsItem = DoorsItemEnum.OBJECT_NUMBER;
                break;
            }
        }
        return nextDoorsItem;
    }

    private void write(CharSequence subSequence) {
        this.modifiedText.append(subSequence);
    }

    private ChangeSet decideOnResult(StringBuilder modifiedFile, CharSequence entireFile) {
        boolean insertModified = this.modifiedText.length() > 0;
        this.setRuleWasApplicable(insertModified);
        return new ChangeSet(insertModified ? this.modifiedText : entireFile);
    }

    private static enum DoorsItemEnum {
        OBJECT_NUMBER,
        OBJECT_SHORT_TEXT_DASHED,
        OBJECT_SHORT_TEXT_NON_DASHED,
        OBJECT_BODY,
        NONE;

    }
}

