/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.relation.order;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.orcs.core.internal.relation.order.OrderData;

public class OrderEntryComparator
implements Comparator<Map.Entry<RelationTypeSide, OrderData>> {
    @Override
    public int compare(Map.Entry<RelationTypeSide, OrderData> o1, Map.Entry<RelationTypeSide, OrderData> o2) {
        RelationTypeSide typeSide1 = o1.getKey();
        RelationTypeSide typeSide2 = o2.getKey();
        OrderData orderData1 = o1.getValue();
        OrderData orderData2 = o2.getValue();
        int result = typeSide1.getGuid().compareTo(typeSide2.getGuid());
        if (result == 0) {
            result = typeSide1.getSide().compareTo((Enum)typeSide2.getSide());
        }
        if (result == 0) {
            result = orderData1.getSorterId().compareTo((Enum)orderData2.getSorterId());
        }
        if (result == 0) {
            ArrayList<String> guids1 = new ArrayList<String>(orderData1.getOrderIds());
            ArrayList<String> guids2 = new ArrayList<String>(orderData2.getOrderIds());
            result = guids1.size() - guids2.size();
            if (result == 0) {
                Collections.sort(guids1);
                Collections.sort(guids2);
                int index = 0;
                while (index < guids1.size()) {
                    result = ((String)guids1.get(index)).compareTo((String)guids2.get(index));
                    if (result != 0) break;
                    ++index;
                }
            }
        }
        return result;
    }
}

