/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.account.admin.internal.oauth;

import java.util.List;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.jaxrs.server.database.AbstractDatabaseStorage;
import org.eclipse.osee.jaxrs.server.security.OAuthCodeGrant;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcStatement;
import org.eclipse.osee.logger.Log;

public class AuthCodeGrantStorage
extends AbstractDatabaseStorage<OAuthCodeGrant> {
    private static final String SCOPES_SEPARATOR = ";";
    private static final String SELECT_AUTH_CODE_BY_CODE = "SELECT * FROM osee_oauth_authorization WHERE code = ?";
    private static final String INSERT_AUTH_CODE = "INSERT INTO osee_oauth_authorization (id, client_id, subject_id, issued_at, expires_in, code, redirect_uri, verifier, audience, approved_scopes) VALUES (?,?,?,?,?,?,?,?,?,?)";
    private static final String DELETE_AUTH_CODE_BY_ID = "DELETE FROM osee_oauth_authorization WHERE id = ?";

    public AuthCodeGrantStorage(Log logger, JdbcClient jdbcClient) {
        super(logger, jdbcClient);
    }

    protected Object[] asInsert(OAuthCodeGrant data) {
        return new Object[]{data.getUuid(), data.getClientId(), data.getSubjectId(), data.getIssuedAt(), data.getExpiresIn(), data.getCode(), this.asVarcharOrNull(data.getRedirectUri()), this.asVarcharOrNull(data.getClientCodeVerifier()), this.asVarcharOrNull(data.getAudience()), this.asScopesStore(data.getApprovedScopes())};
    }

    protected Object[] asUpdate(OAuthCodeGrant data) {
        return new Object[]{data.getUuid()};
    }

    protected Object[] asDelete(OAuthCodeGrant data) {
        return new Object[]{data.getUuid()};
    }

    public OAuthCodeGrant getByCode(String code) {
        return (OAuthCodeGrant)this.selectOneOrNull(SELECT_AUTH_CODE_BY_CODE, new Object[]{code});
    }

    public void insert(OAuthCodeGrant data) {
        this.insertItems(INSERT_AUTH_CODE, new OAuthCodeGrant[]{data});
    }

    public void delete(OAuthCodeGrant data) {
        this.deleteItems(DELETE_AUTH_CODE_BY_ID, new OAuthCodeGrant[]{data});
    }

    public void delete(Iterable<OAuthCodeGrant> datas) {
        this.deleteItems(DELETE_AUTH_CODE_BY_ID, datas);
    }

    private Object asScopesStore(List<String> scopes) {
        String scopeData = null;
        if (scopes != null && !scopes.isEmpty()) {
            scopeData = Collections.toString((String)SCOPES_SEPARATOR, scopes);
        }
        return this.asVarcharOrNull(scopeData);
    }

    protected OAuthCodeGrant readData(JdbcStatement chStmt) {
        final long uuid = chStmt.getLong("id");
        final long clientId = chStmt.getLong("client_id");
        final long subjectId = chStmt.getLong("subject_id");
        final long issuedAt = chStmt.getLong("issued_at");
        final long expiresIn = chStmt.getLong("expires_in");
        final String code = chStmt.getString("code");
        final String redirect_uri = chStmt.getString("redirect_uri");
        final String verifier = chStmt.getString("verifier");
        final String audience = chStmt.getString("audience");
        final List approvedScopes = Collections.fromString((String)chStmt.getString("approved_scopes"), (String)SCOPES_SEPARATOR);
        return new OAuthCodeGrant(){

            public long getUuid() {
                return uuid;
            }

            public long getSubjectId() {
                return subjectId;
            }

            public long getClientId() {
                return clientId;
            }

            public long getIssuedAt() {
                return issuedAt;
            }

            public long getExpiresIn() {
                return expiresIn;
            }

            public String getCode() {
                return code;
            }

            public String getRedirectUri() {
                return redirect_uri;
            }

            public String getClientCodeVerifier() {
                return verifier;
            }

            public String getAudience() {
                return audience;
            }

            public List<String> getApprovedScopes() {
                return approvedScopes;
            }
        };
    }
}

