/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.transaction;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.osee.activity.api.ActivityLog;
import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.model.change.ChangeItem;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.core.ds.DataLoaderFactory;
import org.eclipse.osee.orcs.core.ds.QueryEngineIndexer;
import org.eclipse.osee.orcs.core.ds.TransactionData;
import org.eclipse.osee.orcs.core.ds.TransactionResult;
import org.eclipse.osee.orcs.core.ds.TxDataStore;
import org.eclipse.osee.orcs.db.internal.IdentityManager;
import org.eclipse.osee.orcs.db.internal.callable.LoadArtifactHistory;
import org.eclipse.osee.orcs.db.internal.callable.PurgeTransactionTxCallable;
import org.eclipse.osee.orcs.db.internal.callable.SetTransactionTxCallable;
import org.eclipse.osee.orcs.db.internal.health.PurgeUnusedBackingDataAndTransactions;
import org.eclipse.osee.orcs.db.internal.sql.join.SqlJoinFactory;
import org.eclipse.osee.orcs.db.internal.transaction.CommitTransactionDatabaseTxCallable;
import org.eclipse.osee.orcs.db.internal.transaction.ComodificationCheck;
import org.eclipse.osee.orcs.db.internal.transaction.TransactionIndexer;
import org.eclipse.osee.orcs.db.internal.transaction.TransactionProcessorProviderImpl;
import org.eclipse.osee.orcs.db.internal.transaction.TransactionWriter;
import org.eclipse.osee.orcs.db.internal.transaction.TxSqlBuilderImpl;
import org.eclipse.osee.orcs.db.internal.transaction.TxWritePhaseEnum;
import org.eclipse.osee.orcs.search.QueryFactory;

public class TxModule {
    private final Log logger;
    private final JdbcClient jdbcClient;
    private final SqlJoinFactory sqlJoinFactory;
    private final IdentityManager idManager;
    private final ActivityLog activityLog;
    private static final String UPDATE_TRANSACTION_COMMIT_ART_ID = "UPDATE osee_tx_details SET commit_art_id = ? WHERE transaction_id = ?";

    public TxModule(Log logger, JdbcClient jdbcClient, SqlJoinFactory sqlJoinFactory, IdentityManager identityService, ActivityLog activityLog) {
        this.logger = logger;
        this.jdbcClient = jdbcClient;
        this.sqlJoinFactory = sqlJoinFactory;
        this.idManager = identityService;
        this.activityLog = activityLog;
    }

    public TxDataStore createTransactionStore(DataLoaderFactory dataLoaderFactory, QueryEngineIndexer indexer, final OrcsTokenService tokenService) {
        final TransactionProcessorProviderImpl processors = new TransactionProcessorProviderImpl();
        processors.add(TxWritePhaseEnum.BEFORE_TX_WRITE, new ComodificationCheck(dataLoaderFactory));
        processors.add(TxWritePhaseEnum.AFTER_TX_WRITE, new TransactionIndexer(this.logger, indexer, tokenService));
        return new TxDataStore(){

            public Callable<TransactionResult> commitTransaction(OrcsSession session, TransactionData data) {
                TxSqlBuilderImpl builder = new TxSqlBuilderImpl(TxModule.this.sqlJoinFactory, TxModule.this.idManager, TxModule.this.jdbcClient);
                TransactionWriter writer = new TransactionWriter(TxModule.this.logger, TxModule.this.jdbcClient, builder);
                return new CommitTransactionDatabaseTxCallable(TxModule.this.logger, session, TxModule.this.jdbcClient, TxModule.this.idManager, processors, writer, data);
            }

            public Callable<Integer> purgeTransactions(OrcsSession session, Collection<? extends TransactionId> transactionsToPurge) {
                return new PurgeTransactionTxCallable(TxModule.this.activityLog, session, TxModule.this.jdbcClient, TxModule.this.sqlJoinFactory, transactionsToPurge);
            }

            public Callable<Void> setTransactionComment(OrcsSession session, TransactionId transaction, String comment) {
                return new SetTransactionTxCallable(TxModule.this.logger, session, TxModule.this.jdbcClient, transaction, comment);
            }

            public int[] purgeUnusedBackingDataAndTransactions(int rowCount) {
                PurgeUnusedBackingDataAndTransactions op = new PurgeUnusedBackingDataAndTransactions(TxModule.this.jdbcClient);
                return op.purgeUnused(rowCount);
            }

            public int[] purgeUnusedBackingDataAndTransactions(List<Long> gammasToPurge, List<String> additionalStatements, String prefixRecoveryFile) {
                PurgeUnusedBackingDataAndTransactions op = new PurgeUnusedBackingDataAndTransactions(TxModule.this.jdbcClient);
                return op.purgeListOfGammas(gammasToPurge, additionalStatements, prefixRecoveryFile);
            }

            public void setTransactionCommitArtifact(OrcsSession session, TransactionId transaction, ArtifactId commitArt) {
                Conditions.checkNotNull((Object)transaction, (String)"transaction");
                Conditions.checkNotNull((Object)commitArt, (String)"commitArt");
                TxModule.this.jdbcClient.runPreparedUpdate(TxModule.UPDATE_TRANSACTION_COMMIT_ART_ID, new Object[]{commitArt, transaction});
            }

            public Callable<List<ChangeItem>> getArtifactHistory(OrcsSession session, QueryFactory queryFactory, ArtifactId artifact, BranchId branch) {
                return new LoadArtifactHistory(TxModule.this.logger, session, queryFactory, tokenService, TxModule.this.jdbcClient, artifact, branch);
            }
        };
    }
}

