/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.indexer.data;

import java.util.HashSet;
import java.util.function.Consumer;
import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.core.data.AttributeId;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.resource.management.IResourceManager;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcStatement;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.core.ds.IndexedResource;
import org.eclipse.osee.orcs.core.ds.OrcsDataHandler;
import org.eclipse.osee.orcs.db.internal.search.indexer.IndexedResourceLoader;
import org.eclipse.osee.orcs.db.internal.search.indexer.data.IndexerDataSourceImpl;
import org.eclipse.osee.orcs.db.internal.util.AttributeDataUtil;

public class GammaQueueIndexerDataSourceLoader
implements IndexedResourceLoader {
    private static final String LOAD_ATTRIBUTE = "SELECT attr1.gamma_id, attr1.VALUE, attr1.uri, attr1.attr_type_id, attr1.attr_id FROM osee_attribute attr1, osee_tag_gamma_queue tgq1 WHERE attr1.gamma_id = tgq1.gamma_id AND tgq1.query_id = ?";
    private final Log logger;
    private final JdbcClient jdbcClient;
    private final IResourceManager resourceManager;

    public GammaQueueIndexerDataSourceLoader(Log logger, JdbcClient jdbcClient, IResourceManager resourceManager) {
        this.logger = logger;
        this.jdbcClient = jdbcClient;
        this.resourceManager = resourceManager;
    }

    private int loadData(OrcsDataHandler<IndexedResource> handler, Long tagQueueQueryId, OrcsTokenService tokenService) {
        HashSet attrData = new HashSet();
        Consumer<JdbcStatement> consumer = stmt -> {
            AttributeId itemId = AttributeId.valueOf((Long)stmt.getLong("attr_id"));
            AttributeTypeGeneric attributeType = tokenService.getAttributeTypeOrCreate(Long.valueOf(stmt.getLong("attr_type_id")));
            GammaId gammaId = GammaId.valueOf((Long)stmt.getLong("gamma_id"));
            String uri = stmt.getString("uri");
            String value = stmt.getString("value");
            attrData.add(new AttributeData(itemId, (AttributeTypeToken)attributeType, gammaId, uri, value));
        };
        int loaded = this.jdbcClient.runQuery(consumer, LOAD_ATTRIBUTE, new Object[]{tagQueueQueryId});
        for (AttributeData attributeData : attrData) {
            StringBuffer sb = new StringBuffer();
            sb = sb.append(attributeData.getValue());
            sb = sb.append(AttributeDataUtil.getNameByGuid(attributeData.getValue(), this.jdbcClient));
            IndexerDataSourceImpl data = new IndexerDataSourceImpl(this.resourceManager, attributeData.getItemId(), attributeData.getAttributeType(), attributeData.getGammaId(), sb.toString(), attributeData.getUri());
            handler.onData((Object)data);
        }
        return loaded;
    }

    @Override
    public void loadSource(OrcsDataHandler<IndexedResource> handler, Long tagQueueQueryId, OrcsTokenService tokenService) {
        int count = this.loadData(handler, tagQueueQueryId, tokenService);
        int retry = 0;
        while (count == 0 && retry < 10) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {}
            this.logger.debug("Retrying attribute load from gammas - queryId[%s] attempt[%s of %s]", new Object[]{tagQueueQueryId, retry, 10});
            this.loadData(handler, tagQueueQueryId, tokenService);
            ++retry;
        }
    }

    private class AttributeData {
        private final AttributeId itemId;
        private final AttributeTypeToken attributeType;
        private final GammaId gammaId;
        private final String uri;
        private final String value;

        public AttributeData(AttributeId itemId, AttributeTypeToken attributeType, GammaId gammaId, String uri, String value) {
            this.itemId = itemId;
            this.attributeType = attributeType;
            this.gammaId = gammaId;
            this.uri = uri;
            this.value = value;
        }

        public AttributeId getItemId() {
            return this.itemId;
        }

        public AttributeTypeToken getAttributeType() {
            return this.attributeType;
        }

        public GammaId getGammaId() {
            return this.gammaId;
        }

        public String getUri() {
            return this.uri;
        }

        public String getValue() {
            return this.value;
        }
    }
}

