/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.handlers;

import java.util.List;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.orcs.OseeDb;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaRelationTypeSideNotExists;
import org.eclipse.osee.orcs.db.internal.search.handlers.AbstractRelationSqlHandler;
import org.eclipse.osee.orcs.db.internal.sql.AbstractSqlWriter;

public class RelationTypeSideNotExistsSqlHandler
extends AbstractRelationSqlHandler<CriteriaRelationTypeSideNotExists> {
    @Override
    public void addPredicates(AbstractSqlWriter writer) {
        super.addPredicates(writer);
        RelationTypeSide relationType = (RelationTypeSide)((CriteriaRelationTypeSideNotExists)this.criteria).getType();
        writer.write("NOT EXISTS (SELECT 1 FROM ");
        String relAlias = writer.writeTable(((CriteriaRelationTypeSideNotExists)this.criteria).getType());
        writer.write(", ");
        String txsAlias = writer.writeTable(OseeDb.TXS_TABLE);
        writer.write(" WHERE ");
        if (((RelationTypeSide)((CriteriaRelationTypeSideNotExists)this.criteria).getType()).isNewRelationTable()) {
            writer.writeEqualsParameterAnd(relAlias, "rel_type", relationType);
        } else {
            writer.writeEqualsParameterAnd(relAlias, "rel_link_type_id", relationType);
        }
        List<String> aliases = writer.getAliases(OseeDb.ARTIFACT_TABLE);
        String side = relationType.getSide().isSideA() ? "a" : "b";
        int aSize = aliases.size();
        int index = 0;
        while (index < aSize) {
            String artAlias = aliases.get(index);
            writer.writeEquals(relAlias, String.valueOf(side) + "_art_id", artAlias, "art_id");
            if (index + 1 < aSize) {
                writer.writeAndLn();
            }
            ++index;
        }
        writer.writeAndLn();
        writer.writeEquals(relAlias, txsAlias, "gamma_id");
        writer.writeAndLn();
        writer.writeTxBranchFilter(txsAlias);
        writer.write(")");
    }
}

