/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.handlers;

import org.eclipse.osee.orcs.OseeDb;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaRelatedRecursive;
import org.eclipse.osee.orcs.db.internal.search.handlers.SqlHandlerPriority;
import org.eclipse.osee.orcs.db.internal.sql.AbstractSqlWriter;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandler;

public class RelatedRecursiveHandler
extends SqlHandler<CriteriaRelatedRecursive> {
    private CriteriaRelatedRecursive criteria;
    private String cteAlias;
    private String artAlias;

    @Override
    public void writeCommonTableExpression(AbstractSqlWriter writer) {
        this.cteAlias = this.criteria.getType().isNewRelationTable() ? writer.startRecursiveCommonTableExpression("recurse", "(id,top_rel_type, top_rel_order, child_level)") : writer.startRecursiveCommonTableExpression("recurse", "(id,child_level)");
        if (this.criteria.getType().isNewRelationTable()) {
            writer.write("SELECT b_art_id,rel_type top_rel_type,rel_order top_rel_order, 1 FROM osee_relation rel, osee_txs txs WHERE ");
            writer.writeEqualsParameterAnd("a_art_id", this.criteria.getStartArtifact());
            writer.writeEqualsParameterAnd("rel_type", this.criteria.getType());
            writer.write("rel.gamma_id = txs.gamma_id");
            writer.writeAnd();
            writer.writeTxBranchFilter("txs");
            writer.writeCteRecursiveUnion();
            writer.write(" SELECT b_art_id,rel_type top_rel_type,rel_order top_rel_order, child_level + 1 FROM " + this.cteAlias);
            writer.write(", osee_relation rel, osee_txs txs");
            writer.write(" WHERE a_art_id = id AND rel_type = ? AND rel.gamma_id = txs.gamma_id");
            writer.writeAnd();
            writer.addParameter(this.criteria.getType());
            writer.writeTxBranchFilter("txs");
        } else {
            writer.write("SELECT b_art_id, 1 FROM osee_relation_link rel, osee_txs txs WHERE ");
            writer.writeEqualsParameterAnd("a_art_id", this.criteria.getStartArtifact());
            writer.writeEqualsParameterAnd("rel_link_type_id", this.criteria.getType());
            writer.write("rel.gamma_id = txs.gamma_id");
            writer.writeAnd();
            writer.writeTxBranchFilter("txs");
            writer.writeCteRecursiveUnion();
            writer.write(" SELECT b_art_id, child_level + 1 FROM " + this.cteAlias);
            writer.write(", osee_relation_link rel, osee_txs txs");
            writer.write(" WHERE a_art_id = id AND rel_link_type_id = ? AND rel.gamma_id = txs.gamma_id");
            writer.writeAnd();
            writer.addParameter(this.criteria.getType());
            writer.writeTxBranchFilter("txs");
        }
    }

    @Override
    public void setData(CriteriaRelatedRecursive criteria) {
        this.criteria = criteria;
    }

    @Override
    public void addTables(AbstractSqlWriter writer) {
        writer.addTable(this.cteAlias);
        this.artAlias = writer.getMainTableAlias(OseeDb.ARTIFACT_TABLE);
    }

    @Override
    public void addPredicates(AbstractSqlWriter writer) {
        writer.writeEquals(this.cteAlias, "id", this.artAlias, "art_id");
    }

    @Override
    public int getPriority() {
        return SqlHandlerPriority.ARTIFACT_ID.ordinal();
    }

    @Override
    public void writeSelectFields(AbstractSqlWriter writer) {
        if (this.criteria.getType().isNewRelationTable()) {
            writer.write(", rel_type as top_rel_type, rel_order as top_rel_order");
        }
    }
}

