/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.orcs.OseeDb;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaFollowSearch;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaPagination;
import org.eclipse.osee.orcs.db.internal.search.handlers.SqlHandlerPriority;
import org.eclipse.osee.orcs.db.internal.sql.AbstractSqlWriter;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandler;

public class FollowSearchSqlHandler
extends SqlHandler<CriteriaFollowSearch> {
    CriteriaFollowSearch criteria;
    private String attrSearchAlias;
    private String mainAttAlias;

    @Override
    public void setData(CriteriaFollowSearch criteria) {
        this.criteria = criteria;
    }

    @Override
    public void writeSelectFields(AbstractSqlWriter writer) {
        String mainArtAlias = writer.getMainTableAlias(OseeDb.ARTIFACT_TABLE);
        if (writer.getAliasManager().getPreviousAlias("artWith").isBlank()) {
            writer.write(",','||" + mainArtAlias + ".art_id" + "||',' art_path");
        } else {
            writer.write("," + writer.getTableEntries().get(0) + ".art_path|| " + mainArtAlias + ".art_id||',' art_path");
        }
    }

    @Override
    public int getPriority() {
        return SqlHandlerPriority.FOLLOW_SEARCH.ordinal();
    }

    public String writeFollowSearchCommonTableExpression(AbstractSqlWriter writer, String attAlias, boolean newRelation, CriteriaPagination pagination) {
        this.attrSearchAlias = writer.startCommonTableExpression("attrSearch");
        ArrayList values = new ArrayList(this.criteria.getValues());
        new ArrayList(this.criteria.getTypes());
        writer.write("select * from (select distinct art_id, art_path");
        if (newRelation) {
            writer.write(", top, top_rel_type, top_rel_order");
        }
        if (pagination != null && writer.getJdbcClient().getDbType().isPaginationOrderingSupported()) {
            writer.write(", dense_rank() over (order by top");
            if (newRelation) {
                writer.write(", top_rel_type, top_rel_order");
            }
            writer.write(") rn2 from " + attAlias);
        } else if (pagination != null) {
            writer.write(", row_number() over () rn2 from " + attAlias);
        } else {
            writer.write(" from " + attAlias);
        }
        writer.write(" where ");
        List<QueryOption> options = Arrays.asList(this.criteria.getOptions());
        if (values.size() > 1) {
            writer.write("value in (" + ((Object)values).toString() + ") ");
        } else if (options.contains(QueryOption.CASE__MATCH) && options.contains(QueryOption.TOKEN_MATCH_ORDER__MATCH)) {
            writer.write("value = '" + (String)values.get(0) + "' ");
        } else {
            writer.write("lower(value) like lower('%" + (String)values.get(0) + "%') ");
        }
        if (pagination != null) {
            Long tempLowerBound = (pagination.getPageNum() - 1L) * pagination.getPageSize();
            Long lowerBound = tempLowerBound == 0L ? tempLowerBound : tempLowerBound + 1L;
            Long upperBound = tempLowerBound == 0L ? lowerBound + pagination.getPageSize() : lowerBound + pagination.getPageSize() - 1L;
            writer.addParameter(lowerBound);
            writer.addParameter(upperBound);
            writer.write(" ) t1 where rn2 between ? AND ? ");
        } else {
            writer.write(" ) t1 ");
        }
        return this.attrSearchAlias;
    }

    @Override
    public boolean hasPredicates() {
        return false;
    }
}

