/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.handlers;

import java.util.List;
import org.eclipse.osee.jdbc.ObjectType;
import org.eclipse.osee.orcs.OseeDb;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaAttributeValueRange;
import org.eclipse.osee.orcs.db.internal.search.handlers.SqlHandlerPriority;
import org.eclipse.osee.orcs.db.internal.sql.AbstractSqlWriter;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandler;

public class AttributeValueRangeSqlHandler
extends SqlHandler<CriteriaAttributeValueRange> {
    private CriteriaAttributeValueRange criteria;
    private String attrAlias;
    private String txsAlias;

    @Override
    public void setData(CriteriaAttributeValueRange criteria) {
        this.criteria = criteria;
    }

    @Override
    public void addTables(AbstractSqlWriter writer) {
        this.attrAlias = writer.addTable(OseeDb.ATTRIBUTE_TABLE);
        this.txsAlias = writer.addTable(OseeDb.TXS_TABLE, ObjectType.ATTRIBUTE);
    }

    @Override
    public void addPredicates(AbstractSqlWriter writer) {
        writer.write(this.attrAlias);
        writer.write(".attr_type_id = ?");
        writer.addParameter(this.criteria.getAttributeType().getId());
        writer.writeAnd();
        writer.write(this.attrAlias);
        writer.write(".value < " + this.criteria.getToValue());
        writer.writeAnd();
        writer.write(this.attrAlias);
        writer.write(".value > " + this.criteria.getFromValue());
        List<String> aliases = writer.getAliases(OseeDb.ARTIFACT_TABLE);
        if (!aliases.isEmpty()) {
            writer.writeAndLn();
            int aSize = aliases.size();
            int index = 0;
            while (index < aSize) {
                String artAlias = aliases.get(index);
                writer.write(artAlias);
                writer.write(".art_id = ");
                writer.write(this.attrAlias);
                writer.write(".art_id");
                if (index + 1 < aSize) {
                    writer.writeAnd();
                }
                ++index;
            }
        }
        writer.writeAnd();
        writer.write(this.attrAlias);
        writer.write(".gamma_id = ");
        writer.write(this.txsAlias);
        writer.write(".gamma_id");
        writer.writeAnd();
        writer.writeTxBranchFilter(this.txsAlias);
    }

    @Override
    public int getPriority() {
        return SqlHandlerPriority.ATTRIBUTE_RANGE.ordinal();
    }
}

