/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.handlers;

import org.eclipse.osee.orcs.OseeDb;
import org.eclipse.osee.orcs.core.ds.Options;
import org.eclipse.osee.orcs.core.ds.OptionsUtil;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaArtifactIds;
import org.eclipse.osee.orcs.db.internal.search.handlers.SqlHandlerPriority;
import org.eclipse.osee.orcs.db.internal.sql.AbstractSqlWriter;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandler;
import org.eclipse.osee.orcs.db.internal.sql.join.IdJoinQuery;

public class ArtifactIdsSqlHandler
extends SqlHandler<CriteriaArtifactIds> {
    private CriteriaArtifactIds criteria;
    private String jIdAlias;
    private String cteAlias;
    private String artAlias;
    private String txsAlias;

    @Override
    public void writeCommonTableExpression(AbstractSqlWriter writer) {
        if (OptionsUtil.isHistorical((Options)writer.getOptions())) {
            this.cteAlias = writer.startCommonTableExpression("artMax");
            writer.write("SELECT max(txs.transaction_id) as transaction_id, art.art_id\n FROM ");
            if (this.criteria.hasMultipleIds()) {
                writer.write("osee_join_id jid, ");
            }
            writer.write("osee_artifact art, osee_txs txs\n WHERE ");
            if (this.criteria.hasMultipleIds()) {
                IdJoinQuery joinQuery = writer.writeJoin(this.criteria.getIds());
                writer.writeEqualsParameterAnd("jid", "query_id", joinQuery.getQueryId());
                writer.writeEqualsAnd("jid", "id", "art", "art_id");
            } else {
                writer.writeEqualsParameterAnd("art", "art_id", this.criteria.getId());
            }
            writer.writeEqualsAnd("art", "txs", "gamma_id");
            writer.writeTxBranchFilter("txs", true);
            writer.write("\n GROUP BY art.art_id");
        }
    }

    @Override
    public void setData(CriteriaArtifactIds criteria) {
        this.criteria = criteria;
    }

    @Override
    public void addTables(AbstractSqlWriter writer) {
        if (this.cteAlias == null) {
            if (this.criteria.hasMultipleIds()) {
                this.jIdAlias = writer.addTable(OseeDb.OSEE_JOIN_ID_TABLE);
            }
        } else {
            writer.addTable(this.cteAlias);
        }
        this.artAlias = writer.getMainTableAlias(OseeDb.ARTIFACT_TABLE);
        this.txsAlias = writer.getMainTableAlias(OseeDb.TXS_TABLE);
    }

    @Override
    public void addPredicates(AbstractSqlWriter writer) {
        if (this.cteAlias == null) {
            if (this.criteria.hasMultipleIds()) {
                IdJoinQuery joinQuery = writer.writeJoin(this.criteria.getIds());
                writer.writeEqualsParameterAnd(this.jIdAlias, "query_id", joinQuery.getQueryId());
                writer.writeEquals(this.jIdAlias, "id", this.artAlias, "art_id");
            } else {
                writer.writeEqualsParameter(this.artAlias, "art_id", this.criteria.getId());
            }
        } else {
            writer.writeEqualsAnd(this.cteAlias, this.artAlias, "art_id");
            writer.writeEquals(this.cteAlias, this.txsAlias, "transaction_id");
        }
    }

    @Override
    public int getPriority() {
        return SqlHandlerPriority.ARTIFACT_ID.ordinal();
    }
}

