/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.loader.executors;

import org.eclipse.osee.framework.core.executor.HasCancellation;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.orcs.core.ds.LoadDataHandler;
import org.eclipse.osee.orcs.core.ds.Options;
import org.eclipse.osee.orcs.db.internal.loader.LoadUtil;
import org.eclipse.osee.orcs.db.internal.loader.SqlObjectLoader;
import org.eclipse.osee.orcs.db.internal.loader.criteria.CriteriaOrcsLoad;
import org.eclipse.osee.orcs.db.internal.loader.executors.AbstractLoadExecutor;
import org.eclipse.osee.orcs.db.internal.search.QuerySqlContext;

public class QueryContextLoadExecutor
extends AbstractLoadExecutor {
    private final QuerySqlContext queryContext;

    public QueryContextLoadExecutor(SqlObjectLoader loader, JdbcClient jdbcClient, QuerySqlContext queryContext) {
        super(loader, jdbcClient);
        this.queryContext = queryContext;
    }

    @Override
    public void load(HasCancellation cancellation, LoadDataHandler handler, CriteriaOrcsLoad criteria, Options options) {
        int fetchSize = LoadUtil.computeFetchSize(10);
        QuerySqlContext.ObjectQueryType typeToLoad = this.queryContext.getOrcsObjectType();
        switch (typeToLoad) {
            case DYNAMIC_OBJECT: {
                this.getLoader().loadDynamicObjects(cancellation, handler, this.queryContext, fetchSize);
                break;
            }
            default: {
                throw new OseeStateException("Unable to determine object to load from [%s]", new Object[]{this.queryContext});
            }
        }
    }
}

