/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.loader.data;

import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeId;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchCategoryToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.data.RelationId;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.Tuple2Type;
import org.eclipse.osee.framework.core.data.Tuple3Type;
import org.eclipse.osee.framework.core.data.Tuple4Type;
import org.eclipse.osee.framework.core.data.TupleTypeId;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.enums.TxCurrent;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.core.ds.ArtifactData;
import org.eclipse.osee.orcs.core.ds.ArtifactDataImpl;
import org.eclipse.osee.orcs.core.ds.AttributeData;
import org.eclipse.osee.orcs.core.ds.BranchCategoryData;
import org.eclipse.osee.orcs.core.ds.DataProxy;
import org.eclipse.osee.orcs.core.ds.RelationData;
import org.eclipse.osee.orcs.core.ds.TupleData;
import org.eclipse.osee.orcs.core.ds.VersionData;
import org.eclipse.osee.orcs.core.ds.VersionDataImpl;
import org.eclipse.osee.orcs.db.internal.OrcsObjectFactory;
import org.eclipse.osee.orcs.db.internal.loader.data.AttributeDataImpl;
import org.eclipse.osee.orcs.db.internal.loader.data.BranchCategoryDataImpl;
import org.eclipse.osee.orcs.db.internal.loader.data.RelationDataImpl;
import org.eclipse.osee.orcs.db.internal.loader.data.TupleDataImpl;
import org.eclipse.osee.orcs.db.internal.proxy.AttributeDataProxyFactory;

public class OrcsObjectFactoryImpl
implements OrcsObjectFactory {
    private final AttributeDataProxyFactory proxyFactory;
    private final OrcsTokenService tokenService;

    public OrcsObjectFactoryImpl(AttributeDataProxyFactory proxyFactory, OrcsTokenService tokenService) {
        this.proxyFactory = proxyFactory;
        this.tokenService = tokenService;
    }

    @Override
    public VersionData createVersion(BranchId branchId, TransactionId txId, GammaId gamma, TxCurrent txCurrent, boolean historical) {
        return this.createVersion(branchId, txId, gamma, txCurrent, historical, TransactionId.SENTINEL);
    }

    @Override
    public VersionData createDefaultVersionData() {
        return this.createVersion(BranchId.SENTINEL, TransactionId.SENTINEL, GammaId.SENTINEL, TxCurrent.SENTINEL, false, TransactionId.SENTINEL);
    }

    @Override
    public VersionData createCopy(VersionData other) {
        return this.createVersion(other.getBranch(), other.getTransactionId(), other.getGammaId(), other.getTxCurrent(), other.isHistorical(), other.getStripeId());
    }

    private VersionData createVersion(BranchId branchId, TransactionId txId, GammaId gamma, TxCurrent txCurrent, boolean historical, TransactionId stripeId) {
        VersionDataImpl version = new VersionDataImpl();
        version.setBranch(branchId);
        version.setTransactionId(txId);
        version.setGammaId(gamma);
        version.setTxCurrent(txCurrent);
        version.setHistorical(historical);
        version.setStripeId(stripeId);
        return version;
    }

    @Override
    public ArtifactData createArtifactData(VersionData version, ArtifactId artifactId, ArtifactTypeToken artifactType, ModificationType modType, String guidToSet, ApplicabilityId applicId) {
        return this.createArtifactFromRow(version, artifactId, artifactType, modType, artifactType, modType, guidToSet, applicId);
    }

    @Override
    public ArtifactData createCopy(ArtifactData source) {
        VersionData newVersion = this.createCopy(source.getVersion());
        return this.createArtifactFromRow(newVersion, (ArtifactId)source, (ArtifactTypeToken)source.getType(), source.getModType(), (ArtifactTypeToken)source.getBaseType(), source.getBaseModType(), source.getGuid(), source.getApplicabilityId());
    }

    @Override
    public <T> AttributeData<T> createAttributeData(VersionData version, AttributeId id, AttributeTypeGeneric<?> attributeType, ModificationType modType, ArtifactId artifactId, T value, String uri, ApplicabilityId applicId) {
        DataProxy<T> proxy = this.proxyFactory.createProxy((AttributeTypeToken)attributeType, value, uri);
        return this.createAttributeFromRow(version, id, attributeType, modType, (AttributeTypeToken)attributeType, modType, artifactId, proxy, applicId);
    }

    @Override
    public <T> AttributeData<T> createCopy(AttributeData<T> source) {
        VersionData newVersion = this.createCopy(source.getVersion());
        AttributeTypeGeneric attributeType = this.tokenService.getAttributeType(((AttributeTypeToken)source.getType()).getId());
        DataProxy sourceProxy = source.getDataProxy();
        DataProxy<Object> newProxy = this.proxyFactory.createProxy((AttributeTypeToken)attributeType, sourceProxy.getRawValue(), sourceProxy.getUri());
        return this.createAttributeFromRow(newVersion, (AttributeId)source, (AttributeTypeGeneric<?>)attributeType, source.getModType(), (AttributeTypeToken)source.getBaseType(), source.getBaseModType(), source.getArtifactId(), (DataProxy<T>)newProxy, source.getApplicabilityId());
    }

    @Override
    public <T> AttributeData<T> createAttributeData(VersionData version, AttributeId generateAttId, AttributeTypeGeneric<?> attributeType, ModificationType modType, ArtifactId artId, ApplicabilityId applicId) {
        DataProxy<String> proxy = this.proxyFactory.createProxy((AttributeTypeToken)attributeType, "", "");
        return this.createAttributeFromRow(version, generateAttId, attributeType, modType, (AttributeTypeToken)attributeType, modType, artId, (DataProxy<T>)proxy, applicId);
    }

    @Override
    public RelationData createRelationData(VersionData version, RelationId id, RelationTypeToken relationType, ModificationType modType, ArtifactId aArtId, ArtifactId bArtId, String rationale, ApplicabilityId applicId) {
        return this.createRelationData(version, id, relationType, modType, relationType, modType, aArtId, bArtId, ArtifactId.SENTINEL, 0, rationale, applicId);
    }

    @Override
    public RelationData createRelationData(VersionData version, RelationId id, RelationTypeToken relationType, ModificationType modType, ArtifactId aArtId, ArtifactId bArtId, ArtifactId relArtId, int relOrder, ApplicabilityId applicId) {
        return this.createRelationData(version, id, relationType, modType, relationType, modType, aArtId, bArtId, relArtId, relOrder, "", applicId);
    }

    private ArtifactData createArtifactFromRow(VersionData version, ArtifactId artifactId, ArtifactTypeToken artifactType, ModificationType modType, ArtifactTypeToken baseArtifactType, ModificationType baseModType, String guid, ApplicabilityId applicId) {
        ArtifactDataImpl data = new ArtifactDataImpl(version);
        data.setLocalId((Id)artifactId);
        data.setType((Id)artifactType);
        data.setBaseType((Id)baseArtifactType);
        data.setModType(modType);
        data.setBaseModType(baseModType);
        data.setGuid(guid);
        data.setApplicabilityId(applicId);
        return data;
    }

    private <T> AttributeData<T> createAttributeFromRow(VersionData version, AttributeId id, AttributeTypeGeneric<?> attributeType, ModificationType modType, AttributeTypeToken baseAttributeType, ModificationType baseModType, ArtifactId artifactId, DataProxy<T> proxy, ApplicabilityId applicId) {
        AttributeDataImpl data = new AttributeDataImpl(version);
        data.setLocalId((Id)id);
        data.setType((Id)attributeType);
        data.setBaseType((Id)baseAttributeType);
        data.setModType(modType);
        data.setBaseModType(baseModType);
        data.setArtifactId(artifactId);
        data.setDataProxy(proxy);
        data.setApplicabilityId(applicId);
        return data;
    }

    private RelationData createRelationData(VersionData version, RelationId id, RelationTypeToken relationType, ModificationType modType, RelationTypeToken baseRelationType, ModificationType baseModType, ArtifactId aArtId, ArtifactId bArtId, ArtifactId relArtId, int relOrder, String rationale, ApplicabilityId applicId) {
        RelationDataImpl data = new RelationDataImpl(version);
        if (relationType.isNewRelationTable()) {
            if (version.getGammaId().isValid()) {
                data.setLocalId((Id)version.getGammaId());
            } else {
                data.setLocalId((Id)id);
            }
            data.setRelOrder(relOrder);
            data.setRelationArtifact(relArtId);
        } else {
            data.setLocalId((Id)id);
        }
        data.setType((Id)relationType);
        data.setBaseType((Id)baseRelationType);
        data.setModType(modType);
        data.setBaseModType(baseModType);
        data.setArtIdA(aArtId);
        data.setArtIdB(bArtId);
        if (Strings.isValid((String)rationale)) {
            data.setRationale(rationale);
        }
        data.setApplicabilityId(applicId);
        return data;
    }

    @Override
    public RelationData createCopy(RelationData source) {
        VersionData newVersion = this.createCopy(source.getVersion());
        return this.createRelationData(newVersion, (RelationId)source, (RelationTypeToken)source.getType(), source.getModType(), (RelationTypeToken)source.getBaseType(), source.getBaseModType(), source.getArtifactIdA(), source.getArtifactIdB(), source.getRelationArtifact(), source.getRelOrder(), source.getRationale(), source.getApplicabilityId());
    }

    @Override
    public BranchCategoryData createBranchCategoryData(VersionData version, BranchId branchId, BranchCategoryToken category) {
        BranchCategoryDataImpl data = new BranchCategoryDataImpl(version);
        data.setBaseModType(ModificationType.NEW);
        data.setModType(ModificationType.NEW);
        data.setApplicabilityId(ApplicabilityId.BASE);
        data.getVersion().setGammaId(GammaId.valueOf((Long)Lib.generateUuid()));
        data.getVersion().setBranch(branchId);
        data.setBranchId(branchId);
        data.setCategory(category);
        return data;
    }

    private TupleData createTuple2Data(VersionData version, BranchId branch, TupleTypeId tupleType, Long e1, Long e2) {
        TupleDataImpl data = new TupleDataImpl(version);
        data.setBaseModType(ModificationType.NEW);
        data.setModType(ModificationType.NEW);
        data.setApplicabilityId(ApplicabilityId.BASE);
        data.setTupleType(tupleType);
        data.getVersion().setGammaId(GammaId.valueOf((Long)Lib.generateUuid()));
        data.getVersion().setBranch(branch);
        data.setElement1(e1);
        data.setElement2(e2);
        return data;
    }

    @Override
    public TupleData createTuple2Data(VersionData version, BranchId branch, Tuple2Type<?, ?> tupleType, Long e1, Long e2) {
        return this.createTuple2Data(version, branch, (TupleTypeId)tupleType, e1, e2);
    }

    @Override
    public TupleData createTuple3Data(VersionData version, BranchId branch, Tuple3Type<?, ?, ?> tupleType, Long e1, Long e2, Long e3) {
        TupleData data = this.createTuple2Data(version, branch, (TupleTypeId)tupleType, e1, e2);
        data.setElement3(e3);
        return data;
    }

    @Override
    public TupleData createTuple4Data(VersionData version, BranchId branch, Tuple4Type<?, ?, ?, ?> tupleType, Long e1, Long e2, Long e3, Long e4) {
        TupleData data = this.createTuple2Data(version, branch, (TupleTypeId)tupleType, e1, e2);
        data.setElement3(e3);
        data.setElement4(e4);
        return data;
    }

    @Override
    public ArtifactData createArtifactData(VersionData version, ArtifactId artifactId, Long artifactType, ModificationType modType, String guidToSet, ApplicabilityId applicId) {
        return this.createArtifactData(version, artifactId, this.tokenService.getArtifactType(artifactType), modType, guidToSet, applicId);
    }
}

