/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.exchange;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Objects;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.jdk.core.type.PropertyStore;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Zip;
import org.eclipse.osee.framework.resource.management.IResource;
import org.eclipse.osee.framework.resource.management.IResourceLocator;
import org.eclipse.osee.framework.resource.management.IResourceManager;
import org.eclipse.osee.logger.Log;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class ExchangeUtil {
    private static final String TEMP_NAME_PREFIX = "branch.xchng.";

    private ExchangeUtil() {
    }

    public static Writer createSqlWriter(File tempFolder, String name, int bufferSize) throws IOException {
        File indexFile = new File(tempFolder, name);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(indexFile), "UTF-8"), bufferSize);
        return writer;
    }

    public static Pair<Boolean, File> getTempExchangeFile(String exchangePath, Log logger, IResourceLocator locator, IResourceManager resourceManager) {
        File importSource = null;
        boolean wasZipExtractionRequired = false;
        IResource resource = resourceManager.acquire(locator, new PropertyStore());
        Conditions.checkExpressionFailOnTrue((!resourceManager.exists(locator) ? 1 : 0) != 0, (String)"Error locating [%s]", (Object[])new Object[]{locator.getLocation()});
        Objects.requireNonNull(resource, "Resource can not be null");
        File source = new File(resource.getLocation());
        if (source.isFile()) {
            wasZipExtractionRequired = true;
            importSource = ExchangeUtil.createTempFolder(exchangePath);
            logger.info("Extracting Exchange File: [%s] to [%s]", new Object[]{source.getName(), importSource});
            try {
                Zip.decompressStream((InputStream)new FileInputStream(source), (File)importSource);
            }
            catch (Exception ex) {
                OseeCoreException.wrapAndThrow((Throwable)ex);
            }
            wasZipExtractionRequired = true;
        } else {
            wasZipExtractionRequired = false;
            importSource = source;
        }
        return new Pair((Object)wasZipExtractionRequired, (Object)importSource);
    }

    public static void cleanUpTempExchangeFile(String exchangePath, Log logger, File exchangeSource, boolean wasZipExtractionRequired) {
        if (wasZipExtractionRequired && exchangeSource != null && exchangeSource.exists() && !exchangeSource.getAbsolutePath().equals(exchangePath)) {
            logger.info("Deleting Branch Import Temp Folder - [%s]", new Object[]{exchangeSource});
            Lib.deleteDir((File)exchangeSource);
        }
    }

    public static File createTempFolder(String exchangePath) {
        String fileName = TEMP_NAME_PREFIX + Lib.getDateTimeString();
        File rootDirectory = new File(exchangePath, String.valueOf(fileName) + File.separator);
        rootDirectory.mkdirs();
        return rootDirectory;
    }

    public static void readExchange(File file, ContentHandler handler) {
        block5: {
            BufferedInputStream byteStream = null;
            try {
                try {
                    byteStream = new BufferedInputStream(new FileInputStream(file));
                    XMLReader reader = XMLReaderFactory.createXMLReader();
                    reader.setContentHandler(handler);
                    reader.parse(new InputSource(byteStream));
                }
                catch (Exception ex) {
                    OseeCoreException.wrapAndThrow((Throwable)ex);
                    Lib.close(byteStream);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                Lib.close(byteStream);
                throw throwable;
            }
            Lib.close((AutoCloseable)byteStream);
        }
    }
}

