/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.branch;

import java.net.URI;
import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.Branch;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.OseeCodeVersion;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.data.UserService;
import org.eclipse.osee.framework.core.enums.BranchState;
import org.eclipse.osee.framework.core.enums.BranchType;
import org.eclipse.osee.framework.core.enums.PermissionEnum;
import org.eclipse.osee.framework.core.executor.ExecutorAdmin;
import org.eclipse.osee.framework.core.model.change.ChangeItem;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.PropertyStore;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.resource.management.IResourceManager;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcTransaction;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.OseeDb;
import org.eclipse.osee.orcs.SystemProperties;
import org.eclipse.osee.orcs.core.ds.BranchDataStore;
import org.eclipse.osee.orcs.core.ds.DataLoaderFactory;
import org.eclipse.osee.orcs.data.ArchiveOperation;
import org.eclipse.osee.orcs.data.CreateBranchData;
import org.eclipse.osee.orcs.db.internal.IdentityManager;
import org.eclipse.osee.orcs.db.internal.callable.ArchiveUnarchiveBranchOperation;
import org.eclipse.osee.orcs.db.internal.callable.BranchCopyTxCallable;
import org.eclipse.osee.orcs.db.internal.callable.BranchInheritACLCallable;
import org.eclipse.osee.orcs.db.internal.callable.CommitBranchDatabaseTxCallable;
import org.eclipse.osee.orcs.db.internal.callable.CreateBranchDatabaseTxCallable;
import org.eclipse.osee.orcs.db.internal.callable.ExportBranchDatabaseCallable;
import org.eclipse.osee.orcs.db.internal.callable.ImportBranchDatabaseCallable;
import org.eclipse.osee.orcs.db.internal.callable.PurgeBranchDatabaseCallable;
import org.eclipse.osee.orcs.db.internal.change.LoadDeltasBetweenTxsOnTheSameBranch;
import org.eclipse.osee.orcs.db.internal.change.MissingChangeItemFactory;
import org.eclipse.osee.orcs.db.internal.change.MissingChangeItemFactoryImpl;
import org.eclipse.osee.orcs.db.internal.exchange.ExportItemFactory;
import org.eclipse.osee.orcs.db.internal.sql.join.SqlJoinFactory;
import org.eclipse.osee.orcs.search.BranchQuery;

public class BranchStoreImpl
implements BranchDataStore {
    private final String UPDATE_BRANCH_ACL = "UPDATE OSEE_BRANCH_ACL SET permission_id = ? WHERE privilege_entity_id = ? AND branch_id = ?";
    private final String GET_BRANCH_PERMISSION = "SELECT permission_id FROM osee_branch_acl WHERE privilege_entity_id = ? AND branch_id = ?";
    private static final String COPY_APPLIC = "INSERT INTO osee_txs (branch_id, gamma_id, transaction_id, tx_current, mod_type, app_id)\nwith cte as (select branch_id as chid, baseline_transaction_id as chtx, parent_branch_id as pid from osee_branch where branch_id = ?)\nselect chid, txsP.gamma_id, chtx, tx_current, mod_type, app_id from cte, osee_tuple2 t2, osee_txs txsP where tuple_type = 2 and t2.gamma_id = txsP.gamma_id and txsP.branch_id = pid and txsP.tx_current =1 and not exists (select 1 from osee_txs txsC where txsC.branch_id = chid and txsC.gamma_id = txsP.gamma_id)";
    public static final String UPDATE_BRANCH_FIELD = "UPDATE osee_branch SET %s = ? WHERE branch_id = ?";
    private final Log logger;
    private final JdbcClient jdbcClient;
    private final SqlJoinFactory joinFactory;
    private final IdentityManager idManager;
    private final SystemProperties preferences;
    private final ExecutorAdmin executorAdmin;
    private final IResourceManager resourceManager;
    private MissingChangeItemFactory missingChangeItemFactory;
    private DataLoaderFactory dataLoaderFactory;

    public BranchStoreImpl(Log logger, JdbcClient jdbcClient, SqlJoinFactory joinFactory, IdentityManager idManager, SystemProperties preferences, ExecutorAdmin executorAdmin, IResourceManager resourceManager) {
        this.logger = logger;
        this.jdbcClient = jdbcClient;
        this.joinFactory = joinFactory;
        this.idManager = idManager;
        this.preferences = preferences;
        this.executorAdmin = executorAdmin;
        this.resourceManager = resourceManager;
    }

    public void addMissingApplicabilityFromParentBranch(BranchId branch) {
        this.jdbcClient.runPreparedUpdate(COPY_APPLIC, new Object[]{branch});
    }

    public void createBranch(CreateBranchData branchData, UserService userService, OrcsTokenService tokenService) {
        this.jdbcClient.runTransaction((JdbcTransaction)new CreateBranchDatabaseTxCallable(this.jdbcClient, this.idManager, userService, branchData, OseeCodeVersion.getVersionId(), tokenService));
        if (branchData.isInheritAccess()) {
            this.jdbcClient.runTransaction((JdbcTransaction)new BranchInheritACLCallable(this.jdbcClient, branchData));
        }
    }

    public XResultData createBranchValidation(CreateBranchData branchData, UserService userService, OrcsTokenService tokenService) {
        return new CreateBranchDatabaseTxCallable(this.jdbcClient, this.idManager, userService, branchData, OseeCodeVersion.getVersionId(), tokenService).checkPreconditions(this.jdbcClient.getConnection());
    }

    public void createBranchCopyTx(CreateBranchData branchData, UserService userService, OrcsTokenService tokenService) {
        this.jdbcClient.runTransaction((JdbcTransaction)new BranchCopyTxCallable(this.jdbcClient, this.idManager, userService, branchData, OseeCodeVersion.getVersionId(), tokenService));
    }

    public TransactionId commitBranch(OrcsSession session, ArtifactId committer, OrcsTokenService tokenService, Branch source, TransactionToken sourceTx, Branch destination, TransactionToken destinationTx, OrcsApi orcsApi) {
        BranchId mergeBranch = this.getMergeBranchId(orcsApi.getQueryFactory().branchQuery(), (BranchId)source, (BranchId)destination);
        try {
            return (TransactionId)new CommitBranchDatabaseTxCallable(this.idManager, committer, this.jdbcClient, this.joinFactory, tokenService, source, (BranchId)destination, sourceTx, destinationTx, mergeBranch, orcsApi, this.getMissingChangeItemFactoryImpl()).call();
        }
        catch (Exception ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }

    public Callable<Void> purgeBranch(OrcsSession session, Branch toDelete) {
        return new PurgeBranchDatabaseCallable(this.logger, session, this.jdbcClient, toDelete);
    }

    public List<ChangeItem> compareBranch(OrcsSession session, OrcsTokenService tokenService, TransactionToken sourceTx, TransactionToken destinationTx, OrcsApi orcsApi) {
        BranchId mergeBranch = this.getMergeBranchId(orcsApi.getQueryFactory().branchQuery(), sourceTx.getBranch(), destinationTx.getBranch());
        return new LoadDeltasBetweenTxsOnTheSameBranch(this.jdbcClient, this.joinFactory, tokenService, sourceTx, destinationTx, mergeBranch, orcsApi, this.getMissingChangeItemFactoryImpl()).compareTransactions();
    }

    private BranchId getMergeBranchId(BranchQuery branchQuery, BranchId source, BranchId destination) {
        if (branchQuery.andIsMergeFor(source, destination) == null) {
            return BranchId.SENTINEL;
        }
        BranchId mergeBranch = (BranchId)((BranchQuery)branchQuery.andIsMergeFor(source, destination)).getResults().getAtMostOneOrDefault((Object)Branch.SENTINEL);
        if (mergeBranch.isInvalid()) {
            mergeBranch = BranchId.SENTINEL;
        }
        return mergeBranch;
    }

    public Callable<URI> exportBranch(OrcsSession session, List<? extends BranchId> branches, PropertyStore options, String exportName) {
        ExportItemFactory factory = new ExportItemFactory(this.logger, this.preferences, this.jdbcClient, this.resourceManager);
        return new ExportBranchDatabaseCallable(session, factory, this.joinFactory, this.preferences, this.executorAdmin, branches, options, exportName);
    }

    public Callable<URI> importBranch(OrcsSession session, URI fileToImport, List<? extends BranchId> branches, PropertyStore options) {
        ImportBranchDatabaseCallable callable = new ImportBranchDatabaseCallable(this.logger, session, this.jdbcClient, this.preferences, this.resourceManager, fileToImport, branches, options);
        return callable;
    }

    public XResultData changeBranchState(OrcsSession session, BranchId branch, BranchState branchState) {
        Conditions.checkNotNull((Object)branch, (String)"branch");
        String query = String.format(UPDATE_BRANCH_FIELD, "branch_state");
        this.jdbcClient.runPreparedUpdate(query, new Object[]{branchState, branch});
        return XResultData.OK_STATUS;
    }

    public XResultData changeBranchType(OrcsSession session, BranchId branch, BranchType branchType) {
        Conditions.checkNotNull((Object)branch, (String)"branch");
        String query = String.format(UPDATE_BRANCH_FIELD, "branch_type");
        this.jdbcClient.runPreparedUpdate(query, new Object[]{branchType, branch});
        return XResultData.OK_STATUS;
    }

    public XResultData changeBranchName(OrcsSession session, BranchId branch, String branchName) {
        Conditions.checkNotNull((Object)branch, (String)"branch");
        String query = String.format(UPDATE_BRANCH_FIELD, "branch_name");
        this.jdbcClient.runPreparedUpdate(query, new Object[]{branchName, branch});
        return XResultData.OK_STATUS;
    }

    public XResultData changeBranchAssociatedArt(OrcsSession session, BranchId branch, ArtifactId assocArt) {
        Conditions.checkNotNull((Object)branch, (String)"branch");
        String query = String.format(UPDATE_BRANCH_FIELD, "associated_art_id");
        this.jdbcClient.runPreparedUpdate(query, new Object[]{assocArt, branch});
        return XResultData.OK_STATUS;
    }

    public XResultData archiveBranch(OrcsSession session, BranchId branch) {
        return new ArchiveUnarchiveBranchOperation(this.jdbcClient, branch, ArchiveOperation.ARCHIVE).run();
    }

    public XResultData unArchiveBranch(OrcsSession session, BranchId branch) {
        return new ArchiveUnarchiveBranchOperation(this.jdbcClient, branch, ArchiveOperation.UNARCHIVE).run();
    }

    public XResultData deleteBranch(OrcsSession session, BranchId branch) {
        this.changeBranchState(session, branch, BranchState.DELETED);
        this.archiveBranch(session, branch);
        return XResultData.OK_STATUS;
    }

    public void setBranchPermission(ArtifactId subject, BranchId branch, PermissionEnum permission) {
        int existingPermission = (Integer)this.jdbcClient.fetch((Object)-1, "SELECT permission_id FROM osee_branch_acl WHERE privilege_entity_id = ? AND branch_id = ?", new Object[]{subject, branch});
        if (existingPermission == -1) {
            this.jdbcClient.runPreparedUpdate(OseeDb.OSEE_BRANCH_ACL_TABLE.getInsertSql(), new Object[]{branch, subject, permission.getPermId()});
        } else {
            this.jdbcClient.runPreparedUpdate("UPDATE OSEE_BRANCH_ACL SET permission_id = ? WHERE privilege_entity_id = ? AND branch_id = ?", new Object[]{permission.getPermId(), subject, branch});
        }
    }

    public void setDataLoaderFactory(DataLoaderFactory dataLoaderFactory) {
        this.dataLoaderFactory = dataLoaderFactory;
    }

    public MissingChangeItemFactory getMissingChangeItemFactoryImpl() {
        if (this.missingChangeItemFactory == null) {
            this.missingChangeItemFactory = new MissingChangeItemFactoryImpl(this.dataLoaderFactory);
        }
        return this.missingChangeItemFactory;
    }
}

