/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.disposition.rest.resources;

import io.swagger.v3.oas.annotations.Parameter;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.eclipse.osee.disposition.model.CopySetParamOption;
import org.eclipse.osee.disposition.model.CopySetParams;
import org.eclipse.osee.disposition.model.DispoProgamDescriptorData;
import org.eclipse.osee.disposition.model.DispoSet;
import org.eclipse.osee.disposition.rest.DispoApi;
import org.eclipse.osee.disposition.rest.internal.report.ExportSet;
import org.eclipse.osee.disposition.rest.resources.DispoAdminEndpoint;
import org.eclipse.osee.disposition.rest.resources.DispoConfigEndpoint;
import org.eclipse.osee.disposition.rest.resources.DispoSetEndpoint;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.util.JsonUtil;
import org.eclipse.osee.framework.jdk.core.annotation.Swagger;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;

@Path(value="program")
@Swagger
public class DispoProgramEndpoint {
    private final DispoApi dispoApi;

    public DispoProgramEndpoint(DispoApi dispoApi) {
        this.dispoApi = dispoApi;
    }

    @POST
    @RolesAllowed(value={"dispoAdmin"})
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    public Response createProgram(DispoProgamDescriptorData programDescriptor, @Parameter(description="The Username") @QueryParam(value="userName") String userName) {
        Response response;
        String name = "(DISPO)" + programDescriptor.getName();
        if (!name.isEmpty()) {
            boolean isUniqueName = this.dispoApi.isUniqueProgramName(name);
            if (isUniqueName) {
                long createdProgramId = this.dispoApi.createDispoProgram(name);
                Response.Status status = Response.Status.CREATED;
                response = Response.status((Response.Status)status).entity((Object)createdProgramId).build();
            } else {
                Response.Status status = Response.Status.CONFLICT;
                response = Response.status((Response.Status)status).entity((Object)"Can't create sets with the same name").build();
            }
        } else {
            Response.Status status = Response.Status.BAD_REQUEST;
            response = Response.status((Response.Status)status).entity((Object)"The Set must have a name and import path").build();
        }
        return response;
    }

    @Path(value="{name}")
    @POST
    @RolesAllowed(value={"dispoAdmin"})
    @Produces(value={"text/plain"})
    public Response createDispoProgramByName(@PathParam(value="name") String name, @QueryParam(value="userName") String userName) {
        DispoProgamDescriptorData programDescriptor = new DispoProgamDescriptorData();
        programDescriptor.setName(name);
        return this.createProgram(programDescriptor, userName);
    }

    @GET
    @Produces(value={"application/json"})
    public Response getAllPrograms() {
        List<BranchToken> allPrograms = this.dispoApi.getDispoPrograms();
        Collections.sort(allPrograms, new Comparator<BranchToken>(){

            @Override
            public int compare(BranchToken o1, BranchToken o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        LinkedList branchList = new LinkedList();
        for (BranchToken branch : allPrograms) {
            HashMap<String, String> mapObject = new HashMap<String, String>();
            String uuid = branch.getIdString();
            mapObject.put("value", uuid);
            mapObject.put("text", branch.getName());
            branchList.add(mapObject);
        }
        Response.Status status = allPrograms.isEmpty() ? Response.Status.NOT_FOUND : Response.Status.OK;
        String branchListJson = JsonUtil.toJson(branchList);
        return Response.status((Response.Status)status).entity((Object)branchListJson).build();
    }

    @Path(value="list")
    @GET
    @Produces(value={"application/json"})
    public String getAllProgramNames() {
        List<String> allProgramNames = this.dispoApi.getDispoProgramNames();
        Collections.sort(allProgramNames);
        return String.join((CharSequence)"\n", allProgramNames);
    }

    @Path(value="getDispoBranchId")
    @GET
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public String getDispoBranchId(@Parameter(description="The Branch name", required=true) @FormParam(value="name") String branchName) {
        return this.dispoApi.getDispoProgramIdByName(branchName).getIdString();
    }

    @Path(value="importAll")
    @PUT
    @RolesAllowed(value={"dispoAdmin"})
    @Consumes(value={"application/json"})
    public Response importAllDispoSets(String filterState) {
        this.dispoApi.importAllDispoPrograms(filterState);
        Response.Status status = Response.Status.OK;
        return Response.status((Response.Status)status).build();
    }

    @Path(value="importDispoBranch")
    @PUT
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response importDispoBranchByName(@Parameter(description="The Filter state", required=true) @FormParam(value="filterState") String filterState, @Parameter(description="The Branch name", required=true) @FormParam(value="name") String branchName) {
        BranchToken branch = this.dispoApi.getDispoProgramIdByName(branchName);
        this.dispoApi.importAllDispoSets((BranchId)branch, filterState);
        Response.Status status = Response.Status.OK;
        return Response.status((Response.Status)status).build();
    }

    @Path(value="{programName}/set/{setName}/import")
    @PUT
    @Consumes(value={"application/json"})
    public Response putDispoSetByName(@PathParam(value="programName") String programName, @PathParam(value="setName") String setName, String importPath, @QueryParam(value="sourceSet") @DefaultValue(value="") String sourceSet, @QueryParam(value="sourceProgram") @DefaultValue(value="") String sourceProgram) {
        programName = String.format("(DISPO)%s", programName);
        importPath = importPath.replaceAll("\"", "");
        BranchToken programId = this.dispoApi.getDispoProgramIdByName(programName);
        String setId = this.dispoApi.getDispoSetIdByName((BranchId)programId, setName);
        if (setId != null) {
            this.dispoApi.importDispoSet((BranchId)programId, setId);
        } else {
            ArtifactId createdSetId = this.dispoApi.createSet((BranchId)programId, importPath, setName, "");
            setId = this.dispoApi.getDispoSetById((BranchId)programId, ArtifactId.valueOf((Id)createdSetId).getIdString()).getIdString();
            this.dispoApi.importDispoSet((BranchId)programId, setId);
        }
        if (!sourceSet.isEmpty()) {
            String sourceSetId;
            BranchToken sourceProgramId = programId;
            if (!sourceProgram.isEmpty()) {
                sourceProgram = String.format("(DISPO)%s", sourceProgram);
                sourceProgramId = this.dispoApi.getDispoProgramIdByName(sourceProgram);
                sourceSetId = this.dispoApi.getDispoSetIdByName((BranchId)sourceProgramId, sourceSet);
            } else {
                sourceSetId = this.dispoApi.getDispoSetIdByName((BranchId)programId, sourceSet);
            }
            if (sourceSetId != null) {
                CopySetParams params = new CopySetParams();
                params.setAnnotationParam(CopySetParamOption.OVERRIDE);
                params.setCategoryParam(CopySetParamOption.OVERRIDE_EMPTY);
                params.setAssigneeParam(CopySetParamOption.OVERRIDE_EMPTY);
                params.setNoteParam(CopySetParamOption.OVERRIDE_EMPTY);
                params.setAllowOnlyValidResolutionTypes(false);
                this.dispoApi.copyDispoSet((BranchId)programId, setId, (BranchId)sourceProgramId, sourceSetId, params);
            } else {
                return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)String.format("Data Import Successful. Failed to import manual dispositions from [%s].", sourceSet)).build();
            }
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @Path(value="{programName}/set/{setName}/project/{projectId}/job/{jobId}/import")
    @PUT
    @Consumes(value={"application/json"})
    public Response puttDispoSetByName(@PathParam(value="programName") String programName, @PathParam(value="setName") String setName, @PathParam(value="projectId") String projectId, @PathParam(value="jobId") String jobId, String partition) {
        if (!programName.contains("(DISPO)")) {
            programName = String.format("(DISPO)%s", programName);
        }
        String coverageImportApi = String.format("projects/%s/jobs/%s/artifacts/", projectId, jobId);
        BranchToken programId = this.dispoApi.getDispoProgramIdByName(programName);
        String setId = this.dispoApi.getDispoSetIdByName((BranchId)programId, setName);
        if (setId != null) {
            this.dispoApi.importDispoSet((BranchId)programId, setId, coverageImportApi, partition);
        } else {
            ArtifactId createdSetId = this.dispoApi.createSet((BranchId)programId, coverageImportApi, setName, partition);
            setId = this.dispoApi.getDispoSetById((BranchId)programId, ArtifactId.valueOf((Id)createdSetId).getIdString()).getIdString();
            this.dispoApi.importDispoSet((BranchId)programId, setId);
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @Path(value="{programName}/set/{setName}/sourceProgram/{sourceProgramName}/sourceSet/{sourceSetName}/merge")
    @PUT
    @Consumes(value={"application/json"})
    public Response puttDispoSetByName(@PathParam(value="programName") String programName, @PathParam(value="setName") String setName, @PathParam(value="sourceProgramName") String sourceProgramName, @PathParam(value="sourceSetName") String sourceSetName) {
        if (!programName.contains("(DISPO)")) {
            programName = String.format("(DISPO)%s", programName);
        }
        BranchToken programId = this.dispoApi.getDispoProgramIdByName(programName);
        String setId = this.dispoApi.getDispoSetIdByName((BranchId)programId, setName);
        if (!sourceProgramName.contains("(DISPO)")) {
            sourceProgramName = String.format("(DISPO)%s", sourceProgramName);
        }
        BranchToken sourceProgramId = this.dispoApi.getDispoProgramIdByName(sourceProgramName);
        String sourceSetId = this.dispoApi.getDispoSetIdByName((BranchId)sourceProgramId, sourceSetName);
        if (setId != null) {
            if (sourceSetId == null) {
                return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)String.format("Failed to find set [%s] on branch [%s].", sourceSetName, sourceProgramName)).build();
            }
        } else {
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)String.format("Failed to find set [%s] on branch [%s].", setName, programName)).build();
        }
        CopySetParams params = new CopySetParams();
        params.setAnnotationParam(CopySetParamOption.OVERRIDE);
        params.setCategoryParam(CopySetParamOption.OVERRIDE_EMPTY);
        params.setAssigneeParam(CopySetParamOption.OVERRIDE_EMPTY);
        params.setNoteParam(CopySetParamOption.OVERRIDE_EMPTY);
        params.setAllowOnlyValidResolutionTypes(false);
        this.dispoApi.copyDispoSet((BranchId)programId, setId, (BranchId)sourceProgramId, sourceSetId, params);
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @Path(value="{programName}/scripts")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String getTestScripts(@PathParam(value="programName") String programName) {
        programName = String.format("(DISPO)%s", programName);
        BranchToken programId = this.dispoApi.getDispoProgramIdByName(programName);
        return String.join((CharSequence)"\n", this.dispoApi.getTestScripts((BranchId)programId));
    }

    @Path(value="{programName}/set/{setName}/scripts")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String getTestScripts(@PathParam(value="programName") String programName, @PathParam(value="setName") String setName) {
        BranchToken programId = this.dispoApi.getDispoProgramIdByName(programName = String.format("(DISPO)%s", programName));
        String setId = this.dispoApi.getDispoSetIdByName((BranchId)programId, setName);
        if (setId != null) {
            return String.join((CharSequence)"\n", this.dispoApi.getTestScripts((BranchId)programId, setId));
        }
        return "";
    }

    @Path(value="{programName}/exportAll")
    @GET
    @RolesAllowed(value={"dispoAdmin"})
    @Produces(value={"application/octet-stream"})
    public Response exportAllDispoSets(@PathParam(value="programName") String programName) {
        ExportSet writer = new ExportSet(this.dispoApi);
        BranchToken programId = this.dispoApi.getDispoProgramIdByName(String.format("(DISPO)%s", programName));
        List<DispoSet> dispoSets = this.dispoApi.getDispoSets((BranchId)programId, "codeCoverage");
        Date date = new Date();
        String newstring = new SimpleDateFormat("yyyy-MM-dd").format(date);
        String zipName = String.format("%s_%s.zip", programName, newstring);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            Throwable throwable = null;
            Object var10_12 = null;
            try (FileOutputStream fos = new FileOutputStream(zipName);){
                baos.writeTo(fos);
                ZipOutputStream zos = new ZipOutputStream(baos);
                for (DispoSet dispoSet : dispoSets) {
                    if (dispoSet.getImportState().equalsIgnoreCase("NONE")) continue;
                    String fileName = String.format("%s_%s.xml", dispoSet.getName(), newstring);
                    zos.putNextEntry(new ZipEntry(fileName));
                    zos.write(writer.runCoverageReports((BranchId)programId, dispoSet, "detailed", fileName).toByteArray());
                    zos.closeEntry();
                }
                baos.close();
                zos.close();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            throw new OseeCoreException((Throwable)ex);
        }
        String contentDisposition = String.format("attachment; filename=\"%s\"; creation-date=\"%s\"", zipName, new Date());
        return Response.ok((Object)baos.toByteArray()).header("Content-Disposition", (Object)contentDisposition).type("application/zip").build();
    }

    @GET
    @Path(value="{programName}/sets")
    @Produces(value={"application/json"})
    public String getAllDispoSets(@PathParam(value="programName") String programName) {
        BranchToken programId = this.dispoApi.getDispoProgramIdByName(String.format("(DISPO)%s", programName));
        List<String> allDispoSets = this.dispoApi.getDispoSetNames((BranchId)programId, "codeCoverage");
        return String.join((CharSequence)"\n", allDispoSets);
    }

    @Path(value="{branchId}/set")
    public DispoSetEndpoint getAnnotation(@Parameter(description="The Branch ID", required=true) @PathParam(value="branchId") BranchId branch) {
        return new DispoSetEndpoint(this.dispoApi, branch);
    }

    @Path(value="{branchId}/admin")
    public DispoAdminEndpoint getDispoSetReport(@Parameter(description="The Branch ID", required=true) @PathParam(value="branchId") BranchId branch) {
        return new DispoAdminEndpoint(this.dispoApi, branch);
    }

    @Path(value="{branchId}/config")
    public DispoConfigEndpoint getDispoDataStore(@Parameter(description="The Branch ID", required=true) @PathParam(value="branchId") BranchId branch) {
        return new DispoConfigEndpoint(this.dispoApi, branch);
    }
}

