/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.disposition.rest.internal.report;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.disposition.model.DispoAnnotationData;
import org.eclipse.osee.disposition.model.DispoConfig;
import org.eclipse.osee.disposition.model.DispoItem;
import org.eclipse.osee.disposition.model.DispoSet;
import org.eclipse.osee.disposition.model.ResolutionMethod;
import org.eclipse.osee.disposition.rest.DispoApi;
import org.eclipse.osee.disposition.rest.internal.DispoConnector;
import org.eclipse.osee.disposition.rest.internal.LocationRangesCompressor;
import org.eclipse.osee.disposition.rest.util.DispoUtil;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.jdk.core.util.io.xml.ExcelXmlWriter;

public class ExportSet {
    private final DispoApi dispoApi;
    Map<CoverageLevel, WrapInt> levelToTotalCount = new HashMap<CoverageLevel, WrapInt>();
    Map<CoverageLevel, WrapInt> levelToCoveredTotalCount = new HashMap<CoverageLevel, WrapInt>();
    Map<String, Integer> defaultCases = new HashMap<String, Integer>();
    private final String LEVEL_A_LOCATION_PATTERN = "\\s*\\d+\\.\\d+\\s*\\(P[a-z]\\)\\s*$";
    private final String LEVEL_A_SUB_LOCATION_PATTERN = "\\s*\\d+\\.\\d+\\s*\\(P[a-z]\\)\\.\\d+$";
    private final String LEVEL_B_LOCATION_PATTERN = "(.*?RESULT.*|\\s*\\d+\\s*\\.\\s*(T|F).*)";

    public ExportSet(DispoApi dispoApi) {
        this.dispoApi = dispoApi;
    }

    public void runDispoReport(BranchId branch, DispoSet setPrimary, String option, OutputStream outputStream, String fileName) {
        List<DispoItem> items = this.dispoApi.getDispoItems(branch, (String)setPrimary.getGuid(), true);
        try {
            ExcelXmlWriter sheetWriter;
            if (fileName != "") {
                sheetWriter = new ExcelXmlWriter(fileName, null);
            } else {
                OutputStreamWriter writer = new OutputStreamWriter(outputStream, "UTF-8");
                sheetWriter = new ExcelXmlWriter((Writer)writer);
            }
            Object[] headers = this.getHeadersDetailed();
            int columns = headers.length;
            sheetWriter.startSheet(setPrimary.getName(), headers.length);
            sheetWriter.writeRow(headers);
            for (DispoItem item : items) {
                DispoConnector connector = new DispoConnector();
                List<String> allUncoveredDiscprepancies = connector.getAllUncoveredDiscrepancies(item);
                List<Integer> allUncoveredDiscrepanciesAsInts = this.getDiscrepanciesAsInts(allUncoveredDiscprepancies);
                Object[] row = new String[columns];
                int index = 0;
                Map discrepanciesList = item.getDiscrepanciesList();
                row[index++] = String.valueOf(item.getName());
                row[index++] = String.valueOf(item.getCategory());
                row[index++] = String.valueOf(item.getStatus());
                row[index++] = String.valueOf(item.getTotalPoints());
                row[index++] = String.valueOf(item.getDiscrepanciesList().size());
                row[index++] = String.valueOf(DispoUtil.discrepanciesToString(discrepanciesList));
                row[index++] = String.valueOf(allUncoveredDiscprepancies.size());
                String uncoveredDiscrepancies = allUncoveredDiscrepanciesAsInts.isEmpty() ? DispoUtil.listToString(allUncoveredDiscprepancies) : LocationRangesCompressor.compress(allUncoveredDiscrepanciesAsInts);
                List annotations = item.getAnnotationsList();
                Collections.sort(annotations, new Comparator<DispoAnnotationData>(){

                    @Override
                    public int compare(DispoAnnotationData o1, DispoAnnotationData o2) {
                        return o1.getLocationRefs().compareTo(o2.getLocationRefs());
                    }
                });
                row[index++] = String.valueOf(uncoveredDiscrepancies);
                row[index++] = String.valueOf(item.getAssignee());
                row[index++] = String.valueOf(item.getTeam());
                row[index++] = String.valueOf(item.getItemNotes());
                row[index++] = String.valueOf(item.getNeedsRerun());
                row[index++] = String.valueOf(item.getAborted());
                row[index++] = String.valueOf(item.getMachine());
                row[index++] = String.valueOf(item.getElapsedTime());
                row[index++] = String.valueOf(item.getCreationDate());
                row[index++] = String.valueOf(item.getLastUpdate());
                row[index++] = String.valueOf(item.getVersion());
                row[index++] = String.valueOf(this.prettifyAnnotations(annotations));
                sheetWriter.writeRow(row);
            }
            sheetWriter.endSheet();
            sheetWriter.endWorkbook();
        }
        catch (Exception ex) {
            throw new OseeCoreException((Throwable)ex);
        }
    }

    public ByteArrayOutputStream runCoverageReports(BranchId branch, DispoSet setPrimary, String option, String fileName) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (FileOutputStream fos = new FileOutputStream(fileName);){
                baos.writeTo(fos);
                this.runCoverageReport(branch, setPrimary, option, baos, "");
                baos.close();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            throw new OseeCoreException((Throwable)ex);
        }
        return baos;
    }

    /*
     * WARNING - void declaration
     */
    public void runCoverageReport(BranchId branch, DispoSet setPrimary, String option, OutputStream outputStream, String fileName) {
        HashMap<String, String> resolutionsValueToText = new HashMap<String, String>();
        HashSet<CoverageLevel> levelsInSet = new HashSet<CoverageLevel>();
        ArrayList<CoverageLevel> levelsInList = new ArrayList<CoverageLevel>();
        HashMap<CoverageLevel, Map<String, Pair<WrapInt, WrapInt>>> leveltoUnitToCovered = new HashMap<CoverageLevel, Map<String, Pair<WrapInt, WrapInt>>>();
        CoverageLevel[] coverageLevelArray = CoverageLevel.values();
        int n = coverageLevelArray.length;
        int n2 = 0;
        while (n2 < n) {
            CoverageLevel level = coverageLevelArray[n2];
            leveltoUnitToCovered.put(level, new HashMap());
            this.levelToTotalCount.put(level, new WrapInt(0));
            this.levelToCoveredTotalCount.put(level, new WrapInt(0));
            ++n2;
        }
        List<DispoItem> items = this.dispoApi.getDispoItems(branch, (String)setPrimary.getGuid(), true);
        HashMap<CoverageLevel, Map<String, WrapInt>> levelToResolutionTypesToCount = new HashMap<CoverageLevel, Map<String, WrapInt>>();
        DispoConfig config = this.dispoApi.getDispoConfig(branch);
        config.getValidResolutions();
        CoverageLevel[] coverageLevelArray2 = CoverageLevel.values();
        int n3 = coverageLevelArray2.length;
        int n4 = 0;
        while (n4 < n3) {
            CoverageLevel level = coverageLevelArray2[n4];
            Iterator<DispoItem> innerMap = new HashMap<String, WrapInt>();
            for (ResolutionMethod resolutionType : config.getValidResolutions()) {
                innerMap.put(resolutionType.getText(), new WrapInt(0));
                resolutionsValueToText.put(resolutionType.getValue(), resolutionType.getText());
                if (!level.equals((Object)CoverageLevel.A) || resolutionType.getValue().isEmpty() || resolutionType.getValue().equals("Test_Script")) continue;
                String levelAResolutionType = String.format("%s/Test_Script", resolutionType.getValue());
                innerMap.put(levelAResolutionType, new WrapInt(0));
                resolutionsValueToText.put(levelAResolutionType, levelAResolutionType);
            }
            if (level.equals((Object)CoverageLevel.A)) {
                innerMap.put("MIXED", new WrapInt(0));
            }
            levelToResolutionTypesToCount.put(level, (Map<String, WrapInt>)((Object)innerMap));
            ++n4;
        }
        try {
            void var22_36;
            ExcelXmlWriter sheetWriter;
            if (fileName != "") {
                sheetWriter = new ExcelXmlWriter(fileName, null);
            } else {
                OutputStreamWriter writer = new OutputStreamWriter(outputStream, "UTF-8");
                sheetWriter = new ExcelXmlWriter((Writer)writer);
            }
            Object[] headers = this.getHeadersCoverage();
            int columns = headers.length;
            sheetWriter.startSheet(setPrimary.getName(), headers.length);
            sheetWriter.writeRow(headers);
            for (DispoItem item : items) {
                List annotations = item.getAnnotationsList();
                Collections.sort(annotations, new Comparator<DispoAnnotationData>(){

                    @Override
                    public int compare(DispoAnnotationData o1, DispoAnnotationData o2) {
                        return o1.getLocationRefs().compareTo(o2.getLocationRefs());
                    }
                });
                HashMap<String, Boolean> mcdcBranchCoverage = new HashMap<String, Boolean>();
                HashMap itemWithPairs = new HashMap();
                HashMap hitForLevelC = new HashMap();
                for (DispoAnnotationData dispoAnnotationData : annotations) {
                    String annotationLocRef = dispoAnnotationData.getLocationRefs();
                    if (annotationLocRef.contains(".")) {
                        HashMap<Boolean, String> coverageAndResolutionLevelC = new HashMap<Boolean, String>();
                        int dotIndex = annotationLocRef.indexOf(".");
                        String string = annotationLocRef.substring(0, dotIndex);
                        if (dispoAnnotationData.isResolutionValid()) {
                            coverageAndResolutionLevelC.put(true, dispoAnnotationData.getResolutionType());
                            hitForLevelC.put(string, coverageAndResolutionLevelC);
                        } else if (!dispoAnnotationData.isResolutionValid() && !hitForLevelC.containsKey(string)) {
                            coverageAndResolutionLevelC.put(false, dispoAnnotationData.getResolutionType());
                            hitForLevelC.put(string, coverageAndResolutionLevelC);
                        }
                    }
                    try {
                        int dotIndex;
                        if (annotationLocRef.contains("(P") && !dispoAnnotationData.getIsPairAnnotation()) {
                            Pattern pairsPattern = Pattern.compile(".*\\[\\s*(\\d+)\\s*/\\s*(\\d+)\\s*.*\\]");
                            Matcher matcher = pairsPattern.matcher(dispoAnnotationData.getSatisfiedPairs());
                            ArrayList<Integer> arrayList = new ArrayList<Integer>();
                            if (matcher.find()) {
                                arrayList.add(Integer.parseInt(matcher.group(1)));
                                arrayList.add(Integer.parseInt(matcher.group(2)));
                            } else {
                                matcher = pairsPattern.matcher(dispoAnnotationData.getPossiblePairs());
                                if (matcher.find()) {
                                    arrayList.add(Integer.parseInt(matcher.group(1)));
                                    arrayList.add(Integer.parseInt(matcher.group(2)));
                                }
                            }
                            itemWithPairs.put(annotationLocRef, arrayList);
                            if (dispoAnnotationData.getIsResolutionValid()) {
                                mcdcBranchCoverage.put(annotationLocRef, true);
                                this.uptickCoverage((Map)levelToResolutionTypesToCount.get((Object)CoverageLevel.B), (Map)leveltoUnitToCovered.get((Object)CoverageLevel.B), this.levelToCoveredTotalCount.get((Object)CoverageLevel.B), this.getNormalizedName(item.getName()), dispoAnnotationData.getResolutionType());
                                this.uptickCoverage((Map)levelToResolutionTypesToCount.get((Object)CoverageLevel.B), (Map)leveltoUnitToCovered.get((Object)CoverageLevel.B), this.levelToCoveredTotalCount.get((Object)CoverageLevel.B), this.getNormalizedName(item.getName()), dispoAnnotationData.getResolutionType());
                            } else {
                                mcdcBranchCoverage.put(annotationLocRef, false);
                            }
                        } else if (dispoAnnotationData.getIsPairAnnotation() && (dotIndex = annotationLocRef.lastIndexOf(".")) != -1) {
                            String parentLocRef = annotationLocRef.substring(0, dotIndex);
                            if (!((Boolean)mcdcBranchCoverage.get(parentLocRef)).booleanValue() && dispoAnnotationData.getIsResolutionValid()) {
                                mcdcBranchCoverage.put(parentLocRef, true);
                                this.uptickCoverage((Map)levelToResolutionTypesToCount.get((Object)CoverageLevel.B), (Map)leveltoUnitToCovered.get((Object)CoverageLevel.B), this.levelToCoveredTotalCount.get((Object)CoverageLevel.B), this.getNormalizedName(item.getName()), dispoAnnotationData.getResolutionType());
                            }
                            if (!((List)itemWithPairs.get(parentLocRef)).contains(dispoAnnotationData.getRow())) {
                                continue;
                            }
                        }
                    }
                    catch (Exception exception) {}
                    this.writeRowAnnotation(sheetWriter, columns, item, dispoAnnotationData, setPrimary.getName(), levelToResolutionTypesToCount, leveltoUnitToCovered, levelsInSet);
                }
                for (Map.Entry entry : hitForLevelC.entrySet()) {
                    for (Map.Entry LevelCAdditionalCoverage : ((Map)entry.getValue()).entrySet()) {
                        this.levelToTotalCount.get((Object)CoverageLevel.C).inc();
                        if (!((Boolean)LevelCAdditionalCoverage.getKey()).booleanValue()) continue;
                        this.uptickCoverage((Map)levelToResolutionTypesToCount.get((Object)CoverageLevel.C), (Map)leveltoUnitToCovered.get((Object)CoverageLevel.C), this.levelToCoveredTotalCount.get((Object)CoverageLevel.C), this.getNormalizedName(item.getName()), (String)LevelCAdditionalCoverage.getValue());
                    }
                }
            }
            levelsInList.addAll(levelsInSet);
            Collections.sort(levelsInList);
            if (levelsInList.contains((Object)CoverageLevel.B)) {
                for (DispoItem item : items) {
                    this.levelToTotalCount.get((Object)CoverageLevel.B).inc();
                    this.uptickCoverage((Map)levelToResolutionTypesToCount.get((Object)CoverageLevel.B), (Map)leveltoUnitToCovered.get((Object)CoverageLevel.B), this.levelToCoveredTotalCount.get((Object)CoverageLevel.B), this.getNormalizedName(item.getName()), "Test_Script");
                }
            }
            sheetWriter.endSheet();
            sheetWriter.startSheet("Cover Sheet", headers.length);
            ArrayList<String> coverSheetHeadersList = new ArrayList<String>();
            coverSheetHeadersList.add(" ");
            if (levelsInList.contains((Object)CoverageLevel.A)) {
                coverSheetHeadersList.add("MCDC");
            }
            if (levelsInList.contains((Object)CoverageLevel.B)) {
                coverSheetHeadersList.add("Branch");
            }
            if (levelsInList.contains((Object)CoverageLevel.C)) {
                coverSheetHeadersList.add("Statement");
            }
            Object[] coverSheetHeaders = coverSheetHeadersList.toArray();
            sheetWriter.writeRow(coverSheetHeaders);
            Object[] row = new String[CoverageLevel.values().length + 1];
            Object[] uncoveredRow = new String[CoverageLevel.values().length + 1];
            row[0] = "All Coverage Methods";
            uncoveredRow[0] = "Uncovered";
            int index = 1;
            for (CoverageLevel coverageLevel : levelsInList) {
                row[index] = this.getPercent(this.levelToCoveredTotalCount.get((Object)coverageLevel).getValue(), this.levelToTotalCount.get((Object)coverageLevel).getValue(), false);
                Integer uncovered = this.levelToTotalCount.get((Object)coverageLevel).getValue() - this.levelToCoveredTotalCount.get((Object)coverageLevel).getValue();
                int emptyCount = 0;
                if (((Map)levelToResolutionTypesToCount.get((Object)coverageLevel)).containsKey(" ")) {
                    emptyCount = ((WrapInt)((Map)levelToResolutionTypesToCount.get((Object)coverageLevel)).get(" ")).getValue();
                }
                uncoveredRow[index++] = this.getPercent(uncovered + emptyCount, this.levelToTotalCount.get((Object)coverageLevel).getValue(), false);
            }
            sheetWriter.writeRow(row);
            if (levelsInList.contains((Object)CoverageLevel.A)) {
                Set set = ((Map)levelToResolutionTypesToCount.get((Object)CoverageLevel.A)).keySet();
            } else if (levelsInList.contains((Object)CoverageLevel.B)) {
                Set set = ((Map)levelToResolutionTypesToCount.get((Object)CoverageLevel.B)).keySet();
            } else {
                Set set = ((Map)levelToResolutionTypesToCount.get((Object)CoverageLevel.C)).keySet();
            }
            List<String> orderedResolutionTypes = this.organizeResolutions((Set<String>)var22_36);
            for (String resolution : orderedResolutionTypes) {
                int index1 = 0;
                Object object = row[index1++] = resolutionsValueToText.containsKey(resolution) ? (String)resolutionsValueToText.get(resolution) : resolution;
                if (((String)row[0]).equals(" ")) continue;
                for (CoverageLevel coverageLevel : levelsInList) {
                    row[index1++] = resolution.contains("/") && index1 > 1 ? "" : (((Map)levelToResolutionTypesToCount.get((Object)coverageLevel)).get(resolution) == null ? "ERROR" : this.getPercent(((WrapInt)((Map)levelToResolutionTypesToCount.get((Object)coverageLevel)).get(resolution)).getValue(), this.levelToTotalCount.get((Object)coverageLevel).getValue(), false));
                }
                sheetWriter.writeRow(row);
            }
            if (!this.defaultCases.isEmpty()) {
                HashMap<CoverageLevel, Integer> levelToMixed = new HashMap<CoverageLevel, Integer>();
                int index1 = 0;
                row[index1++] = "MIXED - Expanded Below";
                Iterator it = levelsInList.iterator();
                while (it.hasNext()) {
                    CoverageLevel coverageLevel = (CoverageLevel)((Object)it.next());
                    if (((Map)levelToResolutionTypesToCount.get((Object)coverageLevel)).get("MIXED") == null) {
                        row[index1++] = "ERROR";
                        continue;
                    }
                    row[index1++] = String.valueOf(this.getPercent(((WrapInt)((Map)levelToResolutionTypesToCount.get((Object)coverageLevel)).get("MIXED")).getValue(), this.levelToTotalCount.get((Object)coverageLevel).getValue(), false)) + " - Expanded Below";
                    levelToMixed.put(coverageLevel, ((WrapInt)((Map)levelToResolutionTypesToCount.get((Object)coverageLevel)).get("MIXED")).getValue());
                }
                sheetWriter.writeRow(row);
                for (Map.Entry<String, Integer> entry : this.defaultCases.entrySet()) {
                    int index2 = 0;
                    row[index2++] = entry.getKey();
                    Iterator it2 = levelsInList.iterator();
                    while (it.hasNext()) {
                        CoverageLevel lvl = (CoverageLevel)((Object)it2.next());
                        row[index2++] = this.getPercent(entry.getValue(), (Integer)levelToMixed.get((Object)lvl), false);
                    }
                    sheetWriter.writeRow(row);
                }
            }
            sheetWriter.writeRow(uncoveredRow);
            sheetWriter.endSheet();
            Object[] summarySheetHeaders = this.getHeadersSummarySheet();
            columns = summarySheetHeaders.length;
            sheetWriter.startSheet("Summary Sheet", columns);
            sheetWriter.writeRow(summarySheetHeaders);
            Object[] row2 = new String[columns];
            Set units = ((Map)leveltoUnitToCovered.get((Object)CoverageLevel.A)).keySet();
            if (units.isEmpty()) {
                units = ((Map)leveltoUnitToCovered.get((Object)CoverageLevel.C)).keySet();
            }
            index = 0;
            for (String string : units) {
                index = 0;
                row2[index++] = string;
                CoverageLevel[] coverageLevelArray3 = CoverageLevel.values();
                int lvl = coverageLevelArray3.length;
                int it2 = 0;
                while (it2 < lvl) {
                    CoverageLevel level = coverageLevelArray3[it2];
                    Map unitToCovered = (Map)leveltoUnitToCovered.get((Object)level);
                    if (!unitToCovered.isEmpty() && unitToCovered.containsKey(string)) {
                        Pair coveredOverTotal = (Pair)unitToCovered.get(string);
                        int covered = ((WrapInt)coveredOverTotal.getFirst()).getValue();
                        int total = ((WrapInt)coveredOverTotal.getSecond()).getValue();
                        row2[index++] = String.valueOf(covered);
                        row2[index++] = String.valueOf(total);
                        Double percent = (double)covered / (double)total * 100.0;
                        row2[index++] = String.format("%2.2f%%", percent);
                    } else {
                        row2[index++] = " ";
                        row2[index++] = " ";
                        row2[index++] = " ";
                    }
                    ++it2;
                }
                sheetWriter.writeRow(row2);
            }
            sheetWriter.endSheet();
            Object[] objectArray = new Object[]{"Unit", "Code Line", "Resolution Type", "Script Name", "Script Path", "Script Notes"};
            sheetWriter.startSheet("Test Script Sheet", objectArray.length);
            sheetWriter.writeRow(objectArray);
            for (DispoItem dispoItem : items) {
                List annotations = dispoItem.getAnnotationsList();
                Collections.sort(annotations, new Comparator<DispoAnnotationData>(){

                    @Override
                    public int compare(DispoAnnotationData o1, DispoAnnotationData o2) {
                        return o1.getLocationRefs().compareTo(o2.getLocationRefs());
                    }
                });
                for (DispoAnnotationData annotation : annotations) {
                    if (!annotation.getResolutionType().equals("Test_Script")) continue;
                    HashMap<String, String> testNameToPath = DispoUtil.splitTestScriptNameAndPath(Collections.singletonList(annotation));
                    sheetWriter.writeRow(new Object[]{dispoItem.getName(), annotation.getLocationRefs(), annotation.getResolutionType(), testNameToPath.keySet(), testNameToPath.values(), annotation.getResolution()});
                }
            }
            sheetWriter.endSheet();
            sheetWriter.endWorkbook();
        }
        catch (Exception ex) {
            throw new OseeCoreException((Throwable)ex);
        }
    }

    public void runCoverageSummaryReport(BranchId branch, DispoSet setPrimary, HashMap<String, Object> jsonObject) {
        HashMap<String, String> resolutionsValueToText = new HashMap<String, String>();
        HashSet<CoverageLevel> levelsInSet = new HashSet<CoverageLevel>();
        ArrayList<CoverageLevel> levelsInList = new ArrayList<CoverageLevel>();
        HashMap<CoverageLevel, Map<String, Pair<WrapInt, WrapInt>>> leveltoUnitToCovered = new HashMap<CoverageLevel, Map<String, Pair<WrapInt, WrapInt>>>();
        CoverageLevel[] coverageLevelArray = CoverageLevel.values();
        int n = coverageLevelArray.length;
        int n2 = 0;
        while (n2 < n) {
            CoverageLevel level = coverageLevelArray[n2];
            leveltoUnitToCovered.put(level, new HashMap());
            this.levelToTotalCount.put(level, new WrapInt(0));
            this.levelToCoveredTotalCount.put(level, new WrapInt(0));
            ++n2;
        }
        List<DispoItem> items = this.dispoApi.getDispoItems(branch, (String)setPrimary.getGuid(), true);
        HashMap<CoverageLevel, Map<String, WrapInt>> levelToResolutionTypesToCount = new HashMap<CoverageLevel, Map<String, WrapInt>>();
        DispoConfig config = this.dispoApi.getDispoConfig(branch);
        config.getValidResolutions();
        CoverageLevel[] coverageLevelArray2 = CoverageLevel.values();
        int n3 = coverageLevelArray2.length;
        int n4 = 0;
        while (n4 < n3) {
            CoverageLevel level = coverageLevelArray2[n4];
            HashMap<String, WrapInt> innerMap = new HashMap<String, WrapInt>();
            for (ResolutionMethod resolutionType : config.getValidResolutions()) {
                innerMap.put(resolutionType.getText(), new WrapInt(0));
                resolutionsValueToText.put(resolutionType.getValue(), resolutionType.getText());
                if (!level.equals((Object)CoverageLevel.A) || resolutionType.getValue().isEmpty() || resolutionType.getValue().equals("Test_Script")) continue;
                String levelAResolutionType = String.format("%s/Test_Script", resolutionType.getValue());
                innerMap.put(levelAResolutionType, new WrapInt(0));
                resolutionsValueToText.put(levelAResolutionType, levelAResolutionType);
            }
            if (level.equals((Object)CoverageLevel.A)) {
                innerMap.put("MIXED", new WrapInt(0));
            }
            levelToResolutionTypesToCount.put(level, innerMap);
            ++n4;
        }
        try {
            for (DispoItem item : items) {
                List annotations = item.getAnnotationsList();
                Collections.sort(annotations, new Comparator<DispoAnnotationData>(){

                    @Override
                    public int compare(DispoAnnotationData o1, DispoAnnotationData o2) {
                        return o1.getLocationRefs().compareTo(o2.getLocationRefs());
                    }
                });
                for (DispoAnnotationData annotation : annotations) {
                    this.writeRowAnnotationSummary(item, annotation, setPrimary.getName(), levelToResolutionTypesToCount, leveltoUnitToCovered, levelsInSet);
                }
            }
            levelsInList.addAll(levelsInSet);
            Collections.sort(levelsInList);
            String[] row = new String[CoverageLevel.values().length + 1];
            String[] uncoveredRow = new String[CoverageLevel.values().length + 1];
            row[0] = "Total_Count";
            int index = 1;
            for (CoverageLevel lvl : levelsInList) {
                Integer totalCount = this.levelToTotalCount.get((Object)lvl).getValue();
                row[index++] = totalCount.toString();
            }
            this.addToJsonObject(levelsInList, row, jsonObject);
            row[0] = "All_Coverage_Methods";
            uncoveredRow[0] = "Uncovered";
            index = 1;
            for (CoverageLevel lvl : levelsInList) {
                Integer coveredCount = this.levelToCoveredTotalCount.get((Object)lvl).getValue();
                row[index] = coveredCount.toString();
                Integer uncoveredCount = this.levelToTotalCount.get((Object)lvl).getValue() - this.levelToCoveredTotalCount.get((Object)lvl).getValue();
                uncoveredRow[index++] = uncoveredCount.toString();
            }
            this.addToJsonObject(levelsInList, row, jsonObject);
            this.addToJsonObject(levelsInList, uncoveredRow, jsonObject);
            Set<String> resolutionTypes = levelsInList.contains((Object)CoverageLevel.A) ? ((Map)levelToResolutionTypesToCount.get((Object)CoverageLevel.A)).keySet() : (levelsInList.contains((Object)CoverageLevel.B) ? ((Map)levelToResolutionTypesToCount.get((Object)CoverageLevel.B)).keySet() : ((Map)levelToResolutionTypesToCount.get((Object)CoverageLevel.C)).keySet());
            List<String> orderedResolutionTypes = this.organizeResolutions(resolutionTypes);
            for (String resolution : orderedResolutionTypes) {
                int index1 = 0;
                row[index1++] = resolutionsValueToText.containsKey(resolution) ? (String)resolutionsValueToText.get(resolution) : resolution;
                for (CoverageLevel lvl : levelsInList) {
                    if (((Map)levelToResolutionTypesToCount.get((Object)lvl)).get(resolution) == null) {
                        row[index1++] = "ERROR";
                        continue;
                    }
                    Integer resolutionCount = ((WrapInt)((Map)levelToResolutionTypesToCount.get((Object)lvl)).get(resolution)).getValue();
                    row[index1++] = resolutionCount.toString();
                }
                this.addToJsonObject(levelsInList, row, jsonObject);
            }
            if (!this.defaultCases.isEmpty()) {
                HashMap<CoverageLevel, Integer> levelToMixed = new HashMap<CoverageLevel, Integer>();
                int index1 = 0;
                row[index1++] = "MIXED - Expanded Below";
                Iterator it = levelsInList.iterator();
                while (it.hasNext()) {
                    CoverageLevel lvl = (CoverageLevel)((Object)it.next());
                    if (((Map)levelToResolutionTypesToCount.get((Object)lvl)).get("MIXED") == null) {
                        row[index1++] = "ERROR";
                        continue;
                    }
                    Integer resolutionCount = ((WrapInt)((Map)levelToResolutionTypesToCount.get((Object)lvl)).get("MIXED")).getValue();
                    row[index1++] = resolutionCount.toString();
                    levelToMixed.put(lvl, ((WrapInt)((Map)levelToResolutionTypesToCount.get((Object)lvl)).get("MIXED")).getValue());
                }
                this.addToJsonObject(levelsInList, row, jsonObject);
                for (Map.Entry<String, Integer> entry : this.defaultCases.entrySet()) {
                    int index2 = 0;
                    row[index2++] = entry.getKey();
                    while (it.hasNext()) {
                        row[index2++] = entry.getValue().toString();
                    }
                    this.addToJsonObject(levelsInList, row, jsonObject);
                }
            }
            this.mergeEmptyAndUncovered(levelsInList, jsonObject);
        }
        catch (Exception ex) {
            throw new OseeCoreException((Throwable)ex);
        }
    }

    private void mergeEmptyAndUncovered(List levelsInList, HashMap<String, Object> jsonObject) {
        HashMap emptyEntry = (HashMap)jsonObject.get(" ");
        HashMap uncoveredEntry = (HashMap)jsonObject.get("Uncovered");
        for (CoverageLevel lvl : levelsInList) {
            Integer value;
            if (lvl.name().equals("A")) {
                value = Integer.parseInt((String)emptyEntry.get("MCDC")) + Integer.parseInt((String)uncoveredEntry.get("MCDC"));
                uncoveredEntry.put("MCDC", value.toString());
                continue;
            }
            if (lvl.name().equals("B")) {
                value = Integer.parseInt((String)emptyEntry.get("Branch")) + Integer.parseInt((String)uncoveredEntry.get("Branch"));
                uncoveredEntry.put("Branch", value.toString());
                continue;
            }
            if (!lvl.name().equals("C")) continue;
            value = Integer.parseInt((String)emptyEntry.get("Statement")) + Integer.parseInt((String)uncoveredEntry.get("Statement"));
            uncoveredEntry.put("Statement", value.toString());
        }
        jsonObject.remove(" ");
    }

    private void addToJsonObject(List<CoverageLevel> levelsInList, String[] row, HashMap<String, Object> jsonObject) {
        HashMap coverageEntry = new HashMap();
        coverageEntry = this.createJsonObject(levelsInList, row);
        jsonObject.put(row[0], coverageEntry);
    }

    private HashMap createJsonObject(List levelsInList, String[] value) {
        HashMap<String, String> jsonObject = new HashMap<String, String>();
        Iterator iterator = levelsInList.iterator();
        int index = 1;
        while (iterator.hasNext()) {
            CoverageLevel lvl = (CoverageLevel)((Object)iterator.next());
            if (lvl.name().equals("A")) {
                jsonObject.put("MCDC", value[index++]);
                continue;
            }
            if (lvl.name().equals("B")) {
                jsonObject.put("Branch", value[index++]);
                continue;
            }
            if (!lvl.name().equals("C")) continue;
            jsonObject.put("Statement", value[index++]);
        }
        return jsonObject;
    }

    private List<Integer> getDiscrepanciesAsInts(List<String> discrepancyLocations) {
        List<Integer> toReturn = new ArrayList<Integer>();
        for (String location : discrepancyLocations) {
            if (DispoUtil.isNumericLocations(location)) {
                toReturn.add(Integer.valueOf(location));
                continue;
            }
            toReturn = Collections.emptyList();
            break;
        }
        return toReturn;
    }

    private String getPercent(int complete, int total, boolean showZero) {
        if (total == 0 || complete == 0) {
            return this.getPercentString(0.0, complete, total, showZero);
        }
        Double percent = complete;
        percent = percent / (double)total;
        percent = percent * 100.0;
        return this.getPercentString(percent, complete, total, showZero);
    }

    private String getPercentString(double percent, int complete, int total, boolean showZero) {
        if (!showZero && percent == 0.0 && complete == 0) {
            return "0%";
        }
        if (percent == 100.0) {
            return String.format("100%% - %d / %d", complete, total);
        }
        if (percent == 0.0) {
            return String.format("0%% - %d / %d", complete, total);
        }
        return String.format("%2.2f%% - %d / %d", percent, complete, total);
    }

    private void writeRowAnnotation(ExcelXmlWriter sheetWriter, int columns, DispoItem item, DispoAnnotationData annotation, String setName, Map<CoverageLevel, Map<String, WrapInt>> levelToResolutionToCount, Map<CoverageLevel, Map<String, Pair<WrapInt, WrapInt>>> levelToUnitsToCovered, Set<CoverageLevel> levelsInSet) throws IOException {
        Object[] row = new String[columns];
        int index = 0;
        row[index++] = this.getNameSpace(item, setName);
        String unit = this.getNormalizedName(item.getName());
        row[index++] = unit;
        row[index++] = item.getName().replaceAll(".*\\.", "");
        row[index++] = String.valueOf(item.getMethodNumber());
        row[index++] = String.valueOf(annotation.getLocationRefs());
        String resolutionType = annotation.getResolutionType();
        if (Strings.isValid((String)resolutionType)) {
            row[index++] = resolutionType;
            String rationale = annotation.getResolution();
            row[index++] = resolutionType.equalsIgnoreCase("Test_Script") || !Strings.isValid((String)rationale) ? "N/A" : rationale;
        } else {
            row[index++] = "Uncovered";
            row[index++] = "N/A";
        }
        sheetWriter.writeRow(row);
        this.calculateTotals(levelToResolutionToCount, levelToUnitsToCovered, unit, resolutionType, annotation.getLocationRefs(), levelsInSet);
    }

    private void writeRowAnnotationSummary(DispoItem item, DispoAnnotationData annotation, String setName, Map<CoverageLevel, Map<String, WrapInt>> levelToResolutionToCount, Map<CoverageLevel, Map<String, Pair<WrapInt, WrapInt>>> levelToUnitsToCovered, Set<CoverageLevel> levelsInSet) {
        String unit = this.getNormalizedName(item.getName());
        String resolutionType = annotation.getResolutionType();
        this.calculateTotals(levelToResolutionToCount, levelToUnitsToCovered, unit, resolutionType, annotation.getLocationRefs(), levelsInSet);
    }

    private void calculateTotals(Map<CoverageLevel, Map<String, WrapInt>> levelToResolutionToCount, Map<CoverageLevel, Map<String, Pair<WrapInt, WrapInt>>> levelToUnitsToCovered, String unit, String resolutionType, String location, Set<CoverageLevel> levelsInSet) {
        CoverageLevel thisAnnotationsLevel = this.getLevel(location);
        switch (thisAnnotationsLevel) {
            case A: {
                levelsInSet.add(CoverageLevel.A);
                levelsInSet.add(CoverageLevel.B);
                levelsInSet.add(CoverageLevel.C);
                this.levelToTotalCount.get((Object)thisAnnotationsLevel).inc();
                this.uptickCoverage(levelToResolutionToCount.get((Object)thisAnnotationsLevel), levelToUnitsToCovered.get((Object)thisAnnotationsLevel), this.levelToCoveredTotalCount.get((Object)thisAnnotationsLevel), unit, resolutionType);
                this.levelToTotalCount.get((Object)CoverageLevel.B).inc();
                this.levelToTotalCount.get((Object)CoverageLevel.B).inc();
                break;
            }
            case B: {
                levelsInSet.add(CoverageLevel.B);
                levelsInSet.add(CoverageLevel.C);
                this.levelToTotalCount.get((Object)thisAnnotationsLevel).inc();
                this.uptickCoverage(levelToResolutionToCount.get((Object)thisAnnotationsLevel), levelToUnitsToCovered.get((Object)thisAnnotationsLevel), this.levelToCoveredTotalCount.get((Object)thisAnnotationsLevel), unit, resolutionType);
                break;
            }
            case C: {
                levelsInSet.add(CoverageLevel.C);
                this.levelToTotalCount.get((Object)thisAnnotationsLevel).inc();
                this.uptickCoverage(levelToResolutionToCount.get((Object)thisAnnotationsLevel), levelToUnitsToCovered.get((Object)thisAnnotationsLevel), this.levelToCoveredTotalCount.get((Object)thisAnnotationsLevel), unit, resolutionType);
                break;
            }
        }
    }

    private void uptickCoverage(Map<String, WrapInt> resolutionTypeToCount, Map<String, Pair<WrapInt, WrapInt>> unitToCovered, WrapInt currentCoveredTotalCount, String unit, String resolutionType) {
        WrapInt count = resolutionTypeToCount.get(resolutionType);
        if (Strings.isValid((String)resolutionType)) {
            if (count == null) {
                resolutionTypeToCount.put(resolutionType, new WrapInt(1));
            } else {
                count.inc();
            }
        }
        Pair<WrapInt, WrapInt> coveredOverTotal = unitToCovered.get(unit);
        int thisUnitsCoveredCount = 0;
        if (Strings.isValid((String)resolutionType) && !this.isTypeAnalyze(resolutionType) && !resolutionType.contains("Modify")) {
            thisUnitsCoveredCount = 1;
            currentCoveredTotalCount.inc();
        }
        if (coveredOverTotal == null) {
            Pair newCount = new Pair((Object)new WrapInt(thisUnitsCoveredCount), (Object)new WrapInt(1));
            unitToCovered.put(unit, (Pair<WrapInt, WrapInt>)newCount);
        } else {
            ((WrapInt)coveredOverTotal.getFirst()).inc(thisUnitsCoveredCount);
            ((WrapInt)coveredOverTotal.getSecond()).inc();
        }
    }

    private boolean isTypeAnalyze(String resolutionType) {
        return resolutionType.equals("Modify_Code") || resolutionType.equals("Modify_Test") || resolutionType.equals("Modify_Reqt") || resolutionType.equals("Modify_Tooling") || resolutionType.equals("Modify_Work_Product");
    }

    private CoverageLevel getLevel(String location) {
        if (location.matches("\\s*\\d+\\.\\d+\\s*\\(P[a-z]\\)\\s*$")) {
            return CoverageLevel.A;
        }
        if (location.matches("(.*?RESULT.*|\\s*\\d+\\s*\\.\\s*(T|F).*)") || location.matches("\\s*\\d+\\.\\d+\\s*\\(P[a-z]\\)\\.\\d+$")) {
            return CoverageLevel.B;
        }
        return CoverageLevel.C;
    }

    private String getNormalizedName(String fullName) {
        if (fullName.contains(".2.ada")) {
            return fullName.replaceAll("\\.2\\.ada.*", ".2.ada");
        }
        return fullName.replaceAll("\\.c.*", ".c");
    }

    private String getNameSpace(DispoItem item, String setName) {
        Pattern pattern = Pattern.compile(".*?(\\..*?){1,}\\.2\\.ada");
        Matcher matcher = pattern.matcher(item.getName());
        StringBuilder nameSpace = new StringBuilder(setName);
        if (matcher.find()) {
            String str = matcher.group();
            Pattern pattern2 = Pattern.compile(".*\\.");
            Matcher matcher2 = pattern2.matcher(str.replaceAll("\\.2.*", ""));
            if (matcher2.find()) {
                nameSpace.append(".");
                String toAdd = matcher2.group();
                nameSpace.append(toAdd.substring(0, toAdd.length() - 1));
            }
        }
        return nameSpace.toString();
    }

    private String prettifyAnnotations(List<DispoAnnotationData> annotations) {
        StringBuilder sb = new StringBuilder();
        for (DispoAnnotationData annotation : annotations) {
            sb.append(annotation.getLocationRefs());
            sb.append(":");
            sb.append(annotation.getResolution());
            sb.append("\n");
        }
        return sb.toString();
    }

    private List<String> organizeResolutions(Set<String> resolutionTypes) {
        String[] toRemove = new String[]{"Test Script", "MIXED", ""};
        ArrayList<String> tempResolutionTypes = new ArrayList<String>(resolutionTypes);
        String[] stringArray = toRemove;
        int n = toRemove.length;
        int n2 = 0;
        while (n2 < n) {
            String coverageMethod = stringArray[n2];
            if (tempResolutionTypes.contains(coverageMethod)) {
                tempResolutionTypes.remove(coverageMethod);
            }
            ++n2;
        }
        ArrayList<String> orderedResolutionTypes = new ArrayList<String>();
        String[] stringArray2 = this.coverageMethodList();
        int n3 = stringArray2.length;
        n = 0;
        while (n < n3) {
            String coverageMethod = stringArray2[n];
            if (tempResolutionTypes.contains(coverageMethod) || coverageMethod.isEmpty()) {
                orderedResolutionTypes.add(coverageMethod);
                tempResolutionTypes.remove(coverageMethod);
            }
            ++n;
        }
        for (String coverageMethod : tempResolutionTypes) {
            orderedResolutionTypes.add(coverageMethod);
        }
        return orderedResolutionTypes;
    }

    private String[] getHeadersDetailed() {
        String[] toReturn = new String[]{"Script Name", "Category", "Status", "Total Test Points", "Failures", "Failed Points", "Remaining Count", "Remaining Points", "Assignee", "Team", "Item Notes", "Needs Rerun", "Aborted", "Station", "Elapsed Time", "Creation Date", "Last Updated", "Version", "Dispositions"};
        return toReturn;
    }

    private String[] getHeadersCoverage() {
        String[] toReturn = new String[]{"Namespace", "Parent Coverage Unit", "Unit", "Method Number", "Execution Line Number", "Coverage Method", "Coverage Rationale"};
        return toReturn;
    }

    private String[] getHeadersSummarySheet() {
        String[] toReturn = new String[]{"Unit", "MCDC Pairs Covered", "MCDC Pairs Total", "MCDC Pairs % Coverage", "Branches Covered", "Branches Total", "Branches % Coverage", "Statement Lines Covered", "Statement Lines Total", "Statement Lines % Coverage"};
        return toReturn;
    }

    private String[] coverageMethodList() {
        String[] toReturn = new String[]{"Test_Script", "Defensive_Programming", "Exception_Handling", "Analysis", "Deactivated_Ada_console_command", "Deactivated_Code", "Deactivated_Compile_Time", "Deactivated_Engineering_test_page", "Deactivated_EXT_ATE_PRESENT", "Deactivated_Ground_testing_only", "Deactivated_IN_AIR_OR_ENG_ON", "Deactivated_INTEGRITY_serial_console_command", "Deactivated_J4_Connector", "Deactivated_Remote_SW_test_page", "Defensive_Programming/Test_Script", "Exception_Handling/Test_Script", "Analysis/Test_Script", "Deactivated_Ada_console_command/Test_Script", "Deactivated_Code/Test_Script", "Deactivated_Compile_Time/Test_Script", "Deactivated_Engineering_test_page/Test_Script", "Deactivated_EXT_ATE_PRESENT/Test_Script", "Deactivated_Ground_testing_only/Test_Script", "Deactivated_IN_AIR_OR_ENG_ON/Test_Script", "Deactivated_INTEGRITY_serial_console_command/Test_Script", "Deactivated_J4_Connector/Test_Script", "Deactivated_Remote_SW_test_page/Test_Script", "Modify_Reqt", "Modify_Code", "Modify_Test", "Modify_Tooling", "Modify_Work_Product", "Modify_Reqt/Test_Script", "Modify_Code/Test_Script", "Modify_Test/Test_Script", "Modify_Tooling/Test_Script", "Modify_Work_Product/Test_Script"};
        return toReturn;
    }

    private static enum CoverageLevel {
        A,
        B,
        C;

    }

    private class WrapInt {
        private int value;

        private WrapInt(int initValue) {
            this.value = initValue;
        }

        private void inc() {
            ++this.value;
        }

        private void inc(int incAmt) {
            this.value += incAmt;
        }

        private int getValue() {
            return this.value;
        }
    }
}

