/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.disposition.rest.internal.importer;

import java.io.File;
import java.io.FileFilter;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.osee.disposition.model.Discrepancy;
import org.eclipse.osee.disposition.model.DispoItem;
import org.eclipse.osee.disposition.model.DispoItemData;
import org.eclipse.osee.disposition.model.OperationReport;
import org.eclipse.osee.disposition.rest.DispoImporterApi;
import org.eclipse.osee.disposition.rest.internal.DispoDataFactory;
import org.eclipse.osee.disposition.rest.internal.importer.DispoItemDataCopier;
import org.eclipse.osee.disposition.rest.internal.importer.TmzChildRecord;
import org.eclipse.osee.disposition.rest.internal.importer.TmzProperties;
import org.eclipse.osee.disposition.rest.internal.importer.TmzTestPoint;
import org.eclipse.osee.framework.core.JaxRsApi;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.GUID;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.logger.Log;

public class TmzImporter
implements DispoImporterApi {
    private final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("MMM dd, yyyy H:mm:ss aa", Locale.US);
    private final Log logger;
    private final DispoDataFactory dataFactory;
    private final JaxRsApi jaxRsApi;

    public TmzImporter(Log logger, DispoDataFactory dataFactory, JaxRsApi jaxRsApi) {
        this.logger = logger;
        this.dataFactory = dataFactory;
        this.jaxRsApi = jaxRsApi;
    }

    @Override
    public List<DispoItem> importDirectory(Map<String, DispoItem> exisitingItems, File filesDir, OperationReport report, Log logger, ArtifactReadable programConfig) {
        LinkedList<DispoItem> toReturn = new LinkedList<DispoItem>();
        if (!filesDir.exists() || !filesDir.isDirectory()) {
            throw new OseeArgumentException("Input directory does not exists or is not a directory [%s]", new Object[]{filesDir.getAbsolutePath()});
        }
        File[] files = filesDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return Lib.getExtension((String)pathname.getName()).equals("tmz");
            }
        });
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                block22: {
                    File file = fileArray[n2];
                    String scriptName = file.getName().replaceAll("\\..*", "");
                    DispoItem oldItem = exisitingItems.get(scriptName);
                    Date lastUpdate = oldItem != null ? oldItem.getLastUpdate() : new Date(0L);
                    DispoItemData itemToBuild = null;
                    HashMap<String, Discrepancy> discrepancies = null;
                    ZipFile zf = null;
                    try {
                        try {
                            zf = new ZipFile(file);
                            ZipEntry entry = zf.getEntry("Overview.json");
                            if (entry != null) {
                                InputStream inputStream = zf.getInputStream(entry);
                                String json = Lib.inputStreamToString((InputStream)inputStream);
                                itemToBuild = new DispoItemData();
                                itemToBuild.setName(scriptName);
                                this.processOverview(json, itemToBuild);
                                if (oldItem == null || !itemToBuild.getLastUpdate().after(lastUpdate)) {
                                    discrepancies = new HashMap<String, Discrepancy>();
                                    itemToBuild.setDiscrepanciesList(discrepancies);
                                    entry = zf.getEntry("TestPointSummary.json");
                                    if (entry != null) {
                                        inputStream = zf.getInputStream(entry);
                                        json = Lib.inputStreamToString((InputStream)inputStream);
                                        this.processTestPointSummary(json, discrepancies);
                                    }
                                    if (oldItem != null) {
                                        DispoItemDataCopier.copyOldItemData(oldItem, itemToBuild, report);
                                    } else {
                                        this.dataFactory.initDispoItem(itemToBuild);
                                    }
                                    toReturn.add((DispoItem)itemToBuild);
                                }
                            }
                        }
                        catch (Exception ex) {
                            logger.info((Throwable)ex, "Unable to process: [%s]", new Object[]{file.getAbsolutePath()});
                            if (zf != null) {
                                try {
                                    zf.close();
                                }
                                catch (Exception exception) {}
                            }
                            break block22;
                        }
                    }
                    catch (Throwable throwable) {
                        if (zf != null) {
                            try {
                                zf.close();
                            }
                            catch (Exception exception) {}
                        }
                        throw throwable;
                    }
                    if (zf != null) {
                        try {
                            zf.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                ++n2;
            }
        }
        return toReturn;
    }

    private void processOverview(String json, DispoItemData dispoItem) {
        try {
            TmzProperties properties = (TmzProperties)this.jaxRsApi.readValue(json, TmzProperties.class);
            dispoItem.setVersion(properties.getVersion_revision());
            Date date = this.DATE_FORMAT.parse(properties.getVersion_lastModificationDate());
            dispoItem.setCreationDate(date);
            dispoItem.setLastUpdate(date);
        }
        catch (Exception ex) {
            throw new OseeCoreException("Could not parse Tmz Properties Json", (Throwable)ex);
        }
    }

    private void processTestPointSummary(String json, Map<String, Discrepancy> discrepancies) {
        String node = this.jaxRsApi.readValue(json, "childRecords");
        List childRecords = (List)this.jaxRsApi.readCollectionValue(node, List.class, TmzChildRecord.class);
        for (TmzChildRecord record : childRecords) {
            int number = record.getNumber();
            List<TmzTestPoint> testPoints = record.getTestPoint();
            for (TmzTestPoint testPoint : testPoints) {
                boolean groupNameIsNull;
                boolean passed = testPoint.getPass();
                if (passed) continue;
                Discrepancy discrepancy = new Discrepancy();
                discrepancy.setLocation(String.valueOf(number));
                String id = GUID.create();
                discrepancy.setId(id);
                boolean bl = groupNameIsNull = testPoint.getGroupName() == null || testPoint.getGroupName().equals("");
                if (groupNameIsNull) {
                    String name = testPoint.getTestPointName();
                    String actual = testPoint.getActual();
                    String expected = testPoint.getExpected();
                    String text = String.format("Failure at Test Point %s. Check Point: %s. Expected: %s. Actual: %s. ", number, name, expected, actual);
                    discrepancy.setText(text);
                } else {
                    List<TmzTestPoint> tmzTestPoints = testPoint.getTestPoints();
                    StringBuilder text = new StringBuilder(String.format("Failure at Test Point %s. Check Group with Checkpoint Failures: ", number));
                    for (TmzTestPoint checkPoint : tmzTestPoints) {
                        String name = checkPoint.getTestPointName();
                        String actual = checkPoint.getActual();
                        String expected = checkPoint.getExpected();
                        text.append(String.format("Check Point: %s. Expected: %s. Actual: %s. ", name, expected, actual));
                    }
                    discrepancy.setText(text.toString());
                }
                discrepancies.put(id, discrepancy);
            }
        }
    }
}

